/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.random;

import ca.ubc.cs.beta.aclib.random.RandomFactory;
import ec.util.MersenneTwister;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SeedableRandomPool
implements Serializable {
    private static final long serialVersionUID = 8404659826687752125L;
    private final int poolSeed;
    private final RandomFactory<? extends Random> fact;
    private final Map<String, Random> randomMap = new ConcurrentHashMap<String, Random>();
    private final Map<String, Integer> randomSeedMap;
    private final Set<String> usedNames = new TreeSet<String>();
    private final Set<String> specifiedInitialSeeds;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Integer> originalSeeds;

    public SeedableRandomPool(long poolSeed) {
        this((int)poolSeed, new DefaultRandomFactory(MersenneTwister.class), Collections.emptyMap());
    }

    public SeedableRandomPool(int poolSeed) {
        this(poolSeed, new DefaultRandomFactory(MersenneTwister.class), Collections.emptyMap());
    }

    public SeedableRandomPool(int poolSeed, Class<? extends Random> randomClass) {
        this(poolSeed, new DefaultRandomFactory(randomClass), Collections.emptyMap());
    }

    public SeedableRandomPool(int poolSeed, RandomFactory<? extends Random> fact) {
        this(poolSeed, fact, Collections.emptyMap());
    }

    public SeedableRandomPool(int poolSeed, Map<String, Integer> initialSeeds) {
        this(poolSeed, new DefaultRandomFactory(MersenneTwister.class), initialSeeds);
    }

    public SeedableRandomPool(int poolSeed, Class<? extends Random> randomClass, Map<String, Integer> initialSeeds) {
        this(poolSeed, new DefaultRandomFactory(randomClass), initialSeeds);
    }

    public SeedableRandomPool(int poolSeed, RandomFactory<? extends Random> randomFactory, Map<String, Integer> initialSeeds) {
        this.poolSeed = poolSeed;
        this.fact = randomFactory;
        this.randomSeedMap = new ConcurrentHashMap<String, Integer>(initialSeeds);
        this.originalSeeds = Collections.unmodifiableMap(new HashMap<String, Integer>(initialSeeds));
        this.specifiedInitialSeeds = new HashSet<String>(initialSeeds.keySet());
    }

    public synchronized Map<String, Integer> getInitialSeeds() {
        return this.originalSeeds;
    }

    public synchronized Random getRandom(Enum<?> enumeration) {
        return this.getRandom(enumeration.name());
    }

    public synchronized Random getRandom(String name) {
        this.usedNames.add(name);
        Random random = this.randomMap.get(name);
        if (random == null) {
            Integer seed = this.randomSeedMap.get(name);
            if (seed == null) {
                seed = name.hashCode() ^ this.poolSeed;
                this.randomSeedMap.put(name, seed);
            }
            random = this.fact.getRandom(seed.intValue());
            this.randomMap.put(name, this.fact.getRandom(seed.intValue()));
        }
        return random;
    }

    public synchronized Map<String, Integer> getAllSeeds() {
        return new HashMap<String, Integer>(this.randomSeedMap);
    }

    public synchronized int getPoolSeed() {
        return this.poolSeed;
    }

    public synchronized Set<String> getUsedNames() {
        return new TreeSet<String>(this.usedNames);
    }

    public synchronized Set<String> getSpecifiedInitialNames() {
        return new TreeSet<String>(this.specifiedInitialSeeds);
    }

    public synchronized void logUsage() {
        this.log.debug("Seed for Seed Pool Was {}", (Object)this.poolSeed);
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.putAll(this.randomSeedMap);
        for (Map.Entry seedPair : map.entrySet()) {
            Object[] args = new Object[]{seedPair.getKey(), seedPair.getValue(), this.specifiedInitialSeeds.contains(seedPair.getKey()), this.usedNames.contains(seedPair.getKey())};
            this.log.debug("Seed for {} was {}, Manually Set: {}  Used: {}", args);
        }
    }

    private static class DefaultRandomFactory
    implements RandomFactory<Random> {
        private static final long serialVersionUID = -8877498257963036865L;
        private final Class<? extends Random> randomClass;

        public DefaultRandomFactory(Class<? extends Random> randomClass) {
            this.randomClass = randomClass;
        }

        @Override
        public Random getRandom(long seed) {
            try {
                Constructor<? extends Random> randConstruct = this.randomClass.getConstructor(Long.TYPE);
                if (randConstruct != null) {
                    return randConstruct.newInstance(seed);
                }
                randConstruct = this.randomClass.getConstructor(Integer.TYPE);
                if (randConstruct != null) {
                    if (seed <= Integer.MAX_VALUE && seed >= Integer.MIN_VALUE) {
                        return randConstruct.newInstance(seed);
                    }
                    throw new IllegalArgumentException("Seed (" + seed + ") specified is too big to fit in a integer, and we didn't find a long constructor");
                }
                throw new IllegalArgumentException("Could not find a constructor that took an long or an integer as it's only parameter");
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while generating random pool", e);
            }
        }
    }
}

