/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TimingCheckerTargetAlgorithmEvaluator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private double totalWallClockOverhead = 0.0;
    private double totalRuntimeOverhead = 0.0;
    private double totalWallClockVersusRuntimeDifference = 0.0;
    private double totalWalltime;
    private double totalRuntime;
    private static Logger log = LoggerFactory.getLogger(TimingCheckerTargetAlgorithmEvaluator.class);
    private double runtimeDeltaToRequireLogging = 1.0;
    private double wallClockDeltaToRequireLogging;

    public TimingCheckerTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, TargetAlgorithmEvaluator tae) {
        super(tae);
        this.wallClockDeltaToRequireLogging = Math.min(1.5 * execConfig.getAlgorithmCutoffTime(), 10.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyShutdown() {
        TimingCheckerTargetAlgorithmEvaluator timingCheckerTargetAlgorithmEvaluator = this;
        synchronized (timingCheckerTargetAlgorithmEvaluator) {
            log.info("Total Reported Runtime: {} (s), Total of Sum Max(runtime-cutoff,0): {} (s)", (Object)this.totalRuntime, (Object)this.totalRuntimeOverhead);
            log.info("Total Walltime: {} (s), Total of Sum Max(walltime - cutoff, 0): {} (s)", (Object)this.totalWalltime, (Object)this.totalWallClockOverhead);
            log.info("Total Difference between Walltime and Runtime (Sum of the amount of wallclock time - sum of the amount of reported CPU time) : {} seconds", (Object)this.totalWallClockVersusRuntimeDifference);
        }
        this.tae.notifyShutdown();
    }

    @Override
    protected synchronized AlgorithmRun processRun(AlgorithmRun run) {
        double runtimeOverhead = run.getRuntime() - run.getRunConfig().getCutoffTime();
        this.totalRuntime += Math.max(run.getRuntime(), 0.0);
        this.totalRuntimeOverhead += Math.max(runtimeOverhead, 0.0);
        if (runtimeOverhead > this.runtimeDeltaToRequireLogging) {
            this.runtimeDeltaToRequireLogging = runtimeOverhead + 1.0;
            Object[] args = new Object[]{run.getRuntime(), run.getRunConfig().getCutoffTime(), runtimeOverhead, this.runtimeDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported a runtime of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        double wallClockOverhead = run.getWallclockExecutionTime() - run.getRunConfig().getCutoffTime();
        this.totalWalltime += Math.max(run.getWallclockExecutionTime(), 0.0);
        this.totalWallClockOverhead += Math.max(wallClockOverhead, 0.0);
        if (wallClockOverhead > this.wallClockDeltaToRequireLogging) {
            this.wallClockDeltaToRequireLogging = wallClockOverhead + 1.0;
            Object[] args = new Object[]{run.getWallclockExecutionTime(), run.getRunConfig().getCutoffTime(), wallClockOverhead, this.wallClockDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported wallclock time of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        this.totalWallClockVersusRuntimeDifference += Math.max(run.getWallclockExecutionTime() - run.getRuntime(), 0.0);
        return run;
    }
}

