/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.prepostcommand;

import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.prepostcommand.PrePostCommandErrorException;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.prepostcommand.PrePostCommandOptions;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrePostCommandTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final PrePostCommandOptions options;
    private static final Logger log = LoggerFactory.getLogger(PrePostCommandTargetAlgorithmEvaluator.class);

    public PrePostCommandTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae, PrePostCommandOptions options) {
        super(tae);
        this.options = options;
        this.runCommand(options.preCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(String command) {
        if (command == null || command.trim().length() == 0) {
            return;
        }
        log.info("Running scenario command: cd {} ; {}", (Object)this.options.directory.getAbsolutePath(), (Object)command);
        try {
            ExecutorService execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Pre Post Command Handler"));
            try {
                final Process proc = Runtime.getRuntime().exec(command, null, this.options.directory);
                final CountDownLatch cLatch = new CountDownLatch(1 + (this.options.logOutput ? 1 : 0));
                Runnable standardErrorReader = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Scanner procIn = new Scanner(proc.getErrorStream());
                            while (procIn.hasNext()) {
                                log.warn("[PROCESS]  {}", (Object)procIn.nextLine());
                            }
                            procIn.close();
                        }
                        finally {
                            cLatch.countDown();
                        }
                    }
                };
                execService.submit(standardErrorReader);
                if (this.options.logOutput) {
                    Runnable standardOutReader = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Scanner procIn = new Scanner(proc.getInputStream());
                                while (procIn.hasNext()) {
                                    log.info("[PROCESS]  {}", (Object)procIn.nextLine());
                                }
                                procIn.close();
                            }
                            finally {
                                cLatch.countDown();
                            }
                        }
                    };
                    execService.submit(standardOutReader);
                }
                cLatch.await();
                int resultCode = proc.waitFor();
                if (resultCode != 0) {
                    if (this.options.exceptionOnError) {
                        throw new PrePostCommandErrorException("Got a non-zero return code ");
                    }
                    log.warn("Got a non-zero return code from process: {}", (Object)resultCode);
                }
            }
            finally {
                execService.shutdown();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Pre/Post Command Running was interrupted");
            return;
        }
        catch (IOException e) {
            throw new PrePostCommandErrorException("An error occurred while running command: " + command, e);
        }
    }

    @Override
    public void notifyShutdown() {
        this.tae.notifyShutdown();
        this.runCommand(this.options.postCommand);
    }
}

