/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.validation;

import au.com.bytecode.opencsv.CSVWriter;
import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.DeveloperMadeABooBooException;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.SetInstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.ValidationOptions;
import ca.ubc.cs.beta.aclib.smac.ValidationRoundingMode;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.WaitableTAECallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFile;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static Logger log = LoggerFactory.getLogger(Validator.class);

    public SortedMap<TrajectoryFileEntry, Double> simpleValidate(List<ProblemInstance> testInstances, ValidationOptions options, double cutoffTime, InstanceSeedGenerator testInstGen, TargetAlgorithmEvaluator validatingTae, String outputDir, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, TrajectoryFile trajFile, boolean waitForRuns, int cores, AlgorithmExecutionConfig execConfig) {
        options.outputFileSuffix = options.useWallClockTime ? "walltime" + (options.outputFileSuffix.trim().length() > 0 ? "-" + options.outputFileSuffix : "") : "tunertime" + (options.outputFileSuffix.trim().length() > 0 ? "-" + options.outputFileSuffix : "");
        List<ProblemInstanceSeedPair> pisps = this.getProblemInstanceSeedPairsToRun(testInstances, options, testInstGen);
        ValidationRuns runs = this.validateStage(pisps, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, trajFile, execConfig);
        if (runs.done) {
            return runs.result;
        }
        HashSet<ParamConfiguration> configs = new HashSet<ParamConfiguration>();
        for (RunConfig rc : runs.runConfigs) {
            configs.add(rc.getParamConfiguration());
        }
        log.info("Validation needs {} algorithm runs to validate {} configurations found, each on {} problem instance seed pairs", new Object[]{runs.runConfigs.size(), configs.size(), pisps.size()});
        Date d = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance();
        if (cutoffTime > Math.pow(10.0, 10.0)) {
            log.info("Validation start time: {}. Approximate worst-case end time is unknown.", (Object)df.format(d));
        } else {
            Date endTime = new Date(System.currentTimeMillis() + (long)(1.1 * (cutoffTime * (double)runs.runConfigs.size() * 1000.0 / (double)cores)));
            log.info("Validation start time: {}. Approximate worst-case end time: {}", (Object)df.format(d), (Object)df.format(endTime));
        }
        validatingTae.evaluateRunsAsync(runs.runConfigs, (TargetAlgorithmEvaluatorCallback)runs.callback);
        if (!validatingTae.areRunsPersisted() || waitForRuns) {
            log.debug("Waiting until validation completion");
            runs.callback.waitForCompletion();
        }
        if (runs.exception.get() != null) {
            throw (RuntimeException)runs.exception.get();
        }
        return runs.result;
    }

    public void multiValidate(List<ProblemInstance> testInstances, ValidationOptions options, double cutoffTime, InstanceSeedGenerator testInstGen, TargetAlgorithmEvaluator validatingTae, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, Set<TrajectoryFile> tfes, boolean waitForRuns, int cores, AlgorithmExecutionConfig execConfig) {
        options.outputFileSuffix = options.useWallClockTime ? "walltime" + options.outputFileSuffix : "tunertime" + options.outputFileSuffix;
        List<ProblemInstanceSeedPair> pisps = this.getProblemInstanceSeedPairsToRun(testInstances, options, testInstGen);
        ArrayList<ValidationRuns> runs = new ArrayList<ValidationRuns>();
        if (tfes.size() > 1) {
            log.debug("Beginning multi-validation on {} files ", (Object)tfes.size());
        }
        for (TrajectoryFile tfe : tfes) {
            runs.add(this.validateStage(pisps, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, tfe, execConfig));
        }
        LinkedHashSet<RunConfig> runConfigs = new LinkedHashSet<RunConfig>();
        HashSet<ParamConfiguration> configs = new HashSet<ParamConfiguration>();
        final LinkedHashMap<WaitableTAECallback, List<RunConfig>> callbacksToSchedule = new LinkedHashMap<WaitableTAECallback, List<RunConfig>>();
        for (ValidationRuns run : runs) {
            if (run.done) continue;
            for (RunConfig rc : run.runConfigs) {
                runConfigs.add(rc);
                configs.add(rc.getParamConfiguration());
            }
            callbacksToSchedule.put(run.callback, run.runConfigs);
        }
        ArrayList runConfigsToRun = new ArrayList(runConfigs);
        log.info("Validation needs {} algorithm runs to validate {} configurations found, each on {} problem instance seed pairs", new Object[]{runConfigsToRun.size(), configs.size(), pisps.size()});
        Date d = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance();
        if (cutoffTime > Math.pow(10.0, 10.0)) {
            log.info("Validation start time: {}. Approximate worst-case end time is unknown.", (Object)df.format(d));
        } else {
            Date endTime = new Date(System.currentTimeMillis() + (long)(1.1 * (cutoffTime * (double)runConfigsToRun.size() * 1000.0 / (double)cores)));
            log.info("Validation start time: {}. Approximate worst-case end time: {}", (Object)df.format(d), (Object)df.format(endTime));
        }
        final AtomicReference exception = new AtomicReference();
        WaitableTAECallback taeCallback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

            public void onSuccess(List<AlgorithmRun> runs) {
                HashMap<RunConfig, AlgorithmRun> runsToRunConfig = new HashMap<RunConfig, AlgorithmRun>();
                for (AlgorithmRun algorithmRun : runs) {
                    runsToRunConfig.put(algorithmRun.getRunConfig(), algorithmRun);
                }
                for (Map.Entry entry : callbacksToSchedule.entrySet()) {
                    ArrayList runsToNotify = new ArrayList();
                    for (RunConfig rc : (List)entry.getValue()) {
                        runsToNotify.add(runsToRunConfig.get(rc));
                    }
                    try {
                        ((WaitableTAECallback)entry.getKey()).onSuccess(runsToNotify);
                    }
                    catch (RuntimeException e) {
                        log.error("Error occurred while saving runs:", (Throwable)e);
                    }
                }
            }

            public void onFailure(RuntimeException e) {
                exception.set(e);
            }
        });
        validatingTae.evaluateRunsAsync(runConfigsToRun, (TargetAlgorithmEvaluatorCallback)taeCallback);
        if (!validatingTae.areRunsPersisted() || waitForRuns) {
            log.debug("Waiting until validation completion");
            taeCallback.waitForCompletion();
        }
        if (exception.get() != null) {
            throw (RuntimeException)exception.get();
        }
    }

    private ValidationRuns validateStage(List<ProblemInstanceSeedPair> pisps, final ValidationOptions options, final double cutoffTime, final RunObjective runObj, final OverallObjective intraInstanceObjective, final OverallObjective interInstanceObjective, final TrajectoryFile trajFile, final AlgorithmExecutionConfig execConfig) {
        double maxWallTimeStamp = 0.0;
        double maxTunerTimeStamp = 0.0;
        final List tfes = trajFile.getTrajectoryFileEntries();
        for (TrajectoryFileEntry tfe : tfes) {
            maxWallTimeStamp = Math.max(tfe.getWallTime(), maxWallTimeStamp);
            maxTunerTimeStamp = Math.max(tfe.getTunerTime(), maxTunerTimeStamp);
        }
        if (options.validateOnlyIfWallTimeReached > maxWallTimeStamp) {
            log.info("Maximum walltime was {} but we required {} seconds to have passed validating ", (Object)maxWallTimeStamp, (Object)options.validateOnlyIfWallTimeReached);
            return new ValidationRuns(new TreeMap<TrajectoryFileEntry, Double>());
        }
        if (options.validateOnlyIfTunerTimeReached > maxTunerTimeStamp) {
            log.info("Maximum Tuner Time was {} but we required {} seconds to have passed before validating ", (Object)maxTunerTimeStamp, (Object)options.validateOnlyIfTunerTimeReached);
            return new ValidationRuns(new TreeMap<TrajectoryFileEntry, Double>());
        }
        TreeSet<TrajectoryFileEntry> tfesToUse = new TreeSet<TrajectoryFileEntry>();
        if (options.validateAll) {
            tfesToUse.addAll(tfes);
        } else if (options.validateOnlyLastIncumbent) {
            TrajectoryFileEntry newTfe;
            TrajectoryFileEntry tfe;
            log.trace("Validating only the last incumbent");
            if (options.useWallClockTime) {
                tfe = (TrajectoryFileEntry)tfes.get(tfes.size() - 1);
                double wallTime = tfe.getWallTime() > options.maxTimestamp ? options.maxTimestamp : tfe.getWallTime();
                newTfe = new TrajectoryFileEntry(tfe.getConfiguration(), tfe.getTunerTime(), wallTime, tfe.getEmpericalPerformance(), tfe.getACOverhead());
                tfesToUse.add(newTfe);
            } else {
                tfe = (TrajectoryFileEntry)tfes.get(tfes.size() - 1);
                double tunerTime = tfe.getTunerTime() > options.maxTimestamp ? options.maxTimestamp : tfe.getTunerTime();
                newTfe = new TrajectoryFileEntry(tfe.getConfiguration(), tunerTime, tfe.getWallTime(), tfe.getEmpericalPerformance(), tfe.getACOverhead());
                tfesToUse.add(newTfe);
            }
        } else {
            ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
            for (TrajectoryFileEntry tfe : tfes) {
                if (options.useWallClockTime) {
                    skipList.put(tfe.getWallTime(), tfe);
                    continue;
                }
                skipList.put(tfe.getTunerTime(), tfe);
            }
            double maxTimestamp = options.maxTimestamp;
            if (maxTimestamp == -1.0) {
                maxTimestamp = skipList.floorKey((Double)Double.MAX_VALUE);
            }
            ParamConfiguration lastConfig = null;
            Double lastPerformance = Double.MAX_VALUE;
            for (double x = maxTimestamp; x > options.minTimestamp; x /= options.multFactor) {
                Map.Entry tfeEntry = skipList.floorEntry(x);
                TrajectoryFileEntry tfe = tfeEntry != null ? (TrajectoryFileEntry)tfeEntry.getValue() : new TrajectoryFileEntry(lastConfig, 0.0, 0.0, lastPerformance.doubleValue(), 0.0);
                if (options.useWallClockTime) {
                    tfesToUse.add(new TrajectoryFileEntry(tfe.getConfiguration(), x, x, tfe.getEmpericalPerformance(), tfe.getACOverhead()));
                } else {
                    tfesToUse.add(new TrajectoryFileEntry(tfe.getConfiguration(), x, tfe.getWallTime(), tfe.getEmpericalPerformance(), tfe.getACOverhead()));
                }
                lastConfig = tfe.getConfiguration();
                lastPerformance = tfe.getEmpericalPerformance();
                if (x < 0.01) break;
            }
        }
        final ArrayList<TrajectoryFileEntry> tfesToRun = new ArrayList<TrajectoryFileEntry>(tfesToUse.size());
        tfesToRun.addAll(tfesToUse);
        LinkedHashSet<ParamConfiguration> configs = new LinkedHashSet<ParamConfiguration>();
        final LinkedHashMap<ParamConfiguration, Integer> configToID = new LinkedHashMap<ParamConfiguration, Integer>();
        int id = 1;
        for (TrajectoryFileEntry tfe : tfesToRun) {
            if (!configs.add(tfe.getConfiguration())) continue;
            configToID.put(tfe.getConfiguration(), id++);
        }
        List<RunConfig> runConfigs = this.getRunConfigs(configs, pisps, cutoffTime);
        final AtomicReference<RuntimeException> exception = new AtomicReference<RuntimeException>();
        final ConcurrentSkipListMap<TrajectoryFileEntry, Double> finalPerformance = new ConcurrentSkipListMap<TrajectoryFileEntry, Double>();
        WaitableTAECallback callback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

            public void onSuccess(List<AlgorithmRun> runs) {
                try {
                    Validator.writeConfigurationMapFile(trajFile, options, configToID, execConfig, runs);
                }
                catch (IOException e) {
                    log.error("Could not write results file", (Throwable)e);
                }
                try {
                    Map testSetPerformance = Validator.writeInstanceResultFile(runs, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, trajFile, configToID);
                    for (TrajectoryFileEntry tfe : tfesToRun) {
                        finalPerformance.put(tfe, testSetPerformance.get(tfe.getConfiguration()));
                    }
                    if (runs.size() > 0) {
                        Validator.this.appendInstanceResultFile(finalPerformance, trajFile, options, options.useWallClockTime, configToID);
                    }
                }
                catch (IOException e) {
                    log.error("Could not write results file:", (Throwable)e);
                }
                try {
                    ConcurrentHashMap matrixRuns = new ConcurrentHashMap();
                    for (AlgorithmRun run : runs) {
                        matrixRuns.putIfAbsent(run.getRunConfig().getParamConfiguration(), new HashMap());
                        Map configRuns = (Map)matrixRuns.get(run.getRunConfig().getParamConfiguration());
                        configRuns.put(run.getRunConfig().getProblemInstanceSeedPair(), run);
                    }
                    ArrayList<ParamConfiguration> configs = new ArrayList<ParamConfiguration>();
                    for (AlgorithmRun run : runs) {
                        if (configs.contains(run.getRunConfig().getParamConfiguration())) continue;
                        configs.add(run.getRunConfig().getParamConfiguration());
                    }
                    Validator.writeConfigurationResultsMatrix(configs, matrixRuns, tfes, options, trajFile, runObj, configToID);
                }
                catch (IOException e) {
                    log.error("Could not write matrix file:", (Throwable)e);
                }
                if (options.saveStateFile) {
                    try {
                        Validator.writeLegacyStateFile(options.outputFileSuffix, runs, trajFile, interInstanceObjective, interInstanceObjective, runObj);
                    }
                    catch (RuntimeException e) {
                        log.error("Couldn't write state file:", (Throwable)e);
                    }
                }
            }

            public void onFailure(RuntimeException t) {
                exception.set(t);
            }
        });
        return new ValidationRuns(runConfigs, callback, exception, finalPerformance);
    }

    private List<ProblemInstanceSeedPair> getProblemInstanceSeedPairsToRun(List<ProblemInstance> testInstances, ValidationOptions options, InstanceSeedGenerator testInstGen) {
        int testInstancesCount = Math.min(options.numberOfTestInstances, testInstances.size());
        int testSeedsPerInstance = options.numberOfTestSeedsPerInstance;
        int validationRunsCount = options.numberOfValidationRuns;
        ValidationRoundingMode mode = options.validationRoundingMode;
        List<Object> pisps = new ArrayList();
        if (testInstGen instanceof SetInstanceSeedGenerator) {
            if (validationRunsCount > testInstGen.getInitialInstanceSeedCount()) {
                log.debug("Clamping number of validation runs from {} to {} due to seed limit", (Object)validationRunsCount, (Object)testInstGen.getInitialInstanceSeedCount());
                validationRunsCount = testInstGen.getInitialInstanceSeedCount();
            }
            pisps = Validator.getValidationRuns(testInstances, (SetInstanceSeedGenerator)testInstGen, mode, validationRunsCount);
        } else if (testInstGen instanceof RandomInstanceSeedGenerator) {
            pisps = Validator.getValidationRuns(testInstances, (RandomInstanceSeedGenerator)testInstGen, mode, validationRunsCount, testSeedsPerInstance, testInstancesCount);
        } else {
            throw new IllegalStateException("Unknown Instance Seed Generator specified");
        }
        return Collections.unmodifiableList(pisps);
    }

    private List<RunConfig> getRunConfigs(Set<ParamConfiguration> configs, List<ProblemInstanceSeedPair> pisps, double cutoffTime) {
        ArrayList<RunConfig> runConfigs = new ArrayList<RunConfig>(pisps.size() * configs.size());
        for (ParamConfiguration config : configs) {
            for (ProblemInstanceSeedPair pisp : pisps) {
                runConfigs.add(new RunConfig(pisp, cutoffTime, config));
            }
        }
        return runConfigs;
    }

    private static List<ProblemInstanceSeedPair> getValidationRuns(List<ProblemInstance> pis, RandomInstanceSeedGenerator testInstGen, ValidationRoundingMode mode, int validationRunsCount, int testSeedsPerInstance, int testInstancesCount) {
        int numRuns = 0;
        switch (mode) {
            case UP: {
                numRuns = Math.round((float)(Math.ceil((float)validationRunsCount / (float)testInstancesCount) * (double)testInstancesCount));
                break;
            }
            case NONE: {
                numRuns = Math.min(validationRunsCount, testSeedsPerInstance * testInstancesCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Rounding Mode");
            }
        }
        List pisToUse = testInstGen.getProblemInstanceOrder(pis);
        int runsScheduled = 0;
        ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>(numRuns);
        block4: while (true) {
            int i = 0;
            while (true) {
                if (i >= testInstancesCount) continue block4;
                ProblemInstance pi = (ProblemInstance)pisToUse.get(i);
                pisps.add(new ProblemInstanceSeedPair(pi, (long)testInstGen.getNextSeed(pi)));
                if (++runsScheduled >= numRuns) break block4;
                ++i;
            }
            break;
        }
        return pisps;
    }

    private static List<ProblemInstanceSeedPair> getValidationRuns(List<ProblemInstance> pis, SetInstanceSeedGenerator testInstGen, ValidationRoundingMode mode, int validationRunsCount) {
        List instances = testInstGen.getProblemInstanceOrder(pis);
        int numRuns = 0;
        switch (mode) {
            case UP: {
                numRuns = Math.round((float)(Math.ceil((float)validationRunsCount / (float)instances.size()) * (double)instances.size()));
                break;
            }
            case NONE: {
                numRuns = Math.min(instances.size(), validationRunsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode: " + mode);
            }
        }
        ArrayList<ProblemInstanceSeedPair> runs = new ArrayList<ProblemInstanceSeedPair>(numRuns);
        for (int i = 0; i < numRuns; ++i) {
            ProblemInstance pi = (ProblemInstance)instances.get(i);
            runs.add(new ProblemInstanceSeedPair(pi, (long)testInstGen.getNextSeed(pi)));
        }
        return runs;
    }

    private static void writeConfigurationMapFile(TrajectoryFile trajFile, ValidationOptions validationOptions, Map<ParamConfiguration, Integer> configToID, AlgorithmExecutionConfig execConfig, List<AlgorithmRun> runs) throws IOException {
        File f = Validator.getFile(trajFile, "validationCallStrings", validationOptions.outputFileSuffix, "csv");
        log.debug("Instance Seed Result File Written to: {}", (Object)f.getAbsolutePath());
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(f));
        if (validationOptions.validationHeaders) {
            String[] args = new String[]{"Validation Configuration ID", "Configuration ", "Sample Call String"};
            writer.writeNext(args);
        }
        for (Map.Entry<ParamConfiguration, Integer> ent : configToID.entrySet()) {
            RunConfig rc = null;
            for (AlgorithmRun run : runs) {
                if (!run.getRunConfig().getParamConfiguration().equals((Object)ent.getKey())) continue;
                rc = run.getRunConfig();
                break;
            }
            String[] args = new String[]{String.valueOf(ent.getValue()), ent.getKey().getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString((AlgorithmExecutionConfig)execConfig, (RunConfig)rc)};
            writer.writeNext(args);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigurationResultsMatrix(List<ParamConfiguration> inOrderConfigs, ConcurrentHashMap<ParamConfiguration, Map<ProblemInstanceSeedPair, AlgorithmRun>> matrixRuns, List<TrajectoryFileEntry> tfes, ValidationOptions validationOptions, TrajectoryFile trajFile, RunObjective runObj, Map<ParamConfiguration, Integer> idMap) throws IOException {
        File configurationObjective = Validator.getFile(trajFile, "configurationObjectiveMatrix", validationOptions.outputFileSuffix, "csv");
        File configurationRun = Validator.getFile(trajFile, "configurationRunMatrix", validationOptions.outputFileSuffix, "csv");
        log.debug("Validation Configuration/PISP Matrix of objectives Written to: {}", (Object)configurationObjective.getAbsolutePath());
        log.debug("Validation Configuration/PISP Matrix of runs Written to: {}", (Object)configurationRun.getAbsolutePath());
        CSVWriter objectiveMatrixCSV = new CSVWriter((Writer)new FileWriter(configurationObjective));
        CSVWriter runMatrixCSV = new CSVWriter((Writer)new FileWriter(configurationRun));
        try {
            ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>();
            HashSet<ParamConfiguration> doneConfigs = new HashSet<ParamConfiguration>();
            for (ParamConfiguration config : inOrderConfigs) {
                if (doneConfigs.contains(config)) continue;
                doneConfigs.add(config);
                Map<ProblemInstanceSeedPair, AlgorithmRun> runs = matrixRuns.get(config);
                if (runs == null) continue;
                if (pisps.isEmpty()) {
                    pisps.addAll(runs.keySet());
                    Collections.sort(pisps, new Comparator<ProblemInstanceSeedPair>(){

                        @Override
                        public int compare(ProblemInstanceSeedPair o1, ProblemInstanceSeedPair o2) {
                            if (o1.getInstance().equals((Object)o2.getInstance())) {
                                return (int)Math.signum(o1.getSeed() - o2.getSeed());
                            }
                            return o1.getInstance().getInstanceID() - o2.getInstance().getInstanceID();
                        }
                    });
                    ArrayList<String> headerRow = new ArrayList<String>();
                    headerRow.add("Validation Configuration ID");
                    for (ProblemInstanceSeedPair pisp : pisps) {
                        headerRow.add(pisp.getInstance().getInstanceName() + "," + pisp.getSeed());
                    }
                    String[] header = headerRow.toArray(new String[0]);
                    objectiveMatrixCSV.writeNext(header);
                    runMatrixCSV.writeNext(header);
                }
                ArrayList<String> objectiveRow = new ArrayList<String>();
                ArrayList<String> resultLineRow = new ArrayList<String>();
                objectiveRow.add(String.valueOf(idMap.get(config)));
                resultLineRow.add(String.valueOf(idMap.get(config)));
                for (ProblemInstanceSeedPair pisp : pisps) {
                    AlgorithmRun run = runs.get(pisp);
                    if (run == null) {
                        throw new IllegalStateException("Expected all configurations to have the exact same pisps");
                    }
                    if (!run.getRunConfig().getProblemInstanceSeedPair().equals((Object)pisp)) {
                        throw new IllegalStateException("DataStructure corruption detected ");
                    }
                    objectiveRow.add(String.valueOf(runObj.getObjective(run)));
                    resultLineRow.add(run.getResultLine());
                }
                String[] nextRow = objectiveRow.toArray(new String[0]);
                String[] nextRunRow = resultLineRow.toArray(new String[0]);
                objectiveMatrixCSV.writeNext(nextRow);
                runMatrixCSV.writeNext(nextRunRow);
            }
        }
        finally {
            objectiveMatrixCSV.close();
            runMatrixCSV.close();
        }
    }

    private static Map<ParamConfiguration, Double> writeInstanceResultFile(List<AlgorithmRun> runs, ValidationOptions validationOptions, double cutoffTime, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, TrajectoryFile trajFile, Map<ParamConfiguration, Integer> configIDToMap) throws IOException {
        File f = Validator.getFile(trajFile, "validationPerformanceDebug", validationOptions.outputFileSuffix, "csv");
        log.debug("Instance Validation Matrix Result Written to: {}", (Object)f.getAbsolutePath());
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(f));
        LinkedHashMap<ParamConfiguration, Double> calculatedOverallObjectives = new LinkedHashMap<ParamConfiguration, Double>();
        LinkedHashMap configToRunMap = new LinkedHashMap();
        for (AlgorithmRun algorithmRun : runs) {
            ParamConfiguration config = algorithmRun.getRunConfig().getParamConfiguration();
            if (configToRunMap.get(config) == null) {
                configToRunMap.put(config, new ArrayList(1000));
            }
            ((List)configToRunMap.get(config)).add(algorithmRun);
        }
        for (Map.Entry entry : configToRunMap.entrySet()) {
            LinkedHashMap map = new LinkedHashMap();
            runs = (List)entry.getValue();
            int maxRunLength = 0;
            for (AlgorithmRun run : runs) {
                ProblemInstance pi = run.getRunConfig().getProblemInstanceSeedPair().getInstance();
                if (map.get(pi) == null) {
                    map.put(pi, new ArrayList());
                }
                List myRuns = (List)map.get(pi);
                myRuns.add(run);
                maxRunLength = Math.max(myRuns.size(), maxRunLength);
            }
            ArrayList<String> headerRow = new ArrayList<String>();
            headerRow.add("Validation Configuration ID:" + configIDToMap.get(entry.getKey()));
            headerRow.add("Instance");
            headerRow.add("OverallObjective");
            for (int i = 1; i <= maxRunLength; ++i) {
                headerRow.add("Run #" + i);
            }
            writer.writeNext(headerRow.toArray(new String[0]));
            ArrayList<Double> overallObjectives = new ArrayList<Double>();
            for (Map.Entry piRuns : map.entrySet()) {
                ArrayList<String> outputLine = new ArrayList<String>();
                outputLine.add("");
                outputLine.add(((ProblemInstance)piRuns.getKey()).getInstanceName());
                List myRuns = (List)piRuns.getValue();
                ArrayList<Double> results = new ArrayList<Double>(myRuns.size());
                for (int i = 0; i < myRuns.size(); ++i) {
                    results.add(runObj.getObjective((AlgorithmRun)myRuns.get(i)));
                }
                double overallResult = intraInstanceObjective.aggregate(results, cutoffTime);
                outputLine.add(String.valueOf(overallResult));
                overallObjectives.add(overallResult);
                for (AlgorithmRun run : (List)piRuns.getValue()) {
                    outputLine.add(String.valueOf(runObj.getObjective(run)));
                }
                writer.writeNext(outputLine.toArray(new String[0]));
            }
            double overallObjective = interInstanceObjective.aggregate(overallObjectives, cutoffTime);
            String[] args = new String[]{"", "Overall Objective On Test Set", String.valueOf(overallObjective)};
            writer.writeNext(args);
            calculatedOverallObjectives.put((ParamConfiguration)entry.getKey(), overallObjective);
        }
        writer.close();
        return calculatedOverallObjectives;
    }

    private static File getFile(TrajectoryFile trajFile, String filename, String suffix, String extension) {
        suffix = suffix.trim().equals("") ? "" : "-" + suffix.trim();
        String trajectoryFileName = trajFile.getLocation().getName();
        String baseName = trajectoryFileName.lastIndexOf(".") >= 0 ? trajectoryFileName.substring(0, trajectoryFileName.lastIndexOf(".")) : trajectoryFileName;
        File f = new File(trajFile.getLocation().getParent() + File.separator + filename + "-" + baseName + suffix + "." + extension.replaceAll(Matcher.quoteReplacement("\\."), ""));
        return f;
    }

    private void appendInstanceResultFile(Map<TrajectoryFileEntry, Double> finalPerformance, TrajectoryFile trajFile, ValidationOptions validationOptions, boolean useWallTime, Map<ParamConfiguration, Integer> idMap) throws IOException {
        File validationFile = Validator.getFile(trajFile, "validationResults", validationOptions.outputFileSuffix, "csv");
        log.debug("Validation Results File Written to: {}", (Object)validationFile.getAbsolutePath());
        if (!validationFile.exists()) {
            validationFile.createNewFile();
        } else {
            validationFile.delete();
            validationFile.createNewFile();
        }
        StringBuilder sbValidation = new StringBuilder("\"Time\",\"Training (Empirical) Performance\",\"Test Set Performance\",\"AC Overhead Time\",\"Validation Configuration ID\",\n");
        for (Map.Entry<TrajectoryFileEntry, Double> ent : finalPerformance.entrySet()) {
            double time = useWallTime ? ent.getKey().getWallTime() : ent.getKey().getTunerTime();
            double empiricalPerformance = ent.getKey().getEmpericalPerformance();
            double testSetPerformance = ent.getValue();
            double acOverhead = ent.getKey().getACOverhead();
            sbValidation.append(time).append(",").append(empiricalPerformance).append(",").append(testSetPerformance).append(",").append(acOverhead).append(",\"").append(idMap.get(ent.getKey().getConfiguration())).append("\",\n");
        }
        if (!validationFile.canWrite()) {
            log.error("Could not write trajectory file would have written: {}", (Object)sbValidation.toString());
        } else {
            PrintWriter output = new PrintWriter(new FileOutputStream(validationFile, true));
            output.append(sbValidation);
            output.close();
        }
    }

    private static void writeLegacyStateFile(String suffix, List<AlgorithmRun> runs, TrajectoryFile trajFile, OverallObjective interRunObjective, OverallObjective intraRunObjective, RunObjective runObj) {
        NewRunHistory rh = new NewRunHistory(interRunObjective, intraRunObjective, runObj);
        for (AlgorithmRun run : runs) {
            try {
                rh.append(run);
            }
            catch (DuplicateRunException e) {
                throw new DeveloperMadeABooBooException("Duplicate run was detected by runHistory, this shouldn't be possible in validation");
            }
        }
        LegacyStateFactory sf = new LegacyStateFactory(trajFile.getLocation().getParent() + File.separator + "state" + suffix + "-run-" + trajFile.getLocation().getName(), null);
        StateSerializer ss = sf.getStateSerializer("it", 1);
        ss.setRunHistory((RunHistory)rh);
        ss.save();
    }

    public static class ValidationRuns {
        List<RunConfig> runConfigs;
        WaitableTAECallback callback;
        private SortedMap<TrajectoryFileEntry, Double> result;
        private AtomicReference<RuntimeException> exception;
        public boolean done;

        public ValidationRuns(SortedMap<TrajectoryFileEntry, Double> result) {
            this.result = result;
            this.runConfigs = Collections.emptyList();
            this.done = true;
        }

        public ValidationRuns(List<RunConfig> runConfigs, WaitableTAECallback callback, AtomicReference<RuntimeException> exception, SortedMap<TrajectoryFileEntry, Double> result) {
            this.runConfigs = runConfigs;
            this.callback = callback;
            this.exception = exception;
            this.result = result;
            this.done = false;
        }
    }
}

