/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.RunningAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAlgorithmRunner
implements AlgorithmRunner {
    protected final AlgorithmExecutionConfig execConfig;
    protected final List<RunConfig> runConfigs;
    protected final List<AlgorithmRun> runs;
    private final ExecutorService execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Command Line Algorithm Runner (not run) Thread"));
    private static final Logger log = LoggerFactory.getLogger(AbstractAlgorithmRunner.class);
    private final AtomicBoolean shutdownRunnerRequested = new AtomicBoolean(false);
    private final Semaphore shutdownRunnerCompleted = new Semaphore(0);
    private final Semaphore updatedRunMapSemaphore = new Semaphore(0);

    public AbstractAlgorithmRunner(AlgorithmExecutionConfig execConfig, final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        if (execConfig == null || runConfigs == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.execConfig = execConfig;
        this.runConfigs = runConfigs;
        ArrayList<AlgorithmRun> runs = new ArrayList<AlgorithmRun>(runConfigs.size());
        final ConcurrentHashMap<RunConfig, RunningAlgorithmRun> runConfigToLatestUpdatedRunMap = new ConcurrentHashMap<RunConfig, RunningAlgorithmRun>(runConfigs.size());
        final ConcurrentHashMap<RunConfig, Integer> runConfigToPositionInListMap = new ConcurrentHashMap<RunConfig, Integer>(runConfigs.size());
        int i = 0;
        for (RunConfig rc : runConfigs) {
            StatusVariableKillHandler killH = new StatusVariableKillHandler();
            runConfigToPositionInListMap.put(rc, i);
            runConfigToLatestUpdatedRunMap.put(rc, new RunningAlgorithmRun(execConfig, rc, 0.0, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), 0.0, killH));
            TargetAlgorithmEvaluatorRunObserver individualRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

                @Override
                public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                    if (((KillableAlgorithmRun)runConfigToLatestUpdatedRunMap.get(runs.get(0).getRunConfig())).isRunCompleted() && !runs.get(0).isRunCompleted()) {
                        StringBuilder sb = new StringBuilder("Current Run Status being notified: " + runs.get(0).getRunConfig());
                        sb.append("\n Current status in table").append(((KillableAlgorithmRun)runConfigToLatestUpdatedRunMap.get(runs.get(0).getRunConfig())).getRunConfig());
                        IllegalStateException e = new IllegalStateException("RACE CONDITION: " + sb.toString());
                        log.error("Some kind of race condition has occurred", (Throwable)e);
                        e.printStackTrace();
                        throw e;
                    }
                    runConfigToLatestUpdatedRunMap.put(runs.get(0).getRunConfig(), runs.get(0));
                    AbstractAlgorithmRunner.this.updatedRunMapSemaphore.release();
                }
            };
            CommandLineAlgorithmRun run = new CommandLineAlgorithmRun(execConfig, rc, individualRunObserver, killH, options, executionIDs);
            runs.add(run);
            ++i;
        }
        this.runs = runs;
        ++i;
        Runnable runStatusWatchingThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: {
                    try {
                        while (true) {
                            try {
                                do {
                                    AbstractAlgorithmRunner.this.updatedRunMapSemaphore.acquire();
                                    AbstractAlgorithmRunner.this.updatedRunMapSemaphore.drainPermits();
                                    if (AbstractAlgorithmRunner.this.shutdownRunnerRequested.get()) {
                                        break block13;
                                    }
                                    KillableAlgorithmRun[] runs = new KillableAlgorithmRun[runConfigs.size()];
                                    boolean outstandingRuns = false;
                                    for (Map.Entry entries : runConfigToLatestUpdatedRunMap.entrySet()) {
                                        KillableAlgorithmRun run = (KillableAlgorithmRun)entries.getValue();
                                        if (run.getRunResult().equals((Object)RunResult.RUNNING)) {
                                            outstandingRuns = true;
                                        }
                                        runs[((Integer)runConfigToPositionInListMap.get(entries.getKey())).intValue()] = run;
                                    }
                                    try {
                                        List<KillableAlgorithmRun> runList = Arrays.asList(runs);
                                        if (obs != null) {
                                            obs.currentStatus(runList);
                                        }
                                    }
                                    catch (RuntimeException e) {
                                        log.error("Error occured while notifying observer ", (Throwable)e);
                                        throw e;
                                    }
                                    if (outstandingRuns) continue;
                                    break block13;
                                } while (!AbstractAlgorithmRunner.this.execService.isShutdown());
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        AbstractAlgorithmRunner.this.shutdownRunnerCompleted.release();
                    }
                }
            }
        };
        this.execService.submit(runStatusWatchingThread);
    }

    @Override
    public abstract List<AlgorithmRun> run();

    @Override
    public void shutdownThreadPool() {
        this.execService.shutdown();
        try {
            this.shutdownRunnerRequested.set(true);
            this.updatedRunMapSemaphore.release();
            this.shutdownRunnerCompleted.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

