/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.eventsystem;

import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.basic.EventHandlerRuntimeExceptionEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.basic.EventManagerShutdownEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.internal.FlushEvent;
import ca.ubc.cs.beta.aclib.eventsystem.exceptions.EventFlushDeadLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private final ConcurrentHashMap<Class<? extends AutomaticConfiguratorEvent>, List<EventHandler<?>>> handlerMap = new ConcurrentHashMap();
    private transient Logger log = LoggerFactory.getLogger(EventManager.class);
    private LinkedBlockingQueue<Runnable> asyncRuns = new LinkedBlockingQueue();
    private final EventManagementThread eventDispatchThread;
    private final boolean shutdown = false;
    private final ConcurrentHashMap<String, AtomicInteger> eventNames = new ConcurrentHashMap();
    private AtomicReference<EventFlushDeadLockException> deadLockException = new AtomicReference();

    public EventManager() {
        EventManagementThread t;
        this.registerHandler(FlushEvent.class, new EventHandler<FlushEvent>(){

            @Override
            public void handleEvent(FlushEvent event) {
                event.releaseSemaphore();
            }
        });
        this.eventDispatchThread = t = new EventManagementThread(this.asyncRuns);
        t.start();
    }

    public synchronized void registerHandler(Class<? extends AutomaticConfiguratorEvent> eventClass, EventHandler<?> handler) {
        this.checkForShutdown();
        this.handlerMap.putIfAbsent(eventClass, new ArrayList());
        List<EventHandler<?>> handlers = this.handlerMap.get(eventClass);
        handlers.add(handler);
    }

    public synchronized void fireEvent(AutomaticConfiguratorEvent event) {
        this.checkForShutdown();
        EventFlushDeadLockException exp = this.deadLockException.get();
        if (exp != null) {
            throw new IllegalStateException("Deadlock has previously occurred, event manager is unavailable", this.deadLockException.get());
        }
        this.log.trace("Event requested for dispatch {}", (Object)event.getClass().getSimpleName());
        this.handlerMap.putIfAbsent(event.getClass(), new ArrayList());
        List<EventHandler<?>> handlers = this.handlerMap.get(event.getClass());
        this.eventNames.putIfAbsent(event.getClass().getSimpleName(), new AtomicInteger(0));
        this.eventNames.get(event.getClass().getSimpleName()).incrementAndGet();
        for (EventHandler<?> handler : handlers) {
            final AutomaticConfiguratorEvent event2 = event;
            final EventHandler<?> handler2 = handler;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventManager.this.log.trace("Dispatching event {} to handler: {}", (Object)(event2.getClass().getSimpleName() + " (0x" + Integer.toHexString(System.identityHashCode(event2)) + ")"), (Object)handler2.getClass().getSimpleName());
                        handler2.handleEvent(event2);
                    }
                    catch (RuntimeException t) {
                        Object[] args = new Object[]{handler2, event2, t};
                        EventManager.this.log.error("Error occured during dispatching of event", (Throwable)t);
                        EventManager.this.log.error("Event Handler {} while processing event: {}, threw Exception {}", args);
                        if (!(event2 instanceof EventHandlerRuntimeExceptionEvent)) {
                            EventManager.this.fireEvent(new EventHandlerRuntimeExceptionEvent(t, event2));
                            return;
                        }
                        EventManager.this.log.error("Event Handler threw exception while we were processing the {} event, not notifying anything else", event2.getClass());
                    }
                }
            };
            try {
                this.asyncRuns.put(run);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void flush() {
        this.checkForDeadLock();
        Semaphore wait = new Semaphore(0);
        this.fireEvent(new FlushEvent(wait));
        try {
            wait.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean isShutdown() {
        return false;
    }

    private void checkForDeadLock() {
        if (Thread.currentThread().equals(this.eventDispatchThread)) {
            EventFlushDeadLockException e = new EventFlushDeadLockException();
            this.deadLockException.set(e);
            this.log.error("Deadlock detected ", (Throwable)e);
            System.out.flush();
            System.err.flush();
            e.printStackTrace();
            System.out.flush();
            System.err.flush();
            throw e;
        }
    }

    private synchronized void checkForShutdown() {
    }

    public synchronized void shutdown() {
        this.fireEvent(new EventManagerShutdownEvent());
        this.flush();
        this.eventDispatchThread.interrupt();
        this.eventDispatchThread.waitForCompletion();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AtomicInteger> ent : this.eventNames.entrySet()) {
            sb.append(ent.getKey()).append("=>(").append(ent.getValue().get()).append("), ");
        }
        sb.setCharAt(sb.length() - 2, ' ');
        this.log.debug("Event Dispatch Name / Counts: {}", (Object)sb);
    }

    static class EventManagementThread
    extends Thread {
        private transient Logger log = LoggerFactory.getLogger(EventManager.class);
        private BlockingQueue<Runnable> asyncRuns;
        private Semaphore threadDone = new Semaphore(0);
        private int highLoadQueueWarningDisplay = 128;

        public EventManagementThread(BlockingQueue<Runnable> asyncRuns) {
            this.asyncRuns = asyncRuns;
            this.setName("Event Manager Dispatch Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                block7: {
                    if (!Thread.interrupted()) break block7;
                    Thread.currentThread().interrupt();
                    this.threadDone.release();
                    return;
                }
                try {
                    try {
                        this.asyncRuns.take().run();
                        if (this.asyncRuns.size() <= this.highLoadQueueWarningDisplay) continue;
                        this.highLoadQueueWarningDisplay *= 2;
                        this.log.warn("Processing Events has {} elements currently waiting, next warning at {} ", (Object)this.asyncRuns.size(), (Object)this.highLoadQueueWarningDisplay);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.log.error("Unexpected Exception occured", (Throwable)e);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.threadDone.release();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.threadDone.release();
                    throw throwable;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            try {
                try {
                    this.threadDone.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.threadDone.release();
                    return;
                }
            }
            finally {
                this.threadDone.release();
            }
        }
    }
}

