/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.eventsystem.handlers;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.state.StateRestoredEvent;
import ca.ubc.cs.beta.aclib.logging.CommonMarkers;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRuntimeStatistics
implements EventHandler<AutomaticConfiguratorEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ThreadSafeRunHistory runHistory;
    private final TerminationCondition termCond;
    private final AtomicReference<String> lastString = new AtomicReference();
    private final AtomicReference<IncumbentPerformanceChangeEvent> lastICE = new AtomicReference();
    private final double cutoffTime;
    private final AtomicInteger logCount = new AtomicInteger(1);
    private final long msToWait;
    private long lastMessage = Long.MIN_VALUE;
    private double sumOfRuntime = 0.0;
    private double sumOfWallclockTime = 0.0;
    private final AtomicBoolean noIceMessage = new AtomicBoolean(false);
    private final TargetAlgorithmEvaluator tae;
    private final AtomicInteger challengesStarted = new AtomicInteger(0);
    private final AtomicInteger challengesEnded = new AtomicInteger(0);
    private final boolean showChallenges;
    private final CPUTime cpuTime;
    private final Set<Class> logOnEvents;
    private static final DecimalFormat df0 = new DecimalFormat("0");
    private static final DecimalFormat df = new DecimalFormat("0.000");

    public LogRuntimeStatistics(ThreadSafeRunHistory rh, TerminationCondition termCond, double cutoffTime, TargetAlgorithmEvaluator tae, boolean showChallenges, CPUTime cpuTime, Collection<?> logOnEvents) {
        this.runHistory = rh;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.msToWait = 0L;
        this.lastString.set("No Runtime Statistics Logged");
        this.tae = tae;
        this.showChallenges = showChallenges;
        this.cpuTime = cpuTime;
        this.logOnEvents = new HashSet(logOnEvents);
    }

    public LogRuntimeStatistics(ThreadSafeRunHistory rh, TerminationCondition termCond, double cutoffTime, long msToWait, TargetAlgorithmEvaluator tae, boolean showChallenges, CPUTime cpuTime, Collection<?> logOnEvents) {
        this.runHistory = rh;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.msToWait = msToWait;
        this.lastString.set("No Runtime Statistics Logged");
        this.tae = tae;
        this.showChallenges = showChallenges;
        this.cpuTime = cpuTime;
        this.logOnEvents = new HashSet(logOnEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleEvent(AutomaticConfiguratorEvent event) {
        if (event instanceof IncumbentPerformanceChangeEvent) {
            IncumbentPerformanceChangeEvent ice = (IncumbentPerformanceChangeEvent)event;
            if (this.lastICE.get() == null || this.lastICE.get().getTunerTime() < ice.getTunerTime()) {
                this.lastICE.set(ice);
            }
        } else if (event instanceof AlgorithmRunCompletedEvent) {
            this.sumOfWallclockTime += ((AlgorithmRunCompletedEvent)event).getRun().getWallclockExecutionTime();
            this.sumOfRuntime += ((AlgorithmRunCompletedEvent)event).getRun().getRuntime();
        } else if (event instanceof StateRestoredEvent) {
            this.logCount.set(((StateRestoredEvent)event).getModelsBuilt());
            for (AlgorithmRun run : ((StateRestoredEvent)event).getRunHistory().getAlgorithmRunsIncludingRedundant()) {
                this.sumOfWallclockTime += run.getWallclockExecutionTime();
                this.sumOfRuntime += run.getRuntime();
            }
        } else if (event instanceof ChallengeStartEvent) {
            this.challengesStarted.incrementAndGet();
        } else if (event instanceof ChallengeEndEvent) {
            this.challengesEnded.incrementAndGet();
        }
        if (this.logOnEvents.contains(event.getClass())) {
            try {
                this.runHistory.readLock();
                if (this.lastICE.get() == null) {
                    if (!this.noIceMessage.get()) {
                        this.log.debug("Runtime Statistics are Not Available because we haven't seen an Incumbent Performance Changed Event yet");
                    }
                    return;
                }
                ParamConfiguration incumbent = this.lastICE.get().getIncumbent();
                Object[] arr = new Object[]{this.logCount.get(), this.runHistory.getThetaIdx(incumbent) + " (internal ID:" + incumbent + ")", this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(incumbent), this.runHistory.getProblemInstancesRan(incumbent).size(), this.runHistory.getUniqueParamConfigurations().size(), LogRuntimeStatistics.format(this.runHistory.getEmpiricalCost(incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime)), "N/A", "N/A", "N/A", "N/A", LogRuntimeStatistics.format(this.termCond.getTunerTime()), "N/A", LogRuntimeStatistics.format(this.runHistory.getTotalRunCost()), LogRuntimeStatistics.format(this.cpuTime.getCPUTime()), LogRuntimeStatistics.format(this.cpuTime.getUserTime()), LogRuntimeStatistics.format(this.sumOfRuntime), LogRuntimeStatistics.format(this.sumOfWallclockTime), LogRuntimeStatistics.format0((double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0), LogRuntimeStatistics.format0((double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0), LogRuntimeStatistics.format0((double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0)};
                StringBuilder sb = new StringBuilder(" ");
                for (ValueMaxStatus vms : this.termCond.currentStatus()) {
                    sb.append(vms.getStatus());
                }
                int challengersStarted = this.challengesStarted.get();
                int challengersEnded = Math.min(this.challengesEnded.get(), challengersStarted);
                String challenges = "";
                if (this.showChallenges) {
                    challenges = "\n Number of Challenges Started: " + this.challengesStarted + "\n Number of Challenges Oustanding:" + (challengersStarted - challengersEnded);
                }
                String myLastLogMessage = "*****Developer Statistics*****\n Count: " + arr[0] + "\n Incumbent ID: " + arr[1] + "\n Number of PISPs for Incumbent: " + arr[2] + "\n Number of Instances for Incumbent: " + arr[3] + "\n Number of Configurations Run: " + arr[4] + "\n Performance of the Incumbent: " + arr[5] + challenges + "\n" + sb.toString().replaceAll("\n", "\n ") + "Sum of Target Algorithm Execution Times (treating minimum value as 0.1): " + arr[12] + " s" + "\n CPU time of Configurator: " + arr[13] + " s" + "\n User time of Configurator: " + arr[14] + " s" + "\n Outstanding Runs on Target Algorithm Evaluator: " + this.tae.getNumberOfOutstandingRuns() + "\n Outstanding Requests on Target Algorithm Evaluator: " + this.tae.getNumberOfOutstandingBatches() + "\n Total Reported Algorithm Runtime: " + arr[15] + " s" + "\n Sum of Measured Wallclock Runtime: " + arr[16] + " s" + "\n Max Memory: " + arr[17] + " MB" + "\n Total Java Memory: " + arr[18] + " MB" + "\n Free Java Memory: " + arr[19] + " MB" + "\n * PISP count is roughly the number of runs, but doesn't included redundant runs on the same problem instance & seed";
                this.lastString.set(myLastLogMessage);
            }
            finally {
                this.runHistory.releaseReadLock();
            }
            if (this.msToWait + this.lastMessage > System.currentTimeMillis()) {
                return;
            }
            this.logCount.incrementAndGet();
            this.lastMessage = System.currentTimeMillis();
            this.log.debug(this.lastString.get());
        }
    }

    public void logLastRuntimeStatistics() {
        this.log.info(CommonMarkers.SKIP_CONSOLE_PRINTING, this.lastString.get());
    }

    private static synchronized String format0(double d) {
        return df0.format(d);
    }

    private static synchronized String format(double d) {
        return df.format(d);
    }
}

