/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.example.satisfiabilitychecker;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.example.satisfiabilitychecker.SatisfiabilityCheckerOptions;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.WaitableTAECallback;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatisfiabilityChecker {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        final SatisfiabilityCheckerOptions mainOptions = new SatisfiabilityCheckerOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.scenOptions.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        try {
            JCommander jcom;
            try {
                jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(SatisfiabilityChecker.class);
            }
            VersionTracker.logVersions();
            for (String name : jcom.getParameterFilesToRead()) {
                log.debug("Parsing (default) options from file: {} ", (Object)name);
            }
            AlgorithmExecutionConfig execConfig = mainOptions.getAlgorithmExecutionConfig();
            log.debug("==== Configuration====\n {} ", (Object)mainOptions);
            TargetAlgorithmEvaluator tae = null;
            File f = new File(mainOptions.outputFile);
            if (f.exists() && !mainOptions.overwriteOutputFile) {
                throw new ParameterException("Output file already exists. Use --overwrite-output-file to overwrite already existing files");
            }
            try {
                tae = mainOptions.scenOptions.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(execConfig, taeOptions);
                final List<ProblemInstance> instances = mainOptions.useTestSetInstances ? mainOptions.getTrainingAndTestProblemInstances().getTestInstances().getInstances() : mainOptions.getTrainingAndTestProblemInstances().getTrainingInstances().getInstances();
                if (execConfig.isDeterministicAlgorithm()) {
                    if (mainOptions.seed != -1L) {
                        log.warn("It is convention to use -1 as the seed for deterministic algorithms");
                    }
                } else if (mainOptions.seed == -1L) {
                    log.warn("It is convention that -1 be used as seed only for deterministic algorithms");
                }
                ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>();
                for (ProblemInstance pi : instances) {
                    pisps.add(new ProblemInstanceSeedPair(pi, mainOptions.seed));
                }
                ParamConfigurationSpace configSpace = execConfig.getParamFile();
                MersenneTwister configSpacePRNG = new MersenneTwister(mainOptions.configSeed);
                ParamConfiguration config = configSpace.getConfigurationFromString(mainOptions.config, ParamConfiguration.StringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG);
                for (Map.Entry<String, String> entry : mainOptions.configSettingsToOverride.entrySet()) {
                    config.put(entry.getKey(), entry.getValue());
                }
                ArrayList<RunConfig> rc = new ArrayList<RunConfig>(instances.size());
                for (ProblemInstanceSeedPair pisp : pisps) {
                    rc.add(new RunConfig(pisp, execConfig.getAlgorithmCutoffTime(), config));
                }
                TargetAlgorithmEvaluatorRunObserver obs = new TargetAlgorithmEvaluatorRunObserver(){
                    private long lastUpdate = 0L;

                    @Override
                    public synchronized void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                        if (System.currentTimeMillis() - this.lastUpdate < 5000L) {
                            return;
                        }
                        this.lastUpdate = System.currentTimeMillis();
                        NumberFormat nf = NumberFormat.getPercentInstance();
                        double currentTime = 0.0;
                        double maxTime = 0.0;
                        int completed = 0;
                        for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                            if (killableAlgorithmRun.isRunCompleted()) {
                                maxTime += killableAlgorithmRun.getRuntime();
                                ++completed;
                            } else {
                                maxTime += killableAlgorithmRun.getRunConfig().getCutoffTime();
                            }
                            currentTime += killableAlgorithmRun.getRuntime();
                        }
                        log.info("Current Run Information: Completion by CPU Time: {}, Completed Instances: {}/{}", new Object[]{nf.format(currentTime / maxTime), completed, runs.size()});
                    }
                };
                final AtomicReference exception = new AtomicReference();
                TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(List<AlgorithmRun> runs) {
                        File f = new File(mainOptions.outputFile);
                        if (f.exists() && !mainOptions.overwriteOutputFile) {
                            throw new ParameterException("Output file already exists. Use --overwrite-output-file to overwrite already existing files");
                        }
                        HashMap<ProblemInstance, AlgorithmRun> instanceToRunMap = new HashMap<ProblemInstance, AlgorithmRun>();
                        for (AlgorithmRun run : runs) {
                            instanceToRunMap.put(run.getRunConfig().getProblemInstanceSeedPair().getInstance(), run);
                        }
                        log.info("Writing output to {}", (Object)f.getAbsoluteFile());
                        try {
                            FileWriter fwrite = new FileWriter(f);
                            try {
                                for (ProblemInstance pi : instances) {
                                    AlgorithmRun run = (AlgorithmRun)instanceToRunMap.get(pi);
                                    fwrite.append(pi.getInstanceName() + " " + (run.getRunResult().isDecided() ? run.getRunResult() : "UNKNOWN") + "\n");
                                }
                            }
                            finally {
                                fwrite.close();
                            }
                        }
                        catch (IOException e) {
                            exception.set(e);
                        }
                    }

                    @Override
                    public void onFailure(RuntimeException e) {
                        exception.set(e);
                    }
                };
                WaitableTAECallback wTAE = new WaitableTAECallback(taeCallback);
                tae.evaluateRunsAsync(rc, wTAE, obs);
                if (!tae.areRunsPersisted()) {
                    wTAE.waitForCompletion();
                }
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
            }
            finally {
                if (tae != null) {
                    tae.notifyShutdown();
                }
            }
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

