/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.example.satisfiabilitychecker;

import ca.ubc.cs.beta.aclib.example.satisfiabilitychecker.SatisfiabilityCheckerNoArgumentHandler;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.help.HelpOptions;
import ca.ubc.cs.beta.aclib.logging.ConsoleOnlyLoggingOptions;
import ca.ubc.cs.beta.aclib.logging.LoggingOptions;
import ca.ubc.cs.beta.aclib.misc.file.HomeFileUtils;
import ca.ubc.cs.beta.aclib.misc.jcommander.validator.LongGreaterThanNegativeTwoValidator;
import ca.ubc.cs.beta.aclib.misc.options.UsageTextField;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceOptions;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterFile;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@UsageTextField(title="Target Algorithm Evaluator Running Options", description=" Utility that allows for making a single run against a target algorithm evaluator ", noarg=SatisfiabilityCheckerNoArgumentHandler.class)
public class SatisfiabilityCheckerOptions
extends AbstractOptions {
    @UsageTextField(defaultValues="~/.aeatk/satcheck.opt")
    @Parameter(names={"--taeRunnerDefaultsFile"}, description="file that contains default settings for Satisfiability Checker")
    @ParameterFile(ignoreFileNotExists=true)
    public File defaultsFile = HomeFileUtils.getHomeFile(".aeatk" + File.separator + "satcheck.opt");
    @ParametersDelegate
    public ScenarioOptions scenOptions = new ScenarioOptions();
    @ParametersDelegate
    public LoggingOptions logOpts = new ConsoleOnlyLoggingOptions();
    @Parameter(names={"--seed"}, description="Seed to run instance with", validateWith=LongGreaterThanNegativeTwoValidator.class)
    public long seed = 1L;
    @Parameter(names={"--config"}, description="Configuration to run (Use DEFAULT for the default, RANDOM for a random, or otherwise -name 'value' syntax)")
    public String config = "DEFAULT";
    @Parameter(names={"--config-seed"}, description="Seed to use if we generate a RANDOM configuration")
    public int configSeed = 0;
    @Parameter(names={"--output-file"}, description="Output file to write results to", required=true)
    public String outputFile;
    @Parameter(names={"--overwrite-output-file"}, description="Allow overwriting of the output file")
    public boolean overwriteOutputFile = false;
    @Parameter(names={"--use-test-set-instances"}, description="Uses test set instances instead of training set")
    public boolean useTestSetInstances = false;
    @DynamicParameter(names={"-P"}, description="Name value pairs in the form: (-Pname=value) of the specific configuration to override. This is useful if you'd like to change a setting of the default , or try a random with a set value)")
    public Map<String, String> configSettingsToOverride = new HashMap<String, String>();
    @ParametersDelegate
    HelpOptions help = new HelpOptions();

    public AlgorithmExecutionConfig getAlgorithmExecutionConfig() {
        return this.scenOptions.algoExecOptions.getAlgorithmExecutionConfig(null);
    }

    public ProblemInstanceOptions.TrainTestInstances getTrainingAndTestProblemInstances() throws IOException {
        return this.scenOptions.getTrainingAndTestProblemInstances("./", 0L, 0L, true, false, false, false);
    }
}

