/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.jcommander;

import ca.ubc.cs.beta.aclib.misc.options.OptionLevel;
import ca.ubc.cs.beta.aclib.misc.options.UsageSection;
import ca.ubc.cs.beta.aclib.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.options.docgen.OptionsToUsage;
import ca.ubc.cs.beta.aclib.options.docgen.UsageSectionGenerator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCommanderHelper {
    public static JCommander getJCommander(AbstractOptions opts, Map<String, AbstractOptions> taeOpts) {
        ArrayList<AbstractOptions> allOptions = new ArrayList<AbstractOptions>();
        allOptions.add(opts);
        for (Map.Entry<String, AbstractOptions> ent : taeOpts.entrySet()) {
            if (ent.getValue() == null) continue;
            allOptions.add(ent.getValue());
        }
        JCommander com = new JCommander((Object)allOptions.toArray(), true, true);
        return com;
    }

    public static JCommander parseCheckingForHelpAndVersion(String[] args, AbstractOptions options) {
        return JCommanderHelper.parseCheckingForHelpAndVersion(args, options, Collections.<String, AbstractOptions>emptyMap());
    }

    public static JCommander parseCheckingForHelpAndVersion(String[] args, AbstractOptions options, Map<String, AbstractOptions> emptyMap) {
        JCommander jcom = JCommanderHelper.getJCommanderAndCheckForHelp(args, options, emptyMap);
        jcom.parse(args);
        return jcom;
    }

    public static void checkForHelpAndVersion(String[] args, AbstractOptions options, Map<String, AbstractOptions> taeOpts) {
        Object helpOption = null;
        OptionLevel levelToDisplay = OptionLevel.BASIC;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].trim().equals("--help-level")) continue;
            if (i == args.length - 1) {
                throw new ParameterException("--help-level argument requires an argument");
            }
            try {
                levelToDisplay = OptionLevel.valueOf(args[i + 1].toUpperCase().trim());
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("--help-level has illegal value, must be one of: " + Arrays.toString((Object[])OptionLevel.values()));
            }
        }
        try {
            String[] versionNames;
            String[] helpNames;
            String[] hiddenNames;
            HashSet<String> possibleValues = new HashSet<String>(Arrays.asList(args));
            for (String helpName : hiddenNames = new String[]{"--show-hidden", "--showHiddenParameters"}) {
                if (!possibleValues.contains(helpName)) continue;
                OptionsToUsage.usage(UsageSectionGenerator.getUsageSections(options, taeOpts), true, levelToDisplay);
                System.exit(0);
            }
            for (String helpName : helpNames = new String[]{"--help", "-?", "/?", "-h", "--help-level"}) {
                if (!possibleValues.contains(helpName)) continue;
                List<UsageSection> secs = UsageSectionGenerator.getUsageSections(options, taeOpts);
                boolean quit = false;
                for (UsageSection sec : secs) {
                    quit |= sec.getHandler().handleNoArguments();
                }
                OptionsToUsage.usage(UsageSectionGenerator.getUsageSections(options, taeOpts), false, levelToDisplay);
                System.exit(0);
            }
            for (String helpName : versionNames = new String[]{"-v", "--version"}) {
                if (!possibleValues.contains(helpName)) continue;
                System.setProperty("logback.configurationFile", "logback-off.xml");
                VersionTracker.setClassLoader(SPIClassLoaderHelper.getClassLoader());
                System.out.println("**** Version Information ****");
                System.out.println(VersionTracker.getVersionInformation());
                System.exit(0);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JCommander getJCommanderAndCheckForHelp(String[] args, AbstractOptions mainOptions) {
        return JCommanderHelper.getJCommanderAndCheckForHelp(args, mainOptions, Collections.<String, AbstractOptions>emptyMap());
    }

    public static JCommander getJCommanderAndCheckForHelp(String[] args, AbstractOptions mainOptions, Map<String, AbstractOptions> taeOptions) {
        JCommander jcom = JCommanderHelper.getJCommander(mainOptions, taeOptions);
        if (args.length == 0) {
            List<UsageSection> secs = UsageSectionGenerator.getUsageSections(mainOptions, taeOptions);
            boolean quit = false;
            for (UsageSection sec : secs) {
                quit |= sec.getHandler().handleNoArguments();
            }
            if (quit) {
                System.exit(1);
            }
        }
        JCommanderHelper.checkForHelpAndVersion(args, mainOptions, taeOptions);
        return jcom;
    }

    public static void logCallString(String[] args, Class<?> c) {
        Logger log = LoggerFactory.getLogger(JCommanderHelper.class);
        StringBuilder sb = new StringBuilder("java -cp ");
        sb.append(System.getProperty("java.class.path")).append(" ");
        sb.append(c.getCanonicalName()).append(" ");
        for (String arg : args) {
            boolean escape = false;
            if (arg.contains(" ")) {
                escape = true;
                arg = arg.replaceAll(" ", "\\ ");
            }
            if (escape) {
                sb.append("\"");
            }
            sb.append(arg);
            if (escape) {
                sb.append("\"");
            }
            sb.append(" ");
        }
        log.info("Call String:");
        log.info("{}", (Object)sb.toString());
    }

    public static void logCallString(String[] args, String name) {
        Logger log = LoggerFactory.getLogger(JCommanderHelper.class);
        StringBuilder sb = new StringBuilder(name);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            sb.append(".bat");
        }
        sb.append(" ");
        for (String arg : args) {
            boolean escape = false;
            if (arg.contains(" ")) {
                escape = true;
                arg = arg.replaceAll(" ", "\\ ");
            }
            if (escape) {
                sb.append("\"");
            }
            sb.append(arg);
            if (escape) {
                sb.append("\"");
            }
            sb.append(" ");
        }
        log.info("Call String: {}", (Object)sb.toString());
    }

    public static JCommander getJCommander(AbstractOptions t) {
        return JCommanderHelper.getJCommander(t, Collections.<String, AbstractOptions>emptyMap());
    }

    public static void logConfiguration(JCommander jcom) {
        Logger log = LoggerFactory.getLogger(JCommanderHelper.class);
        StringBuilder sb = new StringBuilder();
        for (Object o : jcom.getObjects()) {
            sb.append(o.toString()).append("\n");
        }
        log.debug("==========Configuration Options==========\n{}", (Object)sb.toString());
    }
}

