/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.probleminstance;

import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import java.io.Serializable;

public class ProblemInstanceSeedPair
implements Comparable<ProblemInstanceSeedPair>,
Serializable {
    private static final long serialVersionUID = 7686639875384341346L;
    private final ProblemInstance ai;
    private final long seed;

    public ProblemInstanceSeedPair(ProblemInstance ai, long seed) {
        if (ai == null) {
            throw new IllegalArgumentException("Algorithm Instance cannot be null");
        }
        this.ai = ai;
        this.seed = seed;
    }

    public ProblemInstance getInstance() {
        return this.ai;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemInstanceSeedPair) {
            ProblemInstanceSeedPair aisp = (ProblemInstanceSeedPair)o;
            return aisp.seed == this.seed && this.ai.equals(aisp.ai);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seed >>> 32 ^ (long)((int)this.seed) ^ (long)this.ai.hashCode());
    }

    public String toString() {
        return "<Instance:" + this.ai.getInstanceID() + ", Seed:" + this.seed + ">";
    }

    @Override
    public int compareTo(ProblemInstanceSeedPair o) {
        int idDiff = this.ai.getInstanceID() - o.ai.getInstanceID();
        if (idDiff != 0) {
            return idDiff;
        }
        long seedDiff = this.seed - o.seed;
        if (seedDiff < 0L) {
            return -1;
        }
        if (seedDiff > 0L) {
            return 1;
        }
        return 0;
    }
}

