/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.exceptions.TrajectoryDivergenceException;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ThreadSafe
public class RunHashCodeVerifyingAlgorithmEvalutor
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private final Queue<Integer> runHashQueue;
    private int hashCodesOfRuns = 0;
    private int runNumber = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Marker runHash = MarkerFactory.getMarker((String)"RUN_HASH");
    boolean outOfHashCodesDisplayed = false;

    public RunHashCodeVerifyingAlgorithmEvalutor(TargetAlgorithmEvaluator tae) {
        this(tae, new LinkedList<Integer>());
    }

    public RunHashCodeVerifyingAlgorithmEvalutor(TargetAlgorithmEvaluator tae, Queue<Integer> runHashes) {
        super(tae);
        this.runHashQueue = runHashes;
        this.log.trace("Created with {} hash codes to verify", (Object)this.runHashQueue.size());
        if (this.runHashQueue.size() == 0) {
            this.outOfHashCodesDisplayed = true;
        }
    }

    @Override
    public synchronized void seek(List<AlgorithmRun> runs) {
        super.seek(runs);
        this.processRuns(runs);
    }

    @Override
    protected synchronized AlgorithmRun processRun(AlgorithmRun run) {
        ++this.runNumber;
        int hashCode = run.hashCode();
        hashCode = hashCode == Integer.MIN_VALUE ? 0 : hashCode;
        this.hashCodesOfRuns = (31 * this.hashCodesOfRuns + Math.abs(hashCode) % 32452867) % 32452867;
        this.log.trace(this.runHash, "Run Hash Codes:{} After {} runs", (Object)this.hashCodesOfRuns, (Object)this.runNumber);
        Integer expectedHashCode = this.runHashQueue.poll();
        if (expectedHashCode == null) {
            if (!this.outOfHashCodesDisplayed) {
                this.log.debug("No More Hash Codes To Verify");
                this.outOfHashCodesDisplayed = true;
            }
        } else {
            if (this.hashCodesOfRuns != expectedHashCode) {
                throw new TrajectoryDivergenceException(expectedHashCode, this.hashCodesOfRuns, this.runNumber);
            }
            this.log.trace("Hash Code {} matched {}", (Object)expectedHashCode, (Object)this.hashCodesOfRuns);
        }
        return run;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

