/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SATConsistencyTargetAlgorithmEvaluator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private final ConcurrentHashMap<ProblemInstance, RunResult> runResults = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(SATConsistencyTargetAlgorithmEvaluator.class);
    private final boolean throwException;

    public SATConsistencyTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae, boolean throwException) {
        super(tae);
        this.throwException = throwException;
    }

    @Override
    protected AlgorithmRun processRun(AlgorithmRun run) {
        RunResult result = run.getRunResult();
        switch (result) {
            case SAT: 
            case UNSAT: {
                RunResult previousResult = this.runResults.putIfAbsent(run.getRunConfig().getProblemInstanceSeedPair().getInstance(), result);
                if (previousResult != null && !previousResult.equals((Object)result)) {
                    Object[] args = new Object[]{run.getRunConfig().getProblemInstanceSeedPair().getInstance(), previousResult, result};
                    log.error("SAT/UNSAT discrepancy detected on problem instance: {}. Previous value: {}, currentValue: {}", args);
                    if (this.throwException) {
                        throw new TargetAlgorithmAbortException("RunResult dispatch detected inconsistence with previous result " + (Object)((Object)previousResult) + " currentResult: " + (Object)((Object)result) + " run" + run);
                    }
                }
            }
            case TIMEOUT: 
            case CRASHED: 
            case ABORT: 
            case KILLED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected run result on algorithm run: " + run);
            }
        }
        return run;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

