/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TimingCheckerTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private double totalWallClockOverhead = 0.0;
    private double totalRuntimeOverhead = 0.0;
    private double totalWallClockVersusRuntimeDifference = 0.0;
    private double totalWalltime;
    private double totalRuntime;
    private final AlgorithmExecutionConfig execConfig;
    private static final Logger log = LoggerFactory.getLogger(TimingCheckerTargetAlgorithmEvaluator.class);
    private double runtimeDeltaToRequireLogging = 1.0;
    private double wallClockDeltaToRequireLogging;

    public TimingCheckerTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, TargetAlgorithmEvaluator tae) {
        super(tae);
        this.execConfig = execConfig;
        this.wallClockDeltaToRequireLogging = Math.min(1.5 * execConfig.getAlgorithmCutoffTime(), 10.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDecorateeNotifyShutdown() {
        TimingCheckerTargetAlgorithmEvaluator timingCheckerTargetAlgorithmEvaluator = this;
        synchronized (timingCheckerTargetAlgorithmEvaluator) {
            double maxOverhead = 0.0;
            maxOverhead = Math.max(this.totalRuntimeOverhead / this.totalRuntime, maxOverhead);
            maxOverhead = Math.max(this.totalWallClockOverhead / this.totalWalltime, maxOverhead);
            maxOverhead = Math.max(this.totalWalltime / this.totalRuntime, maxOverhead);
            if (log.isDebugEnabled() || maxOverhead > 0.1) {
                log.debug("Total Reported Runtime: {} (s), Total of Sum Max(runtime-cutoff,0): {} (s)", (Object)this.totalRuntime, (Object)this.totalRuntimeOverhead);
                log.debug("Total Walltime: {} (s), Total of Sum Max(walltime - cutoff, 0): {} (s)", (Object)this.totalWalltime, (Object)this.totalWallClockOverhead);
                log.debug("Total Difference between Walltime and Runtime (Sum of the amount of wallclock time - sum of the amount of reported CPU time) : {} seconds", (Object)this.totalWallClockVersusRuntimeDifference);
            }
        }
    }

    protected synchronized AlgorithmRun processRun(AlgorithmRun run) {
        double runtimeOverhead = run.getRuntime() - run.getRunConfig().getCutoffTime();
        this.totalRuntime += Math.max(run.getRuntime(), 0.0);
        this.totalRuntimeOverhead += Math.max(runtimeOverhead, 0.0);
        if (runtimeOverhead > this.runtimeDeltaToRequireLogging) {
            this.runtimeDeltaToRequireLogging = runtimeOverhead + 1.0;
            Object[] args = new Object[]{run.getRuntime(), run.getRunConfig().getCutoffTime(), runtimeOverhead, this.runtimeDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported a runtime of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        double wallClockOverhead = run.getWallclockExecutionTime() - run.getRunConfig().getCutoffTime();
        this.totalWalltime += Math.max(run.getWallclockExecutionTime(), 0.0);
        this.totalWallClockOverhead += Math.max(wallClockOverhead, 0.0);
        if (wallClockOverhead > this.wallClockDeltaToRequireLogging) {
            this.wallClockDeltaToRequireLogging = wallClockOverhead + 1.0;
            Object[] args = new Object[]{run.getWallclockExecutionTime(), run.getRunConfig().getCutoffTime(), wallClockOverhead, this.wallClockDeltaToRequireLogging};
            log.warn("Algorithm Run Result reported wallclock time of {} (secs) that exceeded it's cutoff time of {} (secs) by {} (secs). Next warning at {} (secs)  ", args);
        }
        this.totalWallClockVersusRuntimeDifference += Math.max(run.getWallclockExecutionTime() - run.getRuntime(), 0.0);
        return run;
    }

    protected synchronized RunConfig processRun(RunConfig rc) {
        return rc;
    }

    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.processRuns(this.tae.evaluateRun(this.processRunConfigs(runConfigs), new WarnOnExceededCutoffRunObserver(obs)));
    }

    @Override
    public final void evaluateRunsAsync(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                runs = TimingCheckerTargetAlgorithmEvaluator.this.processRuns(runs);
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(this.processRunConfigs(runConfigs), myHandler, new WarnOnExceededCutoffRunObserver(obs));
    }

    protected final List<AlgorithmRun> processRuns(List<AlgorithmRun> runs) {
        for (int i = 0; i < runs.size(); ++i) {
            runs.set(i, this.processRun(runs.get(i)));
        }
        return runs;
    }

    protected final List<RunConfig> processRunConfigs(List<RunConfig> runConfigs) {
        runConfigs = new ArrayList<RunConfig>(runConfigs);
        for (int i = 0; i < runConfigs.size(); ++i) {
            runConfigs.set(i, this.processRun(runConfigs.get(i)));
        }
        return runConfigs;
    }

    private class WarnOnExceededCutoffRunObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private final TargetAlgorithmEvaluatorRunObserver obs;
        private ConcurrentHashMap<RunConfig, Boolean> warnCreated = new ConcurrentHashMap();

        public WarnOnExceededCutoffRunObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
            try {
                this.obs.currentStatus(runs);
            }
            catch (Throwable throwable) {
                for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                    if (killableAlgorithmRun.isRunCompleted() || !(killableAlgorithmRun.getWallclockExecutionTime() > 3.0 * killableAlgorithmRun.getRunConfig().getCutoffTime()) || !(killableAlgorithmRun.getWallclockExecutionTime() > 180.0) || this.warnCreated.putIfAbsent(killableAlgorithmRun.getRunConfig(), Boolean.TRUE) != null) continue;
                    log.warn("We have been waiting for {} seconds for a run that should have taken at most {} seconds.\n The sample call for the run that is delayed is: cd \"{}\" " + CommandLineAlgorithmRun.COMMAND_SEPERATOR + "  {} ", new Object[]{killableAlgorithmRun.getWallclockExecutionTime(), killableAlgorithmRun.getRunConfig().getCutoffTime(), new File(TimingCheckerTargetAlgorithmEvaluator.this.execConfig.getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(TimingCheckerTargetAlgorithmEvaluator.this.execConfig, killableAlgorithmRun.getRunConfig())});
                }
                throw throwable;
            }
            for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                if (killableAlgorithmRun.isRunCompleted() || !(killableAlgorithmRun.getWallclockExecutionTime() > 3.0 * killableAlgorithmRun.getRunConfig().getCutoffTime()) || !(killableAlgorithmRun.getWallclockExecutionTime() > 180.0) || this.warnCreated.putIfAbsent(killableAlgorithmRun.getRunConfig(), Boolean.TRUE) != null) continue;
                log.warn("We have been waiting for {} seconds for a run that should have taken at most {} seconds.\n The sample call for the run that is delayed is: cd \"{}\" " + CommandLineAlgorithmRun.COMMAND_SEPERATOR + "  {} ", new Object[]{killableAlgorithmRun.getWallclockExecutionTime(), killableAlgorithmRun.getRunConfig().getCutoffTime(), new File(TimingCheckerTargetAlgorithmEvaluator.this.execConfig.getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(TimingCheckerTargetAlgorithmEvaluator.this.execConfig, killableAlgorithmRun.getRunConfig())});
            }
        }
    }
}

