/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init;

import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug.CheckForDuplicateRunConfigDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug.LeakingMemoryTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug.LogEveryTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug.RunHashCodeVerifyingAlgorithmEvalutor;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug.UncleanShutdownDetectingTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.transform.TransformTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers.KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers.OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers.RetryCrashedRunsTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers.WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.prepostcommand.PrePostCommandTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.resource.BoundedTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.AbortOnCrashTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.AbortOnFirstRunCrashTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.ResultOrderCorrectCheckerTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.SATConsistencyTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.SynchronousObserverTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.TimingCheckerTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.VerifySATTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety.WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAlgorithmEvaluatorBuilder {
    private static Logger log = LoggerFactory.getLogger(TargetAlgorithmEvaluatorBuilder.class);
    private static Pattern RUN_HASH_CODE_PATTERN = Pattern.compile("^Run Hash Codes:\\d+( After \\d+ runs)?\\z");

    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(TargetAlgorithmEvaluatorOptions options, AlgorithmExecutionConfig execConfig, boolean hashVerifiersAllowed, Map<String, AbstractOptions> taeOptionsMap) {
        return TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator(options, execConfig, hashVerifiersAllowed, taeOptionsMap, null);
    }

    @Deprecated
    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(TargetAlgorithmEvaluatorOptions options, AlgorithmExecutionConfig execConfig, boolean hashVerifiersAllowed, Map<String, AbstractOptions> taeOptionsMap, TargetAlgorithmEvaluator tae) {
        return TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator(options, execConfig, hashVerifiersAllowed, false, taeOptionsMap, tae);
    }

    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(TargetAlgorithmEvaluatorOptions options, AlgorithmExecutionConfig execConfig, boolean hashVerifiersAllowed, boolean ignoreBound, Map<String, AbstractOptions> taeOptionsMap, TargetAlgorithmEvaluator tae) {
        return TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator(options, execConfig, hashVerifiersAllowed, ignoreBound, taeOptionsMap, tae, new File("."), 0);
    }

    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(TargetAlgorithmEvaluatorOptions options, AlgorithmExecutionConfig execConfig, boolean hashVerifiersAllowed, boolean ignoreBound, Map<String, AbstractOptions> taeOptionsMap, TargetAlgorithmEvaluator tae, File outputDir, int numRun) {
        String resultFile;
        if (taeOptionsMap == null) {
            throw new IllegalArgumentException("taeOptionsMap must be non-null and contain the option objects for all target algorithm evaluators");
        }
        if (tae == null) {
            String taeKey = options.targetAlgorithmEvaluator;
            tae = TargetAlgorithmEvaluatorLoader.getTargetAlgorithmEvaluator(execConfig, taeKey, taeOptionsMap);
        }
        if (tae == null) {
            throw new IllegalStateException("TAE should have been non-null");
        }
        if (options.uncleanShutdownCheck) {
            log.trace("[TAE] Checking for unclean shutdown");
            tae = new UncleanShutdownDetectingTargetAlgorithmEvaluator(tae);
        } else {
            log.debug("[TAE] Not Checking for unclean shutdown");
        }
        if (options.retryCount > 0) {
            log.debug("[TAE] Automatically retrying CRASHED runs {} times ", (Object)options.retryCount);
            tae = new RetryCrashedRunsTargetAlgorithmEvaluator(options.retryCount, tae);
        }
        if (options.abortOnCrash) {
            log.trace("[TAE] Treating all crashes as aborts");
            tae = new AbortOnCrashTargetAlgorithmEvaluator(tae);
        }
        if (options.abortOnFirstRunCrash) {
            tae = new AbortOnFirstRunCrashTargetAlgorithmEvaluator(tae);
            if (options.abortOnCrash) {
                log.warn("[TAE] Configured to treat all crashes as aborts, it is redundant to also treat the first as an abort");
            }
        }
        if (options.ttaedo.transform) {
            log.debug("[TAE] Using Transforming Target Algorithm Evaluator");
            tae = new TransformTargetAlgorithmEvaluatorDecorator(tae, options.ttaedo);
        }
        if (options.verifySAT != null && options.verifySAT.booleanValue()) {
            log.trace("[TAE] Verifying SAT Responses");
            tae = new VerifySATTargetAlgorithmEvaluator(tae);
        }
        if (options.checkSATConsistency) {
            log.trace("[TAE] Ensuring SAT Response consistency");
            tae = new SATConsistencyTargetAlgorithmEvaluator(tae, options.checkSATConsistencyException);
        }
        if (options.trackRunsScheduled) {
            resultFile = outputDir.getAbsolutePath() + File.separator + "dispatched-runs-over-time-" + numRun + ".csv";
            log.debug("[TAE] Tracking all outstanding runs to file {} ", (Object)resultFile);
            tae = new OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator(tae, resultFile, options.trackRunsScheduledResolution, "Dispatched");
        }
        if (!ignoreBound && options.boundRuns) {
            log.trace("[TAE] Bounding the number of concurrent target algorithm evaluations to {} ", (Object)options.maxConcurrentAlgoExecs);
            tae = new BoundedTargetAlgorithmEvaluator(tae, options.maxConcurrentAlgoExecs, execConfig);
            if (options.trackRunsScheduled) {
                resultFile = outputDir.getAbsolutePath() + File.separator + "queued-runs-over-time-" + numRun + ".csv";
                log.debug("[TAE] Tracking all queued runs to file {} ", (Object)resultFile);
                tae = new OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator(tae, resultFile, options.trackRunsScheduledResolution, "Queued");
            }
        } else if (ignoreBound) {
            log.trace("[TAE] Ignoring Bound");
        }
        if (options.checkResultOrderConsistent) {
            log.trace("[TAE] Checking that TAE honours the ordering requirement of runs");
            tae = new ResultOrderCorrectCheckerTargetAlgorithmEvaluatorDecorator(tae);
        }
        if (options.observeWalltimeIfNoRuntime) {
            log.debug("[TAE] Using walltime as observer runtime if no runtime is reported, scale {} , delay {} (secs)", (Object)options.observeWalltimeScale, (Object)options.observeWalltimeDelay);
            tae = new WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator(tae, options.observeWalltimeScale, options.observeWalltimeDelay);
        }
        if (hashVerifiersAllowed) {
            if (options.leakMemory) {
                LeakingMemoryTargetAlgorithmEvaluator.leakMemoryAmount(options.leakMemoryAmount);
                log.warn("[TAE] Target Algorithm Evaluators will leak memory. I hope you know what you are doing");
                tae = new LeakingMemoryTargetAlgorithmEvaluator(tae);
            }
            if (options.runHashCodeFile != null) {
                log.trace("[TAE] Algorithm Execution will verify run Hash Codes");
                Queue<Integer> runHashCodes = TargetAlgorithmEvaluatorBuilder.parseRunHashCodes(options.runHashCodeFile);
                tae = new RunHashCodeVerifyingAlgorithmEvalutor(tae, runHashCodes);
            } else {
                log.trace("[TAE] Algorithm Execution will NOT verify run Hash Codes");
            }
        }
        tae = new TimingCheckerTargetAlgorithmEvaluator(execConfig, tae);
        tae = new PrePostCommandTargetAlgorithmEvaluator(tae, options.prePostOptions);
        if (!options.skipOutstandingEvaluationsTAE) {
            tae = new OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator(tae);
            log.trace("[TAE] Waiting / Monitoring outstanding target algorithm evaluations is supported");
        } else {
            log.debug("[TAE] Waiting / Monitoring outstanding target algorithm evaluations will NOT be supported");
        }
        if (options.checkRunConfigsUnique) {
            log.trace("[TAE] Checking that every request in a batch is unique");
            tae = new CheckForDuplicateRunConfigDecorator(tae, options.checkRunConfigsUniqueException);
        } else {
            log.debug("[TAE] Not Checking that every request to the TAE is unique, this may cause weird errors");
        }
        if (options.killCaptimeExceedingRun) {
            log.trace("[TAE] Killing runs that exceed there captime by a factor of {} ", (Object)options.killCaptimeExceedingRunFactor);
            tae = new KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator(tae, options.killCaptimeExceedingRunFactor);
        }
        if (options.fileToWatch != null) {
            log.trace("[TAE] Killing runs if {} is deleted", (Object)options.fileToWatch);
            tae = new TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator(tae, new File(options.fileToWatch));
        }
        if (options.warnIfNoResponseFromTAE > 0) {
            log.trace("[TAE] Warning if no response after {} seconds", (Object)options.warnIfNoResponseFromTAE);
            tae = new WarnOnNoWallOrRuntimeTargetAlgorithmEvaluatorDecorator(tae, options.warnIfNoResponseFromTAE);
        }
        if (options.synchronousObserver) {
            log.trace("[TAE] Synchronizing notifications to the observer");
            tae = new SynchronousObserverTargetAlgorithmEvaluatorDecorator(tae);
        } else {
            log.debug("[TAE] Skipping synchronization of observers, this may cause weird threading issues");
        }
        if (options.logRequestResponses) {
            log.trace("[TAE] Logging every request and response");
            tae = new LogEveryTargetAlgorithmEvaluatorDecorator(tae, options.logRequestResponsesRCOnly);
        }
        log.debug("Final Target Algorithm Built is {}", (Object)tae);
        return tae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<Integer> parseRunHashCodes(File runHashCodeFile) {
        log.debug("Run Hash Code File Path {}", (Object)runHashCodeFile.getAbsolutePath());
        LinkedList<Integer> runHashCodeQueue = new LinkedList<Integer>();
        BufferedReader bin = null;
        try {
            try {
                String line;
                bin = new BufferedReader(new FileReader(runHashCodeFile));
                int hashCodeCount = 0;
                int lineCount = 1;
                while ((line = bin.readLine()) != null) {
                    Matcher m = RUN_HASH_CODE_PATTERN.matcher(line);
                    if (m.find()) {
                        Object[] array = new Object[]{++hashCodeCount, lineCount, line};
                        log.debug("Found Run Hash Code #{} on line #{} with contents:{}", array);
                        int colonIndex = line.indexOf(":");
                        int spaceIndex = line.indexOf(" ", colonIndex);
                        String lineSubStr = line.substring(colonIndex + 1, spaceIndex);
                        runHashCodeQueue.add(Integer.valueOf(lineSubStr));
                    }
                    ++lineCount;
                }
                if (hashCodeCount == 0) {
                    log.warn("Hash Code File Specified, but we found no hash codes");
                }
            }
            finally {
                if (bin != null) {
                    bin.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return runHashCodeQueue;
    }
}

