/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeletedTerminateCondition
extends AbstractTerminationCondition {
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private final ScheduledExecutorService execService = Executors.newScheduledThreadPool(1, new SequentiallyNamedThreadFactory("Terminate Run FileWatcher", true));
    private final long POLL_FREQUENCY = 2L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String filename;

    public FileDeletedTerminateCondition(final File fileToWatch) {
        this.filename = fileToWatch.getAbsolutePath();
        this.log.info("Terminating procedure if {} is deleted", (Object)fileToWatch);
        if (!fileToWatch.exists()) {
            this.log.warn("File To Watch: {} does not exist, was it already deleted?", (Object)fileToWatch);
        }
        this.execService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!fileToWatch.exists() && !FileDeletedTerminateCondition.this.terminate.getAndSet(true)) {
                    FileDeletedTerminateCondition.this.log.info("File {} has been deleted, procedure set to terminate", (Object)fileToWatch);
                }
            }
        }, 2L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public boolean haveToStop() {
        return this.terminate.get();
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.emptySet();
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "file being watched " + this.filename + " was deleted on disk.";
        }
        return "";
    }
}

