/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.configurator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IterationStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.state.StateRestoredEvent;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.exceptions.OutOfTimeException;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.RandomUtil;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistoryHelper;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.SMACOptions;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.termination.CompositeTerminationCondition;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.termination.standard.ConfigurationSpaceExhaustedCondition;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import com.beust.jcommander.ParameterException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAlgorithmFramework {
    protected ThreadSafeRunHistory runHistory;
    protected final long applicationStartTime = System.currentTimeMillis();
    protected final ParamConfigurationSpace configSpace;
    protected final double cutoffTime;
    protected final List<ProblemInstance> instances;
    protected final TargetAlgorithmEvaluator tae;
    protected final SMACOptions options;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StateFactory stateFactory;
    private int iteration = 0;
    protected ParamConfiguration incumbent = null;
    private final int MAX_RUNS_FOR_INCUMBENT;
    private final List<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>();
    protected InstanceSeedGenerator instanceSeedGen;
    private final ParamConfiguration initialIncumbent;
    private final EventManager evtManager;
    protected SeedableRandomPool pool;
    private final CompositeTerminationCondition termCond;
    protected final ParamConfigurationOriginTracker configTracker;
    private final InitializationProcedure initProc;
    private final AtomicBoolean shouldWriteStateOnCrash = new AtomicBoolean(false);
    private final CPUTime cpuTime;
    private final String objectiveToReport;
    private static final String OBJECT_MAP_POOL_KEY = "POOL";
    private static final String OBJECT_MAP_INSTANCE_SEED_GEN_KEY = "INSTANCE_SEED_GEN";
    boolean outOfTime = false;
    private int incumbentRunsLogged = 0;
    double timedOutRunCost;
    private int selectionCount = 0;
    private static double currentIncumbentCost;
    private static final double BEST_POSSIBLE_VALUE = 0.0;
    private static final double UNCOMPETITIVE_CAPTIME = 0.0;
    private String terminationReason = null;

    public AbstractAlgorithmFramework(SMACOptions smacOptions, List<ProblemInstance> instances, TargetAlgorithmEvaluator algoEval, StateFactory stateFactory, ParamConfigurationSpace configSpace, InstanceSeedGenerator instanceSeedGen, ParamConfiguration initialIncumbent, EventManager manager, ThreadSafeRunHistory rh, SeedableRandomPool pool, CompositeTerminationCondition termCond, ParamConfigurationOriginTracker originTracker, InitializationProcedure initProc, CPUTime cpuTime) {
        this.cpuTime = cpuTime;
        this.instances = instances;
        this.cutoffTime = smacOptions.scenarioConfig.algoExecOptions.cutoffTime;
        this.options = smacOptions;
        this.tae = algoEval;
        this.stateFactory = stateFactory;
        this.configSpace = configSpace;
        this.runHistory = rh;
        this.instanceSeedGen = instanceSeedGen;
        this.initialIncumbent = initialIncumbent;
        this.evtManager = manager;
        this.pool = pool;
        this.termCond = termCond;
        if (initialIncumbent.isForbiddenParamConfiguration()) {
            throw new ParameterException("Initial Incumbent specified is forbidden: " + this.initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
        }
        long time = System.currentTimeMillis();
        Date d = new Date(time);
        DateFormat df = DateFormat.getDateTimeInstance();
        OverallObjective intraInstanceObj = smacOptions.scenarioConfig.getIntraInstanceObjective();
        block0 : switch (smacOptions.scenarioConfig.getRunObjective()) {
            case RUNTIME: {
                switch (intraInstanceObj) {
                    case MEAN: {
                        this.objectiveToReport = "mean runtime";
                        break block0;
                    }
                    case MEAN10: {
                        this.objectiveToReport = "penalized average runtime (PAR10)";
                        break block0;
                    }
                    case MEAN1000: {
                        this.objectiveToReport = "penalized average runtime (PAR1000)";
                        break block0;
                    }
                }
                this.objectiveToReport = intraInstanceObj + " " + smacOptions.scenarioConfig.getRunObjective();
                break;
            }
            case QUALITY: {
                switch (intraInstanceObj) {
                    case MEAN: {
                        this.objectiveToReport = "mean quality";
                        break block0;
                    }
                }
                this.objectiveToReport = intraInstanceObj + " " + smacOptions.scenarioConfig.getRunObjective();
                break;
            }
            default: {
                this.objectiveToReport = intraInstanceObj + " " + smacOptions.scenarioConfig.getRunObjective();
            }
        }
        this.log.info("SMAC started at: {}. Minimizing {}.", (Object)df.format(d), (Object)this.objectiveToReport);
        if (instanceSeedGen.getInitialInstanceSeedCount() < this.options.maxIncumbentRuns) {
            this.log.debug("Clamping number of runs to {} due to lack of instance/seeds pairs", (Object)instanceSeedGen.getInitialInstanceSeedCount());
            this.MAX_RUNS_FOR_INCUMBENT = instanceSeedGen.getInitialInstanceSeedCount();
        } else {
            this.MAX_RUNS_FOR_INCUMBENT = smacOptions.maxIncumbentRuns;
            this.log.debug("Maximimum number of runs for the incumbent initialized to {}", (Object)this.MAX_RUNS_FOR_INCUMBENT);
        }
        ConfigurationSpaceExhaustedCondition cond = new ConfigurationSpaceExhaustedCondition(configSpace, this.MAX_RUNS_FOR_INCUMBENT);
        cond.registerWithEventManager(this.evtManager);
        termCond.addCondition((TerminationCondition)cond);
        this.configTracker = originTracker;
        this.initProc = initProc;
        if (this.options.saveRunsEveryIteration && this.options.scenarioConfig.algoExecOptions.cutoffTime <= 600.0) {
            this.log.warn("Saving runs every iteration is discouraged for small cap times and may cause a significant amount of overhead due to file I/O.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (AbstractAlgorithmFramework.this.shouldWriteStateOnCrash.get()) {
                    AbstractAlgorithmFramework.this.log.info("Making best attempt to save state. This state may be dirty, in that it was taken in the middle of an iteration and consequently may not be restorable. It may also be corrupt depending on the exact reason we are shutting down.");
                    AbstractAlgorithmFramework.this.saveState("SHUTDOWN", true);
                } else {
                    AbstractAlgorithmFramework.this.log.trace("State Saved Already, Skipping Shutdown Version");
                }
            }
        }));
    }

    public String getObjectiveToReport() {
        return this.objectiveToReport;
    }

    public ParamConfiguration getInitialIncumbent() {
        return this.initialIncumbent;
    }

    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    public void restoreState(StateDeserializer sd) {
        try {
            this.log.debug("Restoring State");
            int myIteration = sd.getIteration();
            if (myIteration >= 0) {
                this.iteration = myIteration;
            } else {
                this.log.debug("No iteration info found it state file, staying at iteration 0");
            }
            this.runHistory = new ThreadSafeRunHistoryWrapper(sd.getRunHistory());
            Map map = sd.getObjectStateMap();
            if (map.get(OBJECT_MAP_POOL_KEY) != null) {
                this.pool = (SeedableRandomPool)map.get(OBJECT_MAP_POOL_KEY);
            } else {
                this.log.debug("Incomplete state detected using existing Random Pool object");
            }
            if (map.get(OBJECT_MAP_INSTANCE_SEED_GEN_KEY) != null) {
                this.instanceSeedGen = (InstanceSeedGenerator)map.get(OBJECT_MAP_INSTANCE_SEED_GEN_KEY);
            } else {
                this.log.debug("Incomplete state detected using existing instance seed generator");
            }
            if (this.pool == null) {
                throw new IllegalStateException("The pool we restored was null, this state file cannot be restored in SMAC");
            }
            if (this.instanceSeedGen == null) {
                throw new IllegalStateException("The instance seed generator we restored was null, this state file cannot be restored in SMAC");
            }
            this.incumbent = sd.getIncumbent();
            if (this.incumbent == null) {
                this.incumbent = this.initialIncumbent;
            }
            HashSet<ProblemInstanceSeedPair> allPisps = new HashSet<ProblemInstanceSeedPair>();
            for (AlgorithmRun run : this.runHistory.getAlgorithmRunsExcludingRedundant()) {
                ProblemInstanceSeedPair pisp = run.getRunConfig().getProblemInstanceSeedPair();
                allPisps.add(run.getRunConfig().getProblemInstanceSeedPair());
                this.log.trace("Blacklisting problem instance seed pair: {} ", (Object)pisp);
                this.instanceSeedGen.take(pisp.getInstance(), pisp.getSeed());
            }
            if (this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).size() != allPisps.size()) {
                throw new ParameterException("Incumbent has been run on " + this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).size() + " problem instance seed pair(s), but there have been a total of " + allPisps.size() + " run. This generally means the state data used to restore SMAC needs to be repaired to preserve this invariant. Please run the state data through the state-merge utility to repair this invariant");
            }
            this.log.debug("Incumbent Set To {}", (Object)this.incumbent);
            this.tae.seek(this.runHistory.getAlgorithmRunsIncludingRedundant());
            for (AlgorithmRun run : this.runHistory.getAlgorithmRunsIncludingRedundant()) {
                this.termCond.notifyRun(run);
            }
            this.fireEvent((AutomaticConfiguratorEvent)new StateRestoredEvent((TerminationCondition)this.termCond, this.iteration, this.runHistory, this.incumbent));
            this.log.debug("Restored to Iteration {}", (Object)this.iteration);
        }
        catch (RuntimeException e) {
            this.tae.notifyShutdown();
            throw e;
        }
    }

    protected boolean shouldSave() {
        return true;
    }

    private void saveState() {
        if (this.options.intermediarySaves) {
            boolean saveFull;
            boolean perfectPowerOfTwo = (this.iteration - 1 & this.iteration) == 0;
            boolean saveRunsEveryIteration = this.options.saveRunsEveryIteration;
            boolean bl = saveFull = perfectPowerOfTwo || saveRunsEveryIteration;
            if (saveFull) {
                this.saveState("it", true);
            } else {
                boolean quickSavesEnabled = this.options.stateQuickSaves;
                if (quickSavesEnabled) {
                    this.saveState("it", false);
                }
            }
        }
    }

    private synchronized void saveState(String id, boolean saveFullState) {
        StateSerializer state = this.stateFactory.getStateSerializer(id, this.iteration);
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put(OBJECT_MAP_POOL_KEY, this.pool);
        objMap.put(OBJECT_MAP_INSTANCE_SEED_GEN_KEY, this.instanceSeedGen);
        state.setObjectStateMap(objMap);
        if (saveFullState) {
            state.setRunHistory((RunHistory)this.runHistory);
        }
        state.setIncumbent(this.incumbent);
        state.save();
    }

    protected boolean have_to_stop(int iteration) {
        this.outOfTime = true;
        this.outOfTime = this.termCond.haveToStop();
        return this.outOfTime;
    }

    public void logIncumbent() {
        this.logIncumbent(-1);
    }

    public void logIncumbent(int iteration) {
        if (iteration > 0) {
            Object[] arr = new Object[]{iteration, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.debug("At end of iteration {}, incumbent is {} ({}) ", arr);
        } else {
            this.log.debug("Incumbent currently is: {} ({}) ", (Object)this.runHistory.getThetaIdx(this.incumbent), (Object)this.incumbent);
        }
    }

    public int getIteration() {
        return this.iteration;
    }

    private void fireEvent(AutomaticConfiguratorEvent evt) {
        this.evtManager.fireEvent(evt);
        this.evtManager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                if (this.pool == null) {
                    throw new IllegalStateException("pool is null, this was unexpected");
                }
                if (this.iteration == 0) {
                    this.incumbent = this.initialIncumbent;
                    this.iteration = 0;
                    this.log.trace("Initialization Procedure Started");
                    this.initProc.run();
                    this.log.trace("Initialization Procedure Completed");
                    this.incumbent = this.initProc.getIncumbent();
                    this.updateIncumbentCost();
                    this.log.info("First incumbent: config {} (internal ID: {}), with {}: {}; estimate based on {} runs.", new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.objectiveToReport, currentIncumbentCost, this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent)});
                    this.logConfiguration("new incumbent", this.incumbent);
                    this.logIncumbent(this.iteration);
                }
                this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent), this.initialIncumbent, this.cpuTime));
                this.incumbentRunsLogged = this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent);
                try {
                    while (!this.have_to_stop(this.iteration + 1)) {
                        this.shouldWriteStateOnCrash.set(true);
                        if (this.shouldSave()) {
                            this.saveState();
                        }
                        this.runHistory.incrementIteration();
                        ++this.iteration;
                        this.log.debug("Starting Iteration {}", (Object)this.iteration);
                        this.fireEvent((AutomaticConfiguratorEvent)new IterationStartEvent((TerminationCondition)this.termCond, this.iteration));
                        this.fireEvent((AutomaticConfiguratorEvent)new ModelBuildStartEvent((TerminationCondition)this.termCond));
                        AutoStartStopWatch t = new AutoStartStopWatch();
                        this.learnModel((RunHistory)this.runHistory, this.configSpace);
                        this.log.trace("Model Learn Time: {} (s)", (Object)((double)t.time() / 1000.0));
                        this.fireEvent((AutomaticConfiguratorEvent)new ModelBuildEndEvent((TerminationCondition)this.termCond, this.getModel()));
                        ArrayList<ParamConfiguration> challengers = new ArrayList<ParamConfiguration>();
                        challengers.addAll(this.selectConfigurations());
                        double learnModelTime = (double)t.stop() / 1000.0;
                        double intensifyTime = Math.ceil(learnModelTime) * (this.options.intensificationPercentage / (1.0 - this.options.intensificationPercentage));
                        this.intensify(challengers, intensifyTime);
                        this.logIncumbent(this.iteration);
                    }
                }
                catch (OutOfTimeException e) {
                    this.logIncumbent(this.iteration);
                }
                this.saveState("it", true);
                this.shouldWriteStateOnCrash.set(false);
                this.log.trace("SMAC Completed");
                if (this.options.stateOpts.cleanOldStatesOnSuccess) {
                    this.log.trace("Cleaning old states");
                    this.stateFactory.purgePreviousStates();
                }
            }
            catch (RuntimeException e) {
                try {
                    this.saveState("CRASH", true);
                    this.shouldWriteStateOnCrash.set(false);
                }
                catch (RuntimeException e2) {
                    this.log.error("SMAC has encountered an exception, and encountered another exception while trying to save the local state. NOTE: THIS PARTICULAR ERROR DID NOT CAUSE SMAC TO FAIL, the original culprit follows further below. (This second error is potentially another / seperate issue, or a disk failure of some kind.) When submitting bug/error reports, please include enough context for *BOTH* exceptions \n  ", (Throwable)e2);
                    throw e;
                }
                throw e;
            }
        }
        finally {
            this.fireEvent((AutomaticConfiguratorEvent)new AutomaticConfigurationEnd((TerminationCondition)this.termCond, this.incumbent, currentIncumbentCost));
            this.tae.notifyShutdown();
        }
    }

    protected void learnModel(RunHistory runHistory, ParamConfigurationSpace configSpace) {
    }

    public String logIncumbentPerformance(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        ParamConfiguration lastIncumbent = null;
        double lastEmpericalPerformance = Double.POSITIVE_INFINITY;
        double lastTestSetPerformance = Double.POSITIVE_INFINITY;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> entries = new ArrayList<String>();
        String lastEntry = "";
        for (Map.Entry<TrajectoryFileEntry, Double> ents : tfePerformance.entrySet()) {
            Object[] args2;
            tfe = ents.getKey();
            double empiricalPerformance = tfe.getEmpericalPerformance();
            testSetPerformance = ents.getValue();
            double tunerTime = tfe.getTunerTime();
            ParamConfiguration formerIncumbent = tfe.getConfiguration();
            if (formerIncumbent.equals(lastIncumbent) && empiricalPerformance == lastEmpericalPerformance && lastTestSetPerformance == testSetPerformance) continue;
            lastIncumbent = formerIncumbent;
            lastEmpericalPerformance = empiricalPerformance;
            lastTestSetPerformance = testSetPerformance;
            if (Double.isInfinite(testSetPerformance)) {
                args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empiricalPerformance};
                entries.add("Time: " + tfe.getWallTime() + " config " + this.runHistory.getThetaIdx(formerIncumbent) + " (internal ID: " + formerIncumbent + "): " + empiricalPerformance + " based on " + this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(formerIncumbent) + " runs with the config on the training set");
                lastEntry = "Final time: " + tfe.getWallTime() + " config " + this.runHistory.getThetaIdx(formerIncumbent) + " (internal ID: " + formerIncumbent + "): " + empiricalPerformance + " based on " + this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(formerIncumbent) + " runs with the config on the training set";
                continue;
            }
            args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empiricalPerformance, testSetPerformance};
            entries.add("Time: " + tfe.getWallTime() + " config " + this.runHistory.getThetaIdx(formerIncumbent) + " (internal ID: " + formerIncumbent + "): " + testSetPerformance + " on the test set");
            lastEntry = "Final time: " + tfe.getWallTime() + " config " + this.runHistory.getThetaIdx(formerIncumbent) + " (internal ID: " + formerIncumbent + "): " + testSetPerformance + " on the test set";
        }
        entries.set(entries.size() - 1, lastEntry);
        for (String ent : entries) {
            sb.append(ent).append("\n");
        }
        return sb.toString();
    }

    public String logSMACResult(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        tfe = tfePerformance.lastKey();
        testSetPerformance = (Double)tfePerformance.get(tfe);
        if (tfe != null && !tfe.getConfiguration().equals((Object)this.incumbent)) {
            throw new IllegalStateException("Last TFE should be Incumbent");
        }
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig runConfig = new RunConfig(pisp, this.cutoffTime, this.incumbent);
        String cmd = this.tae.getManualCallString(runConfig);
        Object[] args = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, cmd};
        Object[] args2 = Double.isInfinite(testSetPerformance) ? new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime)} : new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime), testSetPerformance};
        StringBuilder sb = new StringBuilder();
        sb.append("Sample call for the final incumbent:\n" + cmd).append("\n");
        return sb.toString();
    }

    protected Object getModel() {
        return null;
    }

    protected List<ParamConfiguration> selectConfigurations() {
        ParamConfiguration config = this.configSpace.getRandomConfiguration(this.pool.getRandom("ROAR_RANDOM_CONFIG"));
        this.log.trace("Selecting a random configuration {}", (Object)config);
        this.configTracker.addConfiguration(config, "RANDOM", new String[]{"SelectionCount=" + this.selectionCount});
        return Collections.singletonList(config);
    }

    private void intensify(List<ParamConfiguration> challengers, double timeBound) {
        double initialTime = this.runHistory.getTotalRunCost();
        this.log.debug("Calling intensify with {} challenger(s)", (Object)challengers.size());
        for (int i = 0; i < challengers.size(); ++i) {
            double timeUsed = this.runHistory.getTotalRunCost() - initialTime;
            if (timeUsed > timeBound && i > 1) {
                this.log.debug("Out of time for intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
                break;
            }
            this.log.debug("Intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
            this.challengeIncumbent(challengers.get(i));
        }
    }

    private void challengeIncumbent(ParamConfiguration challenger) {
        this.fireEvent((AutomaticConfiguratorEvent)new ChallengeStartEvent((TerminationCondition)this.termCond, challenger));
        this.challengeIncumbent(challenger, true);
        this.fireEvent((AutomaticConfiguratorEvent)new ChallengeEndEvent((TerminationCondition)this.termCond, challenger, this.getIncumbent().equals((Object)challenger), this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(challenger)));
    }

    private void challengeIncumbent(ParamConfiguration challenger, boolean runIncumbent) {
        if (runIncumbent) {
            if (this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent) < this.MAX_RUNS_FOR_INCUMBENT) {
                this.log.debug("Performing additional run with the incumbent ");
                ProblemInstanceSeedPair pisp = RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor((ThreadSafeRunHistory)this.runHistory, (InstanceSeedGenerator)this.instanceSeedGen, (ParamConfiguration)this.incumbent, this.instances, (Random)this.pool.getRandom("CHALLENGE_INCUMBENT_INSTANCE_SELECTION"), (boolean)this.options.deterministicInstanceOrdering);
                RunConfig incumbentRunConfig = this.getRunConfig(pisp, this.cutoffTime, this.incumbent);
                this.evaluateRun(incumbentRunConfig);
                this.updateIncumbentCost();
                this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent), this.incumbent, this.cpuTime));
                int incumbentRunsLoggedPrevious = 200 * this.incumbentRunsLogged / this.MAX_RUNS_FOR_INCUMBENT;
                int incumbentRunsLoggedNow = 200 * (1 + this.incumbentRunsLogged) / this.MAX_RUNS_FOR_INCUMBENT;
                ++this.incumbentRunsLogged;
                if (incumbentRunsLoggedNow > incumbentRunsLoggedPrevious) {
                    this.log.info("Updated estimated {} of the same incumbent: {}; estimate now based on {} runs.", new Object[]{this.objectiveToReport, currentIncumbentCost, this.incumbentRunsLogged});
                }
                if (this.options.alwaysRunInitialConfiguration && !this.incumbent.equals((Object)this.initialIncumbent)) {
                    Object[] args = new Object[]{this.runHistory.getThetaIdx(this.initialIncumbent), this.initialIncumbent, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
                    this.log.trace("Trying challenge with initial configuration {} ({}) first (current incumbent {} ({})", args);
                    this.challengeIncumbent(this.initialIncumbent, false);
                    this.log.trace("Challenge with initial configuration done");
                }
            } else {
                this.log.trace("Already have performed max runs ({}) for incumbent", (Object)this.MAX_RUNS_FOR_INCUMBENT);
            }
        }
        if (challenger.equals((Object)this.incumbent)) {
            Object[] args = new Object[]{this.runHistory.getThetaIdx(challenger), challenger, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.debug("Challenger {} ({}) is equal to the incumbent {} ({}); not evaluating it further ", args);
            return;
        }
        int N = this.options.initialChallengeRuns;
        while (true) {
            HashSet<ProblemInstanceSeedPair> sMissing = new HashSet<ProblemInstanceSeedPair>(this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent));
            sMissing.removeAll(this.runHistory.getProblemInstanceSeedPairsRan(challenger));
            List<ProblemInstanceSeedPair> aMissing = new ArrayList<ProblemInstanceSeedPair>();
            aMissing.addAll(sMissing);
            int runsToMake = Math.min(N, aMissing.size());
            if (runsToMake == 0) {
                this.log.debug("Aborting challenge of incumbent. Incumbent has " + this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent) + " runs, challenger has " + this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(challenger) + " runs, and the maximum runs for any config is set to " + this.MAX_RUNS_FOR_INCUMBENT + ".");
                return;
            }
            Collections.sort(aMissing);
            int[] permutations = RandomUtil.getPermutation((int)aMissing.size(), (int)0, (Random)this.pool.getRandom("CHALLENGE_INCUMBENT_SHUFFLE"));
            RandomUtil.permuteList(aMissing, (int[])permutations);
            aMissing = aMissing.subList(0, runsToMake);
            double bound_inc = Double.POSITIVE_INFINITY;
            HashSet<ProblemInstance> missingInstances = null;
            HashSet<ProblemInstance> missingPlusCommon = null;
            if (this.options.adaptiveCapping.booleanValue()) {
                missingInstances = new HashSet<ProblemInstance>();
                for (int i = 0; i < runsToMake; ++i) {
                    missingInstances.add(((ProblemInstanceSeedPair)aMissing.get(i)).getInstance());
                }
                missingPlusCommon = new HashSet<ProblemInstance>();
                missingPlusCommon.addAll(missingInstances);
                Set piCommon = this.runHistory.getProblemInstancesRan(this.incumbent);
                piCommon.retainAll(this.runHistory.getProblemInstancesRan(challenger));
                missingPlusCommon.addAll(piCommon);
                bound_inc = this.runHistory.getEmpiricalCost(this.incumbent, missingPlusCommon, this.cutoffTime) + Math.pow(10.0, -3.0);
            }
            Object[] args2 = new Object[]{N, this.runHistory.getThetaIdx(challenger) != -1 ? " " + this.runHistory.getThetaIdx(challenger) : "", challenger, bound_inc};
            this.log.debug("Performing up to {} run(s) for challenger{} ({}) up to a total bound of {} ", args2);
            ArrayList<RunConfig> runsToEval = new ArrayList<RunConfig>(this.options.scenarioConfig.algoExecOptions.taeOpts.maxConcurrentAlgoExecs);
            if (this.options.adaptiveCapping.booleanValue() && this.incumbentImpossibleToBeat(challenger, (ProblemInstanceSeedPair)aMissing.get(0), aMissing, missingPlusCommon, this.cutoffTime, bound_inc)) {
                this.log.trace("Challenger cannot beat incumbent => scheduling empty run");
                runsToEval.add(this.getBoundedRunConfig(aMissing.get(0), 0.0, challenger));
                if (runsToMake != 1) {
                    throw new IllegalStateException("Error in empty run scheduling: empty runs should only be scheduled in first iteration of intensify.");
                }
            } else {
                for (int i = 0; i < runsToMake; ++i) {
                    RunConfig runConfig;
                    ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)aMissing.get(0);
                    if (this.options.adaptiveCapping.booleanValue()) {
                        double capTime = this.computeCap(challenger, pisp, aMissing, missingPlusCommon, this.cutoffTime, bound_inc);
                        if (capTime < this.cutoffTime) {
                            if (capTime <= 0.0) break;
                            runConfig = this.getBoundedRunConfig(pisp, capTime, challenger);
                        } else {
                            runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                        }
                    } else {
                        runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                    }
                    runsToEval.add(runConfig);
                    sMissing.remove(pisp);
                    aMissing.remove(0);
                    if (runsToEval.size() != this.options.scenarioConfig.algoExecOptions.taeOpts.maxConcurrentAlgoExecs) continue;
                    this.evaluateRun(runsToEval);
                    runsToEval.clear();
                }
            }
            if (runsToEval.size() > 0) {
                this.evaluateRun(runsToEval);
                runsToEval.clear();
            }
            if (!this.shouldContinueChallenge(challenger, sMissing)) break;
            N *= 2;
        }
    }

    private boolean shouldContinueChallenge(ParamConfiguration challenger, Set<ProblemInstanceSeedPair> outstandingPispSet) {
        Set piCommon = this.runHistory.getProblemInstancesRan(this.incumbent);
        piCommon.retainAll(this.runHistory.getProblemInstancesRan(challenger));
        double incCost = this.runHistory.getEmpiricalCost(this.incumbent, piCommon, this.cutoffTime);
        double chalCost = this.runHistory.getEmpiricalCost(challenger, piCommon, this.cutoffTime);
        this.log.debug("Based on {} common runs on (up to) {} instances, challenger {}  has a lower bound {} and incumbent {} has obj {}", new Object[]{piCommon.size(), this.runHistory.getUniqueInstancesRan().size(), this.getConfigurationString(challenger), chalCost, this.getConfigurationString(this.incumbent), incCost});
        if (incCost + Math.pow(10.0, -6.0) < chalCost) {
            this.log.debug("Challenger {} is worse; aborting its evaluation", (Object)this.getConfigurationString(challenger));
            this.configTracker.addConfiguration(challenger, "Challenge-Round-" + this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(challenger), new String[]{"Continue=False", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
            return false;
        }
        if (outstandingPispSet.isEmpty()) {
            if (chalCost < incCost - Math.pow(10.0, -6.0)) {
                this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=True", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                this.changeIncumbentTo(challenger);
            } else {
                this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=False", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                this.log.debug("Challenger {} has all the runs of the incumbent, but did not outperform it", (Object)this.getConfigurationString(challenger));
            }
            return false;
        }
        this.configTracker.addConfiguration(challenger, "Challenge-Round-" + this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(challenger), new String[]{"Continue=True", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost, "RunsNeededLeft=" + (this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent) - this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(challenger))});
        return true;
    }

    private void logConfiguration(String type, ParamConfiguration challenger) {
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig config = new RunConfig(pisp, this.cutoffTime, challenger);
        String cmd = this.tae.getManualCallString(config);
        Object[] args = new Object[]{type, this.runHistory.getThetaIdx(challenger), challenger, cmd};
        this.log.info("Sample call for {} config {} (internal ID: {}): \n{} ", args);
    }

    private void changeIncumbentTo(ParamConfiguration challenger) {
        Set earlyCensoredPISPs = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(challenger);
        Set piCommon = this.runHistory.getProblemInstancesRan(this.incumbent);
        piCommon.retainAll(this.runHistory.getProblemInstancesRan(challenger));
        if (earlyCensoredPISPs.size() > 0) {
            this.log.warn("Configuration {} which has been selected to replace the current incumbent {} has {} early censored runs. Future versions of SMAC will handle this case properly. For now we will simply repair the invariant manually by running all capped runs up to kappaMax. This warning can be safely ignored, it exists only so that this condition has some visibility (as SMAC could be improved by fixing this)", new Object[]{this.getConfigurationString(challenger), this.getConfigurationString(this.incumbent), earlyCensoredPISPs.size()});
            ArrayList<RunConfig> rcs = new ArrayList<RunConfig>();
            for (ProblemInstanceSeedPair pisp : earlyCensoredPISPs) {
                rcs.add(this.getRunConfig(pisp, this.cutoffTime, challenger));
            }
            this.evaluateRun(rcs);
            double incCost = this.runHistory.getEmpiricalCost(this.incumbent, piCommon, this.cutoffTime);
            double chalCost = this.runHistory.getEmpiricalCost(challenger, piCommon, this.cutoffTime);
            if (chalCost < incCost - Math.pow(10.0, -6.0)) {
                this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=True", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                this.log.debug("Challenger {} has all the runs of the incumbent now, and did outperform it", (Object)this.getConfigurationString(challenger));
            } else {
                this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=False", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                this.log.debug("Challenger {} has all the runs of the incumbent, but did not outperform it", (Object)this.getConfigurationString(challenger));
                return;
            }
        }
        if (!(earlyCensoredPISPs = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(challenger)).isEmpty()) {
            throw new IllegalStateException("Incumbent seemingly has capped runs:" + earlyCensoredPISPs);
        }
        double incCost = this.runHistory.getEmpiricalCost(this.incumbent, piCommon, this.cutoffTime);
        double chalCost = this.runHistory.getEmpiricalCost(challenger, piCommon, this.cutoffTime);
        if (!this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).equals(this.runHistory.getProblemInstanceSeedPairsRan(challenger))) {
            this.log.warn("Incumbent Runs: {}", (Object)this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent));
            this.log.warn("Challenger Runs: {}", (Object)this.runHistory.getProblemInstanceSeedPairsRan(challenger));
            throw new IllegalStateException("The Incumbent " + this.getConfigurationString(this.incumbent) + " has " + this.runHistory.getProblemInstanceSeedPairsRan(this.incumbent).size() + " problem instance seed pairs run, where as the challenger " + this.getConfigurationString(challenger) + " has " + this.runHistory.getProblemInstanceSeedPairsRan(challenger).size() + " problem instance seed pairs run. The corresponding sets are not equal");
        }
        if (chalCost > incCost - Math.pow(10.0, -6.0)) {
            throw new IllegalStateException("The Incumbent " + this.getConfigurationString(this.incumbent) + " has " + this.objectiveToReport + " " + incCost + " on currently available problem instance seed pairs, where as the challenger " + this.getConfigurationString(challenger) + " has " + chalCost + " " + this.objectiveToReport + " currently. We expect that the chal cost + 10^-6 is less than the incumbent cost");
        }
        ParamConfiguration oldIncumbent = this.incumbent;
        this.incumbent = challenger;
        this.updateIncumbentCost();
        this.log.info("Incumbent changed to: config {} (internal ID: {}), with {}: {}; estimate based on {} runs.", new Object[]{this.runHistory.getThetaIdx(challenger), challenger, this.objectiveToReport, currentIncumbentCost, this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(challenger)});
        this.logConfiguration("new incumbent", challenger);
        this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.incumbent), oldIncumbent, this.cpuTime));
    }

    private double computeCap(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        if (this.incumbentImpossibleToBeat(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc)) {
            return 0.0;
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc, 0.0, cutofftime);
    }

    private boolean incumbentImpossibleToBeat(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        return this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, instanceSet, cutofftime, 0.0) > bound_inc;
    }

    private double computeCapBinSearch(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> missingInstances, double cutofftime, double bound_inc, double lowerBound, double upperBound) {
        if (upperBound - lowerBound < Math.pow(10.0, -6.0)) {
            double capTime = upperBound + Math.pow(10.0, -3.0);
            return capTime * this.options.capSlack + this.options.capAddSlack;
        }
        double mean = (upperBound + lowerBound) / 2.0;
        double predictedPerformance = this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, missingInstances, cutofftime, mean);
        if (predictedPerformance < bound_inc) {
            return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, mean, upperBound);
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, lowerBound, mean);
    }

    private double lowerBoundOnEmpiricalPerformance(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double probe) {
        HashMap hallucinatedValues = new HashMap();
        for (ProblemInstanceSeedPair missingPisp : aMissing) {
            ProblemInstance pi = missingPisp.getInstance();
            if (hallucinatedValues.get(pi) == null) {
                hallucinatedValues.put(pi, new HashMap());
            }
            double hallucinatedValue = 0.0;
            if (pisp.equals((Object)missingPisp)) {
                hallucinatedValue = probe;
            }
            ((Map)hallucinatedValues.get(pi)).put(missingPisp.getSeed(), hallucinatedValue);
        }
        return this.runHistory.getEmpiricalCost(challenger, instanceSet, cutofftime, hallucinatedValues);
    }

    private void updateIncumbentCost() {
        currentIncumbentCost = this.runHistory.getEmpiricalCost(this.incumbent, new HashSet<ProblemInstance>(this.instances), this.cutoffTime);
    }

    protected RunConfig getRunConfig(ProblemInstanceSeedPair pisp, double cutofftime, ParamConfiguration configuration) {
        RunConfig rc = new RunConfig(pisp, cutofftime, configuration);
        return rc;
    }

    private RunConfig getBoundedRunConfig(ProblemInstanceSeedPair pisp, double capTime, ParamConfiguration challenger) {
        RunConfig rc = new RunConfig(pisp, capTime, challenger, true);
        return rc;
    }

    protected List<AlgorithmRun> updateRunHistory(List<AlgorithmRun> runs) {
        for (AlgorithmRun run : runs) {
            try {
                this.runHistory.append(run);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
        }
        return runs;
    }

    protected List<AlgorithmRun> evaluateRun(RunConfig runConfig) {
        return this.evaluateRun(Collections.singletonList(runConfig));
    }

    protected List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        if (this.have_to_stop(this.iteration)) {
            this.log.debug("Cannot schedule any more runs, out of time");
            throw new OutOfTimeException();
        }
        for (RunConfig rc : runConfigs) {
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime()};
            this.log.debug("Iteration {}: Scheduling run for config{} ({}) on instance {} with seed {} and captime {}", args);
        }
        List completedRuns = this.tae.evaluateRun(runConfigs);
        for (AlgorithmRun run : completedRuns) {
            RunConfig rc = run.getRunConfig();
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime(), run.getRunResult(), this.options.scenarioConfig.getRunObjective().getObjective(run), run.getWallclockExecutionTime()};
            this.log.debug("Iteration {}: Completed run for config{} ({}) on instance {} with seed {} and captime {} => Result: {}, response: {}, wallclock time: {} seconds", args);
        }
        this.updateRunHistory(completedRuns);
        return completedRuns;
    }

    public double getEmpericalPerformance(ParamConfiguration config) {
        HashSet<ProblemInstance> pis = new HashSet<ProblemInstance>();
        pis.addAll(this.instances);
        return this.runHistory.getEmpiricalCost(config, pis, this.cutoffTime);
    }

    public List<TrajectoryFileEntry> getTrajectoryFileEntries() {
        return Collections.unmodifiableList(this.tfes);
    }

    public synchronized String getTerminationReason() {
        if (this.terminationReason == null) {
            this.terminationReason = this.termCond.getTerminationReason();
        }
        return this.terminationReason;
    }

    private String getConfigurationString(ParamConfiguration config) {
        return this.runHistory.getThetaIdx(config) != -1 ? this.runHistory.getThetaIdx(config) + " (" + config.getFriendlyIDHex() + ")" : "(" + config.getFriendlyIDHex() + ")";
    }

    public synchronized RunHistory runHistory() {
        return this.runHistory;
    }

    public synchronized TerminationCondition getTerminationCondition() {
        return this.termCond;
    }
}

