/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum RunResult {
    TIMEOUT(false, 0, true, true),
    SAT(true, 1, true, false, "SAT", "SATISFIABLE", "SUCCESS"),
    UNSAT(true, 2, true, false, "UNSAT", "UNSATISFIABLE"),
    CRASHED(false, -1, true, false),
    ABORT(false, -2, true, false),
    RUNNING(false, Integer.MIN_VALUE, false, false),
    KILLED(false, -3, false, true);

    private final boolean decided;
    private final int resultCode;
    private final boolean permittedByWrappers;
    private final boolean successfulAndCensored;
    private final Set<String> resultKey = new HashSet<String>();

    private RunResult(boolean decided, int resultCode, boolean permittedByWrappers, boolean completeButCensored) {
        this.decided = decided;
        this.resultCode = resultCode;
        this.resultKey.add(this.toString());
        this.permittedByWrappers = permittedByWrappers;
        this.successfulAndCensored = completeButCensored;
    }

    private RunResult(boolean decided, int resultCode, boolean permittedByWrappers, boolean completeButCensored, String ... keys) {
        this.decided = decided;
        this.resultCode = resultCode;
        this.resultKey.addAll(Arrays.asList(keys));
        this.permittedByWrappers = permittedByWrappers;
        this.successfulAndCensored = completeButCensored;
    }

    public static RunResult getAutomaticConfiguratorResultForKey(String key) {
        key = key.toUpperCase();
        for (RunResult r : RunResult.values()) {
            if (!r.resultKey.contains(key)) continue;
            return r;
        }
        throw new IllegalArgumentException("No Match For Result from Automatic Configurator: " + key);
    }

    public static RunResult getAutomaticConfiguratorResultForCode(int resultCode) {
        for (RunResult r : RunResult.values()) {
            if (r.resultCode != resultCode) continue;
            return r;
        }
        throw new IllegalArgumentException("No Match For Result from Automatic Configurator");
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isSolved() {
        return this.resultCode == 1;
    }

    public boolean isDecided() {
        return this.decided;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.resultKey);
    }

    public boolean permittedByWrappers() {
        return this.permittedByWrappers;
    }

    public boolean isSuccessfulAndCensored() {
        return this.successfulAndCensored;
    }
}

