/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.eventsystem.events.ac;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.eventsystem.events.AbstractTimeEvent;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;

public class IncumbentPerformanceChangeEvent
extends AbstractTimeEvent {
    private final double acTime;
    private final ParamConfiguration incumbent;
    private final double empiricalPerformance;
    private final ParamConfiguration oldIncumbent;
    private final long runCount;

    public IncumbentPerformanceChangeEvent(double tunerTime, double walltime, double empiricalPerformance, ParamConfiguration incumbent, long runCount, ParamConfiguration oldIncumbent, CPUTime cpuTime) {
        super(tunerTime, walltime);
        this.empiricalPerformance = empiricalPerformance;
        this.incumbent = incumbent;
        this.acTime = cpuTime.getCPUTime();
        this.oldIncumbent = oldIncumbent;
        this.runCount = runCount;
    }

    public IncumbentPerformanceChangeEvent(TerminationCondition termCond, double empiricalPerformance, ParamConfiguration incumbent, long runCount, ParamConfiguration oldIncumbent, CPUTime cpuTime) {
        super(termCond);
        this.empiricalPerformance = empiricalPerformance;
        this.incumbent = incumbent;
        this.acTime = cpuTime.getCPUTime();
        this.oldIncumbent = oldIncumbent;
        this.runCount = runCount;
    }

    public double getAutomaticConfiguratorCPUTime() {
        return this.acTime;
    }

    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    public double getEmpiricalPerformance() {
        return this.empiricalPerformance;
    }

    public boolean incumbentChanged() {
        return !this.incumbent.equals(this.oldIncumbent);
    }

    public long getIncumbentRunCount() {
        return this.runCount;
    }
}

