/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.cputime;

import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CPUTimeCalculator {
    private static final Logger log = LoggerFactory.getLogger(CPUTime.class);
    private static final ConcurrentHashMap<Long, Long> threadToCPUTimeMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Long> threadToUserTimeMap = new ConcurrentHashMap();
    private static final AtomicLong cpuTime = new AtomicLong(0L);
    private static final AtomicLong userTime = new AtomicLong(0L);
    private static final ScheduledExecutorService execService = Executors.newScheduledThreadPool(1, new SequentiallyNamedThreadFactory("CPU Time Accumulator", true));
    private static final ThreadUpdater threadUpdate = new ThreadUpdater();
    private static final LinkedBlockingQueue<CountDownLatch> latches = new LinkedBlockingQueue();

    CPUTimeCalculator() {
    }

    static double _getCPUTime() {
        CountDownLatch latch = new CountDownLatch(1);
        boolean accepted = latches.offer(latch);
        execService.submit(threadUpdate);
        if (accepted) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        double value = (double)cpuTime.get() / 1000.0 / 1000.0 / 1000.0;
        return value;
    }

    static double _getUserTime() {
        CountDownLatch latch = new CountDownLatch(1);
        boolean accepted = latches.offer(latch);
        execService.submit(threadUpdate);
        if (accepted) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        double value = (double)userTime.get() / 1000.0 / 1000.0 / 1000.0;
        return value;
    }

    static {
        execService.scheduleAtFixedRate(threadUpdate, 500L, 1000L, TimeUnit.MILLISECONDS);
    }

    private static class ThreadUpdater
    implements Runnable {
        private ThreadUpdater() {
        }

        @Override
        public synchronized void run() {
            try {
                ThreadMXBean b = ManagementFactory.getThreadMXBean();
                try {
                    for (long threadID : b.getAllThreadIds()) {
                        long threadTime = b.getThreadCpuTime(threadID);
                        if (threadTime == -1L) {
                            log.trace("JVM didn't give us a measurement for thread: {}", (Object)threadID);
                            continue;
                        }
                        threadToCPUTimeMap.put(threadID, threadTime);
                        long threadUserTime = b.getThreadUserTime(threadID);
                        if (threadUserTime == -1L) {
                            log.trace("JVM didn't give us a measurement for usertime of thread: {}", (Object)threadID);
                            continue;
                        }
                        threadToUserTimeMap.put(threadID, threadTime);
                    }
                    long currentCPUTime = 0L;
                    for (Map.Entry values : threadToCPUTimeMap.entrySet()) {
                        currentCPUTime += ((Long)values.getValue()).longValue();
                    }
                    cpuTime.set(currentCPUTime);
                    long currentUserTime = 0L;
                    for (Map.Entry values : threadToCPUTimeMap.entrySet()) {
                        currentUserTime += ((Long)values.getValue()).longValue();
                    }
                    userTime.set(currentUserTime);
                }
                catch (UnsupportedOperationException e) {
                    log.debug("JVM does not support CPU Time measurements");
                    cpuTime.set(0L);
                    userTime.set(0L);
                }
                while (latches.peek() != null) {
                    ((CountDownLatch)latches.poll()).countDown();
                }
            }
            catch (RuntimeException e) {
                log.error("Exception in CPU Time Thread", (Throwable)e);
            }
        }
    }
}

