/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.version;

import ca.ubc.cs.beta.aclib.logging.CommonMarkers;
import ca.ubc.cs.beta.aclib.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionTracker {
    private static final Logger log = LoggerFactory.getLogger(VersionTracker.class);
    private static ClassLoader cl = SPIClassLoaderHelper.getClassLoader();

    private static SortedMap<String, String> init() {
        boolean errorPrinted = false;
        Iterator<VersionInfo> versionInfo = ServiceLoader.load(VersionInfo.class, cl).iterator();
        TreeMap<String, String> versionMap = new TreeMap<String, String>();
        while (versionInfo.hasNext()) {
            try {
                VersionInfo info = versionInfo.next();
                versionMap.put(info.getProductName(), info.getVersion());
            }
            catch (Exception e) {
                log.warn("Error occured while loading version Information", (Throwable)e);
                if (errorPrinted) continue;
                errorPrinted = true;
                System.err.println(SPIClassLoaderHelper.getDefaultSearchPath());
                System.err.println(VersionTracker.class.getClassLoader().getResource(VersionTracker.class.getCanonicalName().replaceAll("\\.", "/") + ".java"));
            }
        }
        return versionMap;
    }

    public static void main(String[] args) {
        VersionTracker.logVersions();
    }

    public static Map<String, String> getVersionMap() {
        return VersionTracker.init();
    }

    public static String getVersionInformation() {
        SortedMap<String, String> versionMap = VersionTracker.init();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> ent : versionMap.entrySet()) {
            sb.append(ent.getKey()).append(" ==> ").append(ent.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static void logVersions() {
        SortedMap<String, String> versionMap = VersionTracker.init();
        if (versionMap.isEmpty()) {
            log.warn("Unable to find ANY version information, if you made this JAR yourself chances are you did not setup SPI correctly. See the SMAC Manual Developer Reference for more information");
        }
        for (Map.Entry<String, String> ent : versionMap.entrySet()) {
            log.info(CommonMarkers.SKIP_CONSOLE_PRINTING, "Version of {} is {} ", (Object)ent.getKey(), (Object)ent.getValue());
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        cl = classLoader;
    }
}

