/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.runhistory;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runhistory.ReadWriteLockThreadTracker;
import ca.ubc.cs.beta.aclib.runhistory.RunData;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadSafeRunHistoryWrapper
implements ThreadSafeRunHistory {
    private final RunHistory runHistory;
    ReadWriteLockThreadTracker rwltt = new ReadWriteLockThreadTracker();

    public ThreadSafeRunHistoryWrapper(RunHistory runHistory) {
        this.runHistory = runHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Collection<AlgorithmRun> runs) throws DuplicateRunException {
        this.lockWrite();
        try {
            for (AlgorithmRun run : runs) {
                this.runHistory.append(run);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(AlgorithmRun run) throws DuplicateRunException {
        this.lockWrite();
        try {
            this.runHistory.append(run);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunObjective getRunObjective() {
        this.lockRead();
        try {
            RunObjective runObjective = this.runHistory.getRunObjective();
            return runObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverallObjective getOverallObjective() {
        this.lockRead();
        try {
            OverallObjective overallObjective = this.runHistory.getOverallObjective();
            return overallObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementIteration() {
        this.lockWrite();
        try {
            this.runHistory.incrementIteration();
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIteration() {
        this.lockRead();
        try {
            int n = this.runHistory.getIteration();
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getProblemInstancesRan(ParamConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getProblemInstancesRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getProblemInstanceSeedPairsRan(ParamConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getProblemInstanceSeedPairsRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, minimumResponseValue);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalRunCost() {
        this.lockRead();
        try {
            double d = this.runHistory.getTotalRunCost();
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getUniqueInstancesRan();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ParamConfiguration> getUniqueParamConfigurations() {
        this.lockRead();
        try {
            Set<ParamConfiguration> set = this.runHistory.getUniqueParamConfigurations();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] getParameterConfigurationInstancesRanByIndex() {
        this.lockRead();
        try {
            int[][] nArray = this.runHistory.getParameterConfigurationInstancesRanByIndex();
            return nArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ParamConfiguration> getAllParameterConfigurationsRan() {
        this.lockRead();
        try {
            List<ParamConfiguration> list = this.runHistory.getAllParameterConfigurationsRan();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        this.lockRead();
        try {
            double[][] dArray = this.runHistory.getAllConfigurationsRanInValueArrayForm();
            return dArray;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunData> getAlgorithmRunData() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunData();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ProblemInstanceSeedPair> getEarlyCensoredProblemInstanceSeedPairs(ParamConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThetaIdx(ParamConfiguration configuration) {
        this.lockRead();
        try {
            int n = this.runHistory.getThetaIdx(configuration);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParamConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void readLock() {
        this.lockRead();
    }

    @Override
    public void releaseReadLock() {
        this.unlockRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> getAlgorithmRunsExcludingRedundant(ParamConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRun> list = this.runHistory.getAlgorithmRunsExcludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigExcludingRedundant(ParamConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> getAlgorithmRunsExcludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRun> list = this.runHistory.getAlgorithmRunsExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> getAlgorithmRunsIncludingRedundant(ParamConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRun> list = this.runHistory.getAlgorithmRunsIncludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalNumRunsOfConfigIncludingRedundant(ParamConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigIncludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> getAlgorithmRunsIncludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRun> list = this.runHistory.getAlgorithmRunsIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParamConfiguration configuration) {
        this.lockRead();
        try {
            Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.runHistory.getPerformanceForConfig(configuration);
            return map;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        this.lockRead();
        try {
            List<Long> list = this.runHistory.getSeedsUsedByInstance(pi);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    public void lockRead() {
        this.rwltt.lockRead();
    }

    private void unlockRead() {
        this.rwltt.unlockRead();
    }

    private void lockWrite() {
        this.rwltt.lockWrite();
    }

    private void unlockWrite() {
        this.rwltt.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateThetaIdx(ParamConfiguration config) {
        this.lockWrite();
        try {
            int n = this.runHistory.getOrCreateThetaIdx(config);
            return n;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public double getEmpiricalCostLowerBound(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostLowerBound(config, instanceSet, cutoffTime);
    }

    @Override
    public double getEmpiricalCostUpperBound(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostUpperBound(config, instanceSet, cutoffTime);
    }
}

