/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CheckForDuplicateRunConfigDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean throwException;

    public CheckForDuplicateRunConfigDecorator(TargetAlgorithmEvaluator tae, boolean throwException) {
        super(tae);
        this.throwException = throwException;
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        this.checkRunConfigs(runConfigs);
        return this.tae.evaluateRun(runConfigs, obs);
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.checkRunConfigs(runConfigs);
        this.tae.evaluateRunsAsync(runConfigs, handler, obs);
    }

    public void checkRunConfigs(List<RunConfig> runConfigs) {
        HashSet<RunConfig> rcs = new HashSet<RunConfig>();
        rcs.addAll(runConfigs);
        if (rcs.size() != runConfigs.size()) {
            this.log.error("Duplicate Run Configurations Requested this is almost certainly a bug");
            this.log.error("Duplicate Run Configs Follow:");
            for (RunConfig rc : this.findDuplicates(runConfigs)) {
                this.log.error("\tDuplicate Run Config: {}", (Object)rc);
            }
            this.log.error("All Run Configs follow:");
            for (RunConfig rc : runConfigs) {
                this.log.error("\tRun Config: {} ", (Object)rc);
            }
            if (this.throwException) {
                throw new IllegalStateException("Duplicate Run Configurations cannot be part of the same call of evaluateRun()/evaluateRunAsync()");
            }
        }
    }

    private Set<RunConfig> findDuplicates(List<RunConfig> listContainingDuplicates) {
        HashSet<RunConfig> setToReturn = new HashSet<RunConfig>();
        HashSet<RunConfig> set1 = new HashSet<RunConfig>();
        for (RunConfig yourInt : listContainingDuplicates) {
            if (set1.add(yourInt)) continue;
            setToReturn.add(yourInt);
        }
        return setToReturn;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

