/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UncleanShutdownDetectingTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final AtomicLong notifyShutdownInvoked = new AtomicLong(0L);
    private static final int MESSAGE_REPEAT = 1;
    private static final int SLEEP_TIME_IN_MS = 0;
    private static final int SLEEP_TIME_BETWEEN_MESSAGES = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StackTraceElement[] taeCreationStackTrace = new Exception().getStackTrace();
    private static final Object stackTracePrintingLock = new Object();

    public UncleanShutdownDetectingTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("Unclean Target Algorithm Evaluator Shutdown Detector");
                long notifies = UncleanShutdownDetectingTargetAlgorithmEvaluator.this.notifyShutdownInvoked.get();
                if (notifies == 0L) {
                    UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.debug("Unclean Shutdown Detected, You must call notifyShutdown() on your TAE. You may have a broken TAE decorator that doesn't forward the notifyShutdown() correctly");
                    Object object = stackTracePrintingLock;
                    synchronized (object) {
                        if (UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.isDebugEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            for (StackTraceElement el : UncleanShutdownDetectingTargetAlgorithmEvaluator.this.taeCreationStackTrace) {
                                sb.append(el).append("\n");
                            }
                            UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.debug("Target algorithm that wasn't shutdown was created here:\n{}", (Object)sb);
                        }
                    }
                } else if (notifies > 1L) {
                    UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.warn("You called notifyShutdown() on your TAE more than once, this seems exceptionally weird");
                } else if (notifies < 0L) {
                    UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.warn("You seem to have overflowed the counter we use to track the number of calls to notifyShutdown(), well played...");
                } else {
                    return;
                }
            }
        }));
    }

    @Override
    public void postDecorateeNotifyShutdown() {
    }

    @Override
    public void preDecorateeNotifyShutdown() {
        this.notifyShutdownInvoked.incrementAndGet();
    }
}

