/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aclib.exceptions.TrajectoryDivergenceException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.logging.CommonMarkers;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aclib.misc.version.JavaVersionInfo;
import ca.ubc.cs.beta.aclib.misc.version.OSVersionInfo;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.SMACOptions;
import ca.ubc.cs.beta.aclib.state.StateFactoryOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFile;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.builder.SMACBuilder;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.misc.version.SMACVersionInfo;
import ca.ubc.cs.beta.smac.validation.Validator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SMACExecutor {
    private static Logger log;
    private static Marker exception;
    private static Marker stackTrace;
    private static String logLocation;
    private static InstanceListWithSeeds trainingILWS;
    private static InstanceListWithSeeds testingILWS;
    private static Map<String, AbstractOptions> taeOptions;
    private static SeedableRandomPool pool;
    private static String outputDir;
    private static String runGroupName;

    public static void main(String[] args) {
        int returnValue = SMACExecutor.oldMain(args);
        if (log != null) {
            log.debug("Returning with value: {}", (Object)returnValue);
        }
        System.exit(returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int oldMain(String[] args) {
        try {
            SortedMap<TrajectoryFileEntry, Double> performance;
            SMACOptions options = SMACExecutor.parseCLIOptions(args);
            SMACBuilder smacBuilder = new SMACBuilder();
            AlgorithmExecutionConfig execConfig = options.getAlgorithmExecutionConfig();
            AbstractAlgorithmFramework smac = smacBuilder.getAutomaticConfigurator(execConfig, trainingILWS, options, taeOptions, outputDir, pool);
            AutoStartStopWatch watch = new AutoStartStopWatch();
            smac.run();
            watch.stop();
            smacBuilder.getLogRuntimeStatistics().logLastRuntimeStatistics();
            pool.logUsage();
            ParamConfiguration incumbent = smac.getIncumbent();
            RunHistory runHistory = smac.runHistory();
            TerminationCondition tc = smac.getTerminationCondition();
            DecimalFormat df0 = new DecimalFormat("0");
            log.info("\n=======================================================================================\nSMAC has finished. Reason: {}\nSMAC's final incumbent: config {} (internal ID: {}), with estimated {}: {}, based on {} run(s) on {} training instance(s).\nTotal number of runs performed: {}, total CPU time used: {} s, total wallclock time used: {} s, total configurations tried: {}.\n=======================================================================================", new Object[]{smac.getTerminationReason(), runHistory.getThetaIdx(incumbent), incumbent, smac.getObjectiveToReport(), smac.getEmpericalPerformance(incumbent), runHistory.getAlgorithmRunsExcludingRedundant(incumbent).size(), runHistory.getProblemInstanceSeedPairsRan(incumbent).size(), runHistory.getAlgorithmRunsExcludingRedundant().size(), df0.format(tc.getTunerTime()), df0.format(tc.getWallTime()), runHistory.getAllParameterConfigurationsRan().size()});
            List tfes = smacBuilder.getTrajectoryFileLogger().getTrajectoryFileEntries();
            boolean bl = options.doValidation = options.validationOptions.numberOfValidationRuns > 0 ? options.doValidation : false;
            if (options.doValidation) {
                log.info("Now starting offline validation.");
                if (options.validationOptions.maxTimestamp == -1.0) {
                    options.validationOptions.maxTimestamp = options.validationOptions.useWallClockTime ? (options.scenarioConfig.limitOptions.runtimeLimit < Integer.MAX_VALUE ? (double)options.scenarioConfig.limitOptions.runtimeLimit : (double)watch.time() / 1000.0) : (double)options.scenarioConfig.limitOptions.tunerTimeout;
                }
                options.scenarioConfig.algoExecOptions.taeOpts.turnOffCrashes();
                int coreHint = 1;
                if (options.validationCores != null && options.validationCores > 0) {
                    log.debug("Validation will use {} cores", (Object)options.validationCores);
                    options.scenarioConfig.algoExecOptions.taeOpts.maxConcurrentAlgoExecs = options.validationCores;
                    ((CommandLineTargetAlgorithmEvaluatorOptions)SMACExecutor.taeOptions.get((Object)CommandLineTargetAlgorithmEvaluatorFactory.NAME)).cores = options.validationCores;
                    coreHint = options.validationCores;
                }
                TargetAlgorithmEvaluator validatingTae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((TargetAlgorithmEvaluatorOptions)options.scenarioConfig.algoExecOptions.taeOpts, (AlgorithmExecutionConfig)execConfig, (boolean)false, taeOptions);
                try {
                    List testInstances = testingILWS.getInstances();
                    InstanceSeedGenerator testInstanceSeedGen = testingILWS.getSeedGen();
                    TrajectoryFile trajFile = new TrajectoryFile(new File(outputDir + File.separator + "traj-run-" + options.seedOptions.numRun + ".txt"), tfes);
                    performance = new Validator().simpleValidate(testInstances, options.validationOptions, options.scenarioConfig.algoExecOptions.cutoffTime, testInstanceSeedGen, validatingTae, outputDir, options.scenarioConfig.getRunObjective(), options.scenarioConfig.getIntraInstanceObjective(), options.scenarioConfig.interInstanceObj, trajFile, true, coreHint, execConfig);
                }
                finally {
                    validatingTae.notifyShutdown();
                }
            } else {
                performance = new TreeMap<TrajectoryFileEntry, Double>();
                performance.put((TrajectoryFileEntry)tfes.get(tfes.size() - 1), Double.POSITIVE_INFINITY);
            }
            String incumbentPerformance = smac.logIncumbentPerformance(performance);
            String callString = smac.logSMACResult(performance);
            smacBuilder.getEventManager().shutdown();
            log.info("\n----------------------------------------------------------------------------------------------------------------------------------------------------------------------------\nMinimized {}{}:\n{}\n{}\nAdditional information about run {} in: {}\n----------------------------------------------------------------------------------------------------------------------------------------------------------------------------", new Object[]{smac.getObjectiveToReport(), performance.size() > 1 ? " over time" : "", incumbentPerformance, callString, options.seedOptions.numRun, outputDir});
            return 0;
        }
        catch (Throwable t) {
            System.out.flush();
            System.err.flush();
            System.err.println("Error occurred while running SMAC\n>Error Message:" + t.getMessage() + "\n>Encountered Exception:" + t.getClass().getSimpleName() + "\n>Error Log Location: " + logLocation);
            System.err.flush();
            if (log != null) {
                log.error(exception, "Message: {}", (Object)t.getMessage());
                if (t instanceof ParameterException) {
                    log.info("Note that some options are read from files in ~/.aeatk/");
                    log.debug("Exception stack trace", t);
                } else if (t instanceof TargetAlgorithmAbortException) {
                    log.error(CommonMarkers.SKIP_CONSOLE_PRINTING, "A serious problem occured during target algorithm execution and we are aborting execution ", t);
                    log.error("We tried to call the target algorithm wrapper, but this call failed.");
                    log.error("The problem is (most likely) somewhere in the wrapper or with the arguments to SMAC.");
                    log.error("The easiest way to debug this problem is to manually execute the call we tried and see why it did not return the correct result");
                    log.error("The required output of the wrapper is something like \"Result for ParamILS: x,x,x,x,x\".);");
                } else {
                    log.info("Maybe try running in DEBUG mode if you are missing information");
                    log.error(exception, "Exception:{}", (Object)t.getClass().getCanonicalName());
                    StringWriter sWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(sWriter);
                    t.printStackTrace(writer);
                    log.error(stackTrace, "StackTrace:{}", (Object)sWriter.toString());
                }
                log.info("Exiting SMAC with failure. Log: " + logLocation);
                log.info("For a list of available commands use:  --help");
                log.info("The Quickstart guide at available at: http://www.cs.ubc.ca/labs/beta/Projects/SMAC/ or alternatively (doc/quickstart.html) gives simple examples for getting up and running.");
                log.info("The FAQ (doc/faq.pdf) contains commonly asked questions regarding troubleshooting, and usage.");
                log.info("The Manual (doc/manual.pdf) contains detailed information on file format semantics.");
                log.info("If you are stuck, please ask a question in the SMAC forum: https://groups.google.com/forum/#!forum/smac-forum");
                t = t.getCause();
            } else if (t instanceof ParameterException) {
                System.err.println(t.getMessage());
                t.printStackTrace();
            } else {
                t.printStackTrace();
            }
            if (t instanceof ParameterException) {
                return 1;
            }
            if (t instanceof StateSerializationException) {
                return 3;
            }
            if (t instanceof TrajectoryDivergenceException) {
                return 2;
            }
            return 255;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SMACOptions parseCLIOptions(String[] args) throws ParameterException, IOException {
        SMACOptions options = new SMACOptions();
        taeOptions = options.scenarioConfig.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        JCommander jcom = JCommanderHelper.getJCommanderAndCheckForHelp((String[])args, (AbstractOptions)options, taeOptions);
        jcom.setProgramName("smac");
        try {
            block31: {
                try {
                    File outputDirFile;
                    try {
                        args = SMACExecutor.processScenarioStateRestore(args);
                        jcom.parse(args);
                    }
                    finally {
                        runGroupName = options.runGroupOptions.getFailbackRunGroup();
                    }
                    if (options.adaptiveCapping == null) {
                        switch (options.scenarioConfig.getRunObjective()) {
                            case RUNTIME: {
                                options.adaptiveCapping = true;
                                break;
                            }
                            case QUALITY: {
                                options.adaptiveCapping = false;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Not sure what to default too");
                            }
                        }
                    }
                    if (options.randomForestOptions.logModel == null) {
                        switch (options.scenarioConfig.getRunObjective()) {
                            case RUNTIME: {
                                options.randomForestOptions.logModel = true;
                                break;
                            }
                            case QUALITY: {
                                options.randomForestOptions.logModel = false;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unsure what to do with new run objective");
                            }
                        }
                    }
                    if ((outputDirFile = new File(outputDir = options.getOutputDirectory(runGroupName = options.getRunGroupName(taeOptions.values())))).exists()) break block31;
                    outputDirFile.mkdirs();
                    if (outputDirFile.exists()) break block31;
                    throw new ParameterException("Could not create all folders necessary for output directory: " + outputDir);
                }
                catch (Throwable throwable) {
                    options.logOptions.initializeLogging(outputDir, options.seedOptions.numRun);
                    logLocation = options.logOptions.getLogLocation(outputDir, options.seedOptions.numRun);
                    log = LoggerFactory.getLogger(SMACExecutor.class);
                    exception = MarkerFactory.getMarker((String)"EXCEPTION");
                    stackTrace = MarkerFactory.getMarker((String)"STACKTRACE");
                    VersionTracker.setClassLoader((ClassLoader)SPIClassLoaderHelper.getClassLoader());
                    VersionTracker.logVersions();
                    SMACVersionInfo s = new SMACVersionInfo();
                    JavaVersionInfo j = new JavaVersionInfo();
                    OSVersionInfo o = new OSVersionInfo();
                    log.info(CommonMarkers.SKIP_FILE_PRINTING, "Version of {} is {}, running on {} and {} ", new Object[]{s.getProductName(), s.getVersion(), j.getVersion(), o.getVersion()});
                    for (String name : jcom.getParameterFilesToRead()) {
                        log.debug("Parsing (default) options from file: {} ", (Object)name);
                    }
                    throw throwable;
                }
            }
            options.logOptions.initializeLogging(outputDir, options.seedOptions.numRun);
            logLocation = options.logOptions.getLogLocation(outputDir, options.seedOptions.numRun);
            log = LoggerFactory.getLogger(SMACExecutor.class);
            exception = MarkerFactory.getMarker((String)"EXCEPTION");
            stackTrace = MarkerFactory.getMarker((String)"STACKTRACE");
            VersionTracker.setClassLoader((ClassLoader)SPIClassLoaderHelper.getClassLoader());
            VersionTracker.logVersions();
            SMACVersionInfo s = new SMACVersionInfo();
            JavaVersionInfo j = new JavaVersionInfo();
            OSVersionInfo o = new OSVersionInfo();
            log.info(CommonMarkers.SKIP_FILE_PRINTING, "Version of {} is {}, running on {} and {} ", new Object[]{s.getProductName(), s.getVersion(), j.getVersion(), o.getVersion()});
            for (String string : jcom.getParameterFilesToRead()) {
                log.debug("Parsing (default) options from file: {} ", (Object)string);
            }
            JCommanderHelper.logCallString((String[])args, (String)"smac");
            if (log.isDebugEnabled()) {
                TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
                StringBuilder sb = new StringBuilder();
                for (String envName : env.keySet()) {
                    sb.append(envName).append("=").append((String)env.get(envName)).append("\n");
                }
                log.debug("==========Enviroment Variables===========\n{}", (Object)sb.toString());
                TreeMap<Object, Object> props = new TreeMap<Object, Object>(System.getProperties());
                sb = new StringBuilder();
                for (Map.Entry entry : props.entrySet()) {
                    sb.append(entry.getKey().toString()).append("=").append(entry.getValue().toString()).append("\n");
                }
                String hostname = "[UNABLE TO DETERMINE HOSTNAME]";
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                log.debug("Hostname:{}", (Object)hostname);
                log.debug("==========System Properties==============\n{}", (Object)sb.toString());
            }
            JCommanderHelper.logConfiguration((JCommander)jcom);
            pool = options.seedOptions.getSeedableRandomPool();
            ProblemInstanceOptions.TrainTestInstances tti = options.getTrainingAndTestProblemInstances(pool, new SeedableRandomPool(options.validationSeed + options.seedOptions.seedOffset, pool.getInitialSeeds()));
            trainingILWS = tti.getTrainingInstances();
            testingILWS = tti.getTestInstances();
            try {
                if (ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled()) {
                    log.trace("JVM Supports CPU Timing Measurements");
                } else {
                    log.warn("This Java Virtual Machine has CPU Time Measurements disabled, tunerTimeout will not contain any SMAC Execution Time.");
                }
            }
            catch (UnsupportedOperationException e) {
                log.warn("This Java Virtual Machine does not support CPU Time Measurements, tunerTimeout will not contain any SMAC Execution Time Information (http://docs.oracle.com/javase/1.5.0/docs/api/java/lang/management/ThreadMXBean.html#setThreadCpuTimeEnabled(boolean))");
            }
            if (options.seedOptions.numRun + options.seedOptions.seedOffset < 0) {
                log.warn("NumRun {} plus Seed Offset {} should be positive, things may not seed correctly", (Object)options.seedOptions.numRun, (Object)options.seedOptions.seedOffset);
            }
            return options;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParameterException e) {
            throw e;
        }
    }

    private static String[] processScenarioStateRestore(String[] args) {
        return StateFactoryOptions.processScenarioStateRestore((String[])args);
    }

    static {
        logLocation = "<NO LOG LOCATION SPECIFIED, FAILURE MUST HAVE OCCURED EARLY>";
        runGroupName = "DEFAULT";
    }
}

