/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.example.statemerge;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.example.statemerge.StateMergeModelBuilder;
import ca.ubc.cs.beta.aclib.example.statemerge.StateMergeOptions;
import ca.ubc.cs.beta.aclib.exceptions.DeveloperMadeABooBooException;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.MapList;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.string.SplitQuotedString;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ReindexSeedRunHistoryDecorator;
import ca.ubc.cs.beta.aclib.runhistory.RunData;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aclib.state.StateFactoryOptions;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMergeExecutor {
    private static Logger log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StateMergeOptions smo = new StateMergeOptions();
        try {
            ThreadSafeRunHistoryWrapper rhToSaveToDisk;
            JCommander jcom;
            try {
                jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, smo);
            }
            finally {
                smo.logOpts.initializeLogging();
                log = LoggerFactory.getLogger(StateMergeExecutor.class);
                VersionTracker.logVersions();
            }
            for (String file : jcom.getParameterFilesToRead()) {
                log.debug("Reading options from default file {} ", (Object)file);
            }
            log.info("Starting State Merge");
            log.debug("Determining Scenario Options");
            List<ProblemInstance> pis = smo.scenOpts.getTrainingAndTestProblemInstances(smo.experimentDir, 0L, 0L, true, false, false, false).getTrainingInstances().getInstances();
            AlgorithmExecutionConfig execConfig = smo.scenOpts.getAlgorithmExecutionConfigSkipExecDirCheck(smo.experimentDir);
            MapList<Integer, AlgorithmRun> runsPerIteration = new MapList<Integer, AlgorithmRun>(new LinkedHashMap());
            smo.replaceSeeds = execConfig.isDeterministicAlgorithm() ? Boolean.valueOf(false) : Boolean.valueOf(true);
            log.debug("Scanning directories");
            Set<String> directoriesWithState = StateMergeExecutor.getAllRestoreDirectories(smo.directories);
            for (String dir : directoriesWithState) {
                StateMergeExecutor.extractRunsFromDirectory(smo, pis, execConfig, runsPerIteration, dir);
            }
            LinkedHashMap<String, ProblemInstance> fixedPi = new LinkedHashMap<String, ProblemInstance>();
            MapList<Integer, AlgorithmRun> repairedRuns = StateMergeExecutor.repairProblemInstances(runsPerIteration, fixedPi, pis);
            MersenneTwister r = new MersenneTwister(smo.seed);
            log.debug("Processing Runs");
            RunHistory rh = new NewRunHistory(smo.scenOpts.getIntraInstanceObjective(), smo.scenOpts.interInstanceObj, smo.scenOpts.getRunObjective());
            if (smo.replaceSeeds.booleanValue()) {
                rh = new ReindexSeedRunHistoryDecorator(rh, r);
            }
            ThreadSafeRunHistoryWrapper rhToFilter = new ThreadSafeRunHistoryWrapper(rh);
            for (Map.Entry<Integer, List<AlgorithmRun>> itToRun : repairedRuns.entrySet()) {
                for (AlgorithmRun run : itToRun.getValue()) {
                    try {
                        rhToFilter.append(run);
                    }
                    catch (DuplicateRunException e) {
                        e.printStackTrace();
                    }
                }
                rhToFilter.incrementIteration();
            }
            int rdi = 0;
            for (RunData rd : rhToFilter.getAlgorithmRunData()) {
                ++rdi;
                log.trace("Restored Data Iteration {} => {} ", (Object)rd.getIteration(), (Object)rd.getRun());
            }
            log.debug("Restored Runs Count {} ", (Object)rdi);
            ParamConfiguration newIncumbent = null;
            if (smo.repairMaxRunsForIncumbentInvariant) {
                List<ParamConfiguration> configs = rhToFilter.getAllParameterConfigurationsRan();
                HashSet<ProblemInstanceSeedPair> allPisps = new HashSet<ProblemInstanceSeedPair>();
                Object maxConfig = null;
                HashSet<ParamConfiguration> maxConfigs = new HashSet<ParamConfiguration>();
                int maxSetSize = 0;
                for (ParamConfiguration config : configs) {
                    log.debug("Number of runs for configuration {} is {}", (Object)config, (Object)rhToFilter.getProblemInstanceSeedPairsRan(config).size());
                    allPisps.addAll(rhToFilter.getProblemInstanceSeedPairsRan(config));
                    if (maxSetSize < rhToFilter.getProblemInstanceSeedPairsRan(config).size()) {
                        maxConfigs.clear();
                        maxConfigs.add(config);
                        maxSetSize = rhToFilter.getProblemInstanceSeedPairsRan(config).size();
                        continue;
                    }
                    if (maxSetSize != rhToFilter.getProblemInstanceSeedPairsRan(config).size()) continue;
                    maxConfigs.add(config);
                }
                log.debug("Number of possible incumbents are {}", (Object)maxConfigs.size());
                StateMergeModelBuilder smmb = new StateMergeModelBuilder();
                ArrayList<ProblemInstance> instances = new ArrayList<ProblemInstance>();
                instances.addAll(fixedPi.values());
                SeedableRandomPool srp = new SeedableRandomPool(1);
                log.debug("Building model");
                boolean adaptiveCapping = true;
                if (smo.rfo.logModel == null) {
                    if (smo.scenOpts.getRunObjective().equals((Object)RunObjective.RUNTIME)) {
                        smo.rfo.logModel = true;
                    } else {
                        smo.rfo.logModel = false;
                        adaptiveCapping = false;
                    }
                }
                smmb.learnModel(instances, rhToFilter, execConfig.getParamFile(), smo.rfo, smo.mbo, smo.scenOpts, adaptiveCapping, srp);
                RandomForest rf = smmb.getPreparedForest();
                int[] tree_indxs_used = new int[10];
                for (int i = 0; i < smo.rfo.numTrees; ++i) {
                    tree_indxs_used[i] = i;
                }
                double[][] Theta = new double[1][];
                double bestMean = Double.POSITIVE_INFINITY;
                for (ParamConfiguration config : maxConfigs) {
                    Theta[0] = config.toValueArray();
                    double[][] ypred = RandomForest.applyMarginal((RandomForest)rf, (int[])tree_indxs_used, (double[][])Theta);
                    log.trace("Incumbent {} has predicted mean {}", (Object)config, (Object)ypred[0]);
                    if (!(ypred[0][0] < bestMean)) continue;
                    newIncumbent = config;
                    bestMean = ypred[0][0];
                }
                log.info("New incumbent selected from random forest prediction is {} with string \"{}\" ", (Object)newIncumbent, (Object)newIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
                HashSet<ProblemInstanceSeedPair> maxSet = new HashSet<ProblemInstanceSeedPair>();
                maxSet.addAll(rhToFilter.getProblemInstanceSeedPairsRan(newIncumbent));
                rhToSaveToDisk = new ThreadSafeRunHistoryWrapper(new NewRunHistory(smo.scenOpts.getIntraInstanceObjective(), smo.scenOpts.interInstanceObj, smo.scenOpts.getRunObjective()));
                for (RunData rd : rhToFilter.getAlgorithmRunData()) {
                    while (rd.getIteration() > rhToSaveToDisk.getIteration()) {
                        rhToSaveToDisk.incrementIteration();
                    }
                    if (maxSet.contains(rd.getRun().getRunConfig().getProblemInstanceSeedPair())) {
                        try {
                            rhToSaveToDisk.append(rd.getRun());
                            continue;
                        }
                        catch (DuplicateRunException e) {
                            throw new DeveloperMadeABooBooException("All the runs are coming from a run history object so this really shouldn't happen");
                        }
                    }
                    log.trace("No match for pisp {}", (Object)rd.getRun().getRunConfig().getProblemInstanceSeedPair());
                }
            } else {
                rhToSaveToDisk = rhToFilter;
            }
            int originalRestored = rdi;
            rdi = 0;
            for (RunData rd : rhToSaveToDisk.getAlgorithmRunData()) {
                ++rdi;
                log.trace("Will Save Run Iteration {} => {} ", (Object)rd.getIteration(), (Object)rd.getRun());
            }
            log.debug("Restored Runs Count {} out of {} runs found  ", (Object)rdi, (Object)originalRestored);
            ArrayList<ProblemInstance> pisToSave = new ArrayList<ProblemInstance>();
            for (Map.Entry ent : fixedPi.entrySet()) {
                log.debug("Problem instance saving {}", ent.getValue());
                pisToSave.add((ProblemInstance)ent.getValue());
            }
            StateMergeExecutor.saveState(smo.scenOpts.outputDirectory, rhToSaveToDisk, pisToSave, execConfig.getParamFile().getParamFileName(), execConfig, smo.scenOpts, newIncumbent);
            log.info("State Merge completed successfully");
        }
        catch (ParameterException e) {
            log.info("Error {}", (Object)e.getMessage());
            log.trace("Exception ", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error("Unknown Runtime Exception ", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO Exception occurred", (Throwable)e);
        }
    }

    private static MapList<Integer, AlgorithmRun> repairProblemInstances(MapList<Integer, AlgorithmRun> runsPerIteration, Map<String, ProblemInstance> fixedPi, List<ProblemInstance> pis) {
        ProblemInstance pi;
        MapList<Integer, AlgorithmRun> repairedRuns = new MapList<Integer, AlgorithmRun>(new HashMap());
        int instanceId = 1;
        HashSet<String> featureKeys = new HashSet<String>();
        ProblemInstance firstPi = null;
        HashMap<Integer, String> piIDMap = new HashMap<Integer, String>();
        boolean idcollision = false;
        block0: for (Map.Entry<Integer, List<AlgorithmRun>> runsForIt : runsPerIteration.entrySet()) {
            for (AlgorithmRun run : runsForIt.getValue()) {
                pi = run.getRunConfig().getProblemInstanceSeedPair().getInstance();
                if (piIDMap.containsKey(pi.getInstanceID())) {
                    if (((String)piIDMap.get(pi.getInstanceID())).equals(pi.getInstanceName())) continue;
                    idcollision = true;
                    log.debug("Problem Instance ID collision detected, this generally means you are merging run history files over different instance distributions. This is OK but note that instance IDs need to be changed, and so you cannot use this runhistory file to warm start a SMAC run.");
                    log.trace("Instance ID: {} previously mapped to: {} but now maps to: {}", new Object[]{pi.getInstanceID(), piIDMap.get(pi.getInstanceID()), pi.getInstanceName()});
                    fixedPi.clear();
                    break block0;
                }
                piIDMap.put(pi.getInstanceID(), pi.getInstanceName());
                fixedPi.put(pi.getInstanceName(), pi);
            }
        }
        if (!idcollision) {
            log.debug("Problem IDs seem to come from one distribution, this state-merge file should be compatible with warm-starts.");
            if (piIDMap.size() != pis.size()) {
                for (ProblemInstance pi2 : pis) {
                    if (piIDMap.containsKey(pi2.getInstanceID())) continue;
                    fixedPi.put(pi2.getInstanceName(), pi2);
                }
            }
        }
        for (Map.Entry<Integer, List<AlgorithmRun>> runsForIt : runsPerIteration.entrySet()) {
            for (AlgorithmRun run : runsForIt.getValue()) {
                ProblemInstance repairedPi;
                pi = run.getRunConfig().getProblemInstanceSeedPair().getInstance();
                if (fixedPi.containsKey(pi.getInstanceName())) {
                    repairedPi = fixedPi.get(pi.getInstanceName());
                } else {
                    repairedPi = new ProblemInstance(pi.getInstanceName(), instanceId, pi.getFeatures(), pi.getInstanceSpecificInformation());
                    log.trace("Original problem instance {} has ID transformed from {} to {}", (Object)pi.getInstanceID(), (Object)instanceId);
                    fixedPi.put(pi.getInstanceName(), repairedPi);
                    if (featureKeys.isEmpty()) {
                        featureKeys.addAll(pi.getFeatures().keySet());
                        firstPi = pi;
                    } else if (!((Object)featureKeys).equals(pi.getFeatures().keySet())) {
                        String prevMinusCurr = "";
                        HashSet previousFeatures = new HashSet(featureKeys);
                        HashSet<String> currentFeatures = new HashSet<String>(pi.getFeatures().keySet());
                        previousFeatures.removeAll(currentFeatures);
                        prevMinusCurr = ((Object)previousFeatures).toString();
                        String currMinusPrev = "";
                        HashSet previousFeatures2 = new HashSet(featureKeys);
                        HashSet<String> currentFeatures2 = new HashSet<String>(pi.getFeatures().keySet());
                        currentFeatures2.removeAll(previousFeatures2);
                        currMinusPrev = ((Object)currentFeatures2).toString();
                        throw new ParameterException("Feature mismatch exception, features the current instance " + pi.getInstanceName() + " has but we previously on instance " + firstPi.getInstanceName() + "  didn't find: " + currMinusPrev + " . Features the previous instance has but current instance doesn't: " + prevMinusCurr);
                    }
                    ++instanceId;
                }
                ProblemInstanceSeedPair newPisp = new ProblemInstanceSeedPair(repairedPi, run.getRunConfig().getProblemInstanceSeedPair().getSeed());
                RunConfig rc = new RunConfig(newPisp, run.getRunConfig().getCutoffTime(), run.getRunConfig().getParamConfiguration());
                ExistingAlgorithmRun repairedRun = new ExistingAlgorithmRun(run.getExecutionConfig(), rc, run.getRunResult(), run.getRuntime(), run.getRunLength(), run.getQuality(), run.getResultSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
                Object[] args2 = new Object[]{runsForIt.getKey(), run.getRunConfig().getProblemInstanceSeedPair().getInstance(), run, repairedPi, repairedRun};
                log.trace("Run Restored on iteration {} : {} => {} repaired: {} => {}", args2);
                repairedRuns.addToList(runsForIt.getKey(), repairedRun);
            }
        }
        return repairedRuns;
    }

    private static void extractRunsFromDirectory(StateMergeOptions smo, List<ProblemInstance> pis, AlgorithmExecutionConfig execConfig, MapList<Integer, AlgorithmRun> runsPerIteration, String dir) throws IOException {
        ThreadSafeRunHistoryWrapper rh = new ThreadSafeRunHistoryWrapper(new NewRunHistory(smo.scenOpts.getIntraInstanceObjective(), smo.scenOpts.interInstanceObj, smo.scenOpts.getRunObjective()));
        StateMergeExecutor.restoreState(dir, smo.scenOpts, pis, execConfig, rh, smo.restoreScenarioArguments);
        log.trace("Restored state of {} has {} runs for default configuration ", (Object)dir, (Object)rh.getTotalNumRunsOfConfigExcludingRedundant(execConfig.getParamFile().getDefaultConfiguration()));
        double restoredRuntime = 0.0;
        for (RunData rd : rh.getAlgorithmRunData()) {
            restoredRuntime += rd.getRun().getRuntime();
            if (rd.getIteration() > smo.iterationLimit) break;
            runsPerIteration.addToList(rd.getIteration(), rd.getRun());
            if (!(restoredRuntime > (double)smo.tunerTime)) continue;
            break;
        }
    }

    private static Set<String> getAllRestoreDirectories(List<String> directories) {
        HashSet<String> directoriesWithState = new HashSet<String>();
        log.debug("Beginning Directory Scan");
        for (String dir : directories) {
            directoriesWithState.addAll(StateMergeExecutor.scanDirectories(dir));
        }
        return directoriesWithState;
    }

    private static void saveState(String dir, ThreadSafeRunHistory rh, List<ProblemInstance> pis, String configSpaceFileName, AlgorithmExecutionConfig execConfig, ScenarioOptions scenOpts, ParamConfiguration newIncumbent) throws IOException {
        log.trace("Saving directory {}", (Object)dir);
        LegacyStateFactory lsf = new LegacyStateFactory(dir, null);
        StateSerializer ss = lsf.getStateSerializer("it", rh.getIteration());
        ss.setRunHistory(rh);
        StringBuilder scen = new StringBuilder();
        scen.append("# Automatically generated by State Merge Utility").append("\n");
        scen.append("algo=" + scenOpts.algoExecOptions.algoExec).append("\n");
        scen.append("execdir=" + scenOpts.algoExecOptions.algoExecDir).append("\n");
        scen.append("deterministic=" + scenOpts.algoExecOptions.deterministic).append("\n");
        scen.append("run_obj=" + scenOpts.getRunObjective().toString().toLowerCase()).append("\n");
        scen.append("#outdir = (Outdir is not recommended in a scenario file anymore)").append("\n");
        scen.append("overall_obj=" + scenOpts.getIntraInstanceObjective().toString().toLowerCase()).append("\n");
        scen.append("cutoff_time=" + execConfig.getAlgorithmCutoffTime()).append("\n");
        scen.append("tunerTimeout=" + scenOpts.limitOptions.tunerTimeout).append("\n");
        scen.append("paramfile=param.pcs").append("\n");
        scen.append("instance_file=instances.txt").append("\n");
        if (pis.get(0).getFeatures().size() > 0) {
            scen.append("feature_file=instance-features.csv").append("\n");
        }
        lsf.copyFileToStateDir("scenario.txt", new ReaderInputStream((Reader)new StringReader(scen.toString()), "UTF-8"));
        if (pis.get(0).getFeatures().size() > 0) {
            StringBuilder features = new StringBuilder();
            features.append(",");
            for (String key : pis.get(0).getFeatures().keySet()) {
                features.append(key).append(",");
            }
            features.setCharAt(features.length() - 1, '\n');
            for (ProblemInstance pi : pis) {
                features.append(pi.getInstanceName()).append(",");
                for (Map.Entry<String, Double> ent : pi.getFeatures().entrySet()) {
                    features.append(ent.getValue()).append(",");
                }
                features.setCharAt(features.length() - 1, '\n');
            }
            lsf.copyFileToStateDir("instance-features.csv", new ReaderInputStream((Reader)new StringReader(features.toString()), "UTF-8"));
        }
        StringBuilder piTxt = new StringBuilder();
        for (ProblemInstance pi : pis) {
            piTxt.append(pi.getInstanceName()).append("\n");
        }
        lsf.copyFileToStateDir("instances.txt", new ReaderInputStream((Reader)new StringReader(piTxt.toString()), "UTF-8"));
        lsf.copyFileToStateDir("param.pcs", new File(configSpaceFileName));
        ss.setIncumbent(newIncumbent);
        ss.save();
    }

    private static void restoreState(String dir, ScenarioOptions scenOpts, List<ProblemInstance> pis, AlgorithmExecutionConfig execConfig, ThreadSafeRunHistory rh, String restoreScenarioOptions) throws IOException {
        StateFactoryOptions sfo = new StateFactoryOptions();
        log.trace("Restoring directory {}", (Object)dir);
        LegacyStateFactory lsf = new LegacyStateFactory(null, dir);
        for (File f : new File(dir).listFiles()) {
            if (!f.getName().equals("scenario.txt")) continue;
            log.trace("Using built in scenario options for directory {}", (Object)dir);
            scenOpts = new ScenarioOptions();
            JCommander jcom = new JCommander((Object)scenOpts);
            ArrayList<String> args = new ArrayList<String>();
            args.add("--scenario-file");
            args.add(f.getAbsolutePath());
            if (new File(dir + File.separator + "instances.txt").exists()) {
                args.add("--instance-file");
                args.add(dir + File.separator + "instances.txt");
            }
            if (new File(dir + File.separator + "instance-features.csv").exists()) {
                args.add("--feature-file");
                args.add(dir + File.separator + "instance-features.csv");
            } else if (new File(dir + File.separator + "instance-features.txt").exists()) {
                args.add("--feature-file");
                args.add(dir + File.separator + "instance-features.txt");
            }
            args.addAll(Arrays.asList(SplitQuotedString.splitQuotedString(restoreScenarioOptions)));
            jcom.parse(args.toArray(new String[0]));
            pis = scenOpts.getTrainingAndTestProblemInstances(dir, 0L, 0L, true, false, false, false).getTrainingInstances().getInstances();
        }
        lsf.getStateDeserializer("it", Integer.MAX_VALUE, execConfig.getParamFile(), pis, execConfig, rh);
    }

    private static Set<String> scanDirectories(String dirStr) {
        File dir = new File(dirStr).getAbsoluteFile();
        log.trace("Scanning directory {}", (Object)dir.getAbsolutePath());
        if (!dir.exists()) {
            throw new ParameterException("Argument " + dir.getAbsolutePath() + " does not exist");
        }
        if (!dir.canRead()) {
            throw new ParameterException("Argument " + dir.getAbsolutePath() + " cannot be read");
        }
        if (!dir.isDirectory()) {
            throw new ParameterException("Argument " + dir.getAbsolutePath() + " is not a directory");
        }
        Set<String> sd = StateMergeExecutor.scanDirectories(dir, new HashSet<String>());
        if (sd.isEmpty()) {
            throw new ParameterException("Couldn't find any state files in " + dir.getAbsolutePath());
        }
        return sd;
    }

    private static Set<String> scanDirectories(File dir, Set<String> absPathSearched) {
        if (absPathSearched.contains(dir.getAbsolutePath())) {
            return Collections.emptySet();
        }
        absPathSearched.add(dir.getAbsolutePath());
        String s2 = LegacyStateFactory.getRunAndResultsFilename("", "(-it\\d+|)", "", "");
        HashSet<String> matchingDirectories = new HashSet<String>();
        for (String s : dir.list()) {
            if (!s.matches(s2)) continue;
            log.trace("Directory contains saved SMAC data {}", (Object)dir);
            matchingDirectories.add(dir.getAbsolutePath());
        }
        if (!matchingDirectories.isEmpty()) {
            return matchingDirectories;
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory() || !f.canRead()) continue;
            matchingDirectories.addAll(StateMergeExecutor.scanDirectories(f, absPathSearched));
        }
        return matchingDirectories;
    }
}

