/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.options.scenario;

import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionOptions;
import ca.ubc.cs.beta.aclib.misc.jcommander.converter.OverallObjectiveConverter;
import ca.ubc.cs.beta.aclib.misc.jcommander.converter.RunObjectiveConverter;
import ca.ubc.cs.beta.aclib.misc.options.CommandLineOnly;
import ca.ubc.cs.beta.aclib.misc.options.OptionLevel;
import ca.ubc.cs.beta.aclib.misc.options.UsageTextField;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aclib.termination.TerminationCriteriaOptions;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParameterFile;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;

@UsageTextField(title="Scenario Options", description="Standard Scenario Options for use with SMAC. In general consider using the --scenarioFile directive to specify these parameters and Algorithm Execution Options")
public class ScenarioOptions
extends AbstractOptions {
    @CommandLineOnly
    @Parameter(names={"--run-obj", "--run-objective", "--runObj", "--run_obj"}, description="per target algorithm run objective type that we are minimizing", converter=RunObjectiveConverter.class)
    public RunObjective _runObj = null;
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE, defaultValues="MEAN if --run-obj is QUALITY and MEAN10 if it is runtime")
    @Parameter(names={"--intra-obj", "--intra-instance-obj", "--overall-obj", "--intraInstanceObj", "--overallObj", "--overall_obj", "--intra_instance_obj"}, description="objective function used to aggregate multiple runs for a single instance", converter=OverallObjectiveConverter.class)
    public OverallObjective intraInstanceObj = null;
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.ADVANCED)
    @Parameter(names={"--inter-obj", "--inter-instance-obj", "--interInstanceObj", "--inter_instance_obj"}, description="objective function used to aggregate over multiple instances (that have already been aggregated under the Intra-Instance Objective)", converter=OverallObjectiveConverter.class)
    public OverallObjective interInstanceObj = OverallObjective.MEAN;
    @ParametersDelegate
    public TerminationCriteriaOptions limitOptions = new TerminationCriteriaOptions();
    @ParametersDelegate
    public ProblemInstanceOptions instanceOptions = new ProblemInstanceOptions();
    @UsageTextField(defaultValues="")
    @Parameter(names={"--scenario-file", "--scenarioFile"}, description="scenario file")
    @ParameterFile
    public File scenarioFile = null;
    @UsageTextField(defaultValues="<current working directory>/smac-output", level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--output-dir", "--outputDirectory", "--outdir"}, required=false, description="Output Directory")
    public String outputDirectory = System.getProperty("user.dir") + File.separator + "smac-output";
    public static final String invalidScenarioKey = "invalid-scenario-reason";
    @Parameter(names={"--invalid-scenario-reason"}, description="If this scenario file is invalid this a little notice that says why. This field is only used internally by verify-scenario", hidden=true)
    public String invalidScenarioReason;
    @ParametersDelegate
    public AlgorithmExecutionOptions algoExecOptions = new AlgorithmExecutionOptions();

    public RunObjective getRunObjective() {
        if (this._runObj == null) {
            throw new ParameterException("--run-obj must be set");
        }
        return this._runObj;
    }

    public OverallObjective getIntraInstanceObjective() {
        if (this.intraInstanceObj != null) {
            if (this.getRunObjective().equals((Object)RunObjective.QUALITY) && !this.intraInstanceObj.equals((Object)OverallObjective.MEAN)) {
                LoggerFactory.getLogger(this.getClass()).warn("Using a run objective of {} and an overall of objective of {} may not work correctly. You should probably only use {}", new Object[]{this.getRunObjective(), this.intraInstanceObj, OverallObjective.MEAN});
            }
            return this.intraInstanceObj;
        }
        switch (this.getRunObjective()) {
            case RUNTIME: {
                return OverallObjective.MEAN10;
            }
            case QUALITY: {
                return OverallObjective.MEAN;
            }
        }
        throw new IllegalStateException("Unknown run objective: " + (Object)((Object)this.getRunObjective()));
    }

    public AlgorithmExecutionConfig getAlgorithmExecutionConfig(String experimentDir) {
        ArrayList<String> arrList = new ArrayList<String>();
        arrList.add(experimentDir);
        if (this.scenarioFile != null) {
            arrList.add(this.scenarioFile.getAbsoluteFile().getParentFile().getAbsolutePath() + File.separator);
        }
        return this.algoExecOptions.getAlgorithmExecutionConfig(arrList, true);
    }

    public AlgorithmExecutionConfig getAlgorithmExecutionConfigSkipExecDirCheck(String experimentDir) {
        ArrayList<String> arrList = new ArrayList<String>();
        arrList.add(experimentDir);
        if (this.scenarioFile != null) {
            arrList.add(this.scenarioFile.getAbsoluteFile().getAbsolutePath() + File.separator);
        }
        return this.algoExecOptions.getAlgorithmExecutionConfig(arrList, false);
    }

    public ProblemInstanceOptions.TrainTestInstances getTrainingAndTestProblemInstances(String experimentDirectory, long trainingSeed, long testingSeed, boolean trainingRequired, boolean testRequired, boolean trainingFeaturesRequired, boolean testingFeaturesRequired) throws IOException {
        ArrayList<String> dirsToSearch = new ArrayList<String>();
        dirsToSearch.add(experimentDirectory);
        if (this.scenarioFile != null) {
            dirsToSearch.add(this.scenarioFile.getAbsoluteFile().getParentFile().getAbsolutePath() + File.separator);
        }
        return this.instanceOptions.getTrainingAndTestProblemInstances(dirsToSearch, trainingSeed, testingSeed, this.algoExecOptions.deterministic, trainingRequired, testRequired, trainingFeaturesRequired, testingFeaturesRequired);
    }

    public void makeOutputDirectory(String runGroupName) {
        File outputDir = new File(this.outputDirectory + File.separator + runGroupName);
        outputDir.mkdirs();
        if (outputDir.exists() && outputDir.isDirectory()) {
            return;
        }
        throw new ParameterException("Output directory " + outputDir.getPath() + " does not exist and could not be created. Try executing the following command: mkdir " + outputDir.getPath());
    }
}

