/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.AutomaticConfiguratorFactory;
import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractAsyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTargetAlgorithmEvaluator
extends AbstractAsyncTargetAlgorithmEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int observerFrequency;
    private final CommandLineTargetAlgorithmEvaluatorOptions options;
    private final BlockingQueue<Integer> executionIDs;
    private final ExecutorService asyncExecService;
    private final Semaphore asyncExecutions;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final boolean concurrentExecution;

    CommandLineTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, CommandLineTargetAlgorithmEvaluatorOptions options) {
        super(execConfig);
        this.observerFrequency = options.observerFrequency;
        this.log.debug("Initalized with the following Execution Configuration {} ", (Object)execConfig);
        this.concurrentExecution = options.concurrentExecution;
        if (this.observerFrequency < 50) {
            throw new ParameterException("Observer Frequency can't be less than 50 ms");
        }
        this.log.trace("Concurrent Execution {}", (Object)options.concurrentExecution);
        this.options = options;
        File execDir = new File(execConfig.getAlgorithmExecutionDirectory());
        if (!execDir.exists()) {
            throw new ParameterException("The Algorithm Execution Directory does not exist (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
        if (!execDir.isDirectory()) {
            throw new ParameterException("The Algorithm Execution Directory is NOT a directory (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
        this.executionIDs = new ArrayBlockingQueue<Integer>(options.cores);
        this.asyncExecService = Executors.newFixedThreadPool(options.cores, new SequentiallyNamedThreadFactory("Command Line Target Algorithm Evaluator Request Processor"));
        this.asyncExecutions = new Semaphore(options.cores, true);
        for (int i = 0; i < options.cores; ++i) {
            this.executionIDs.add(i);
        }
    }

    @Override
    public void evaluateRunsAsync(final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback taeCallback, final TargetAlgorithmEvaluatorRunObserver runStatusObserver) {
        if (runConfigs.size() == 0) {
            taeCallback.onSuccess(Collections.EMPTY_LIST);
            return;
        }
        try {
            this.asyncExecutions.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            taeCallback.onFailure(new IllegalStateException("Request interrupted", e));
            return;
        }
        this.asyncExecService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AlgorithmRunner runner = null;
                List<AlgorithmRun> runs = null;
                try {
                    try {
                        runner = CommandLineTargetAlgorithmEvaluator.this.getAlgorithmRunner(runConfigs, runStatusObserver);
                        runs = runner.run();
                    }
                    finally {
                        CommandLineTargetAlgorithmEvaluator.this.asyncExecutions.release();
                        if (runner != null) {
                            runner.shutdownThreadPool();
                        }
                    }
                }
                catch (RuntimeException e) {
                    taeCallback.onFailure(e);
                    return;
                }
                catch (Throwable e) {
                    taeCallback.onFailure(new IllegalStateException("Unexpected Throwable:", e));
                    return;
                }
                CommandLineTargetAlgorithmEvaluator.this.addRuns(runs);
                try {
                    taeCallback.onSuccess(runs);
                }
                catch (RuntimeException e) {
                    taeCallback.onFailure(e);
                }
                catch (Throwable e) {
                    taeCallback.onFailure(new IllegalStateException("Unexpected Throwable:", e));
                }
            }
        });
    }

    private AlgorithmRunner getAlgorithmRunner(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        if (this.concurrentExecution && this.options.cores > 1) {
            this.log.trace("Using concurrent algorithm runner");
            return AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner(this.execConfig, runConfigs, obs, this.options, this.executionIDs);
        }
        this.log.trace("Using single-threaded algorithm runner");
        return AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner(this.execConfig, runConfigs, obs, this.options, this.executionIDs);
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    public boolean areRunsObservable() {
        return true;
    }

    @Override
    public void notifyShutdown() {
        try {
            this.asyncExecService.shutdown();
            this.log.debug("Awaiting Termination of existing command line algorithm runs");
            boolean terminated = this.asyncExecService.awaitTermination(10L, TimeUnit.SECONDS);
            while (!terminated) {
                this.log.warn("Termination of target algorithm evaluator failed, outstanding runs must still exist, ");
                terminated = this.asyncExecService.awaitTermination(10L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException e) {
            this.asyncExecService.shutdownNow();
            Thread.currentThread().interrupt();
            return;
        }
    }
}

