/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.ipc.mechanism;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.ipc.ResponseParser;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPMechanism {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AlgorithmRun evaluateRun(RunConfig rc, AlgorithmExecutionConfig execConfig, String remoteHost, int remotePort) {
        try {
            Socket clientSocket = new Socket(remoteHost, remotePort);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            ArrayList<String> list = new ArrayList<String>();
            list.add(rc.getProblemInstanceSeedPair().getInstance().getInstanceName());
            list.add(rc.getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation());
            list.add(String.valueOf(rc.getCutoffTime()));
            list.add(String.valueOf(Integer.MAX_VALUE));
            list.add(String.valueOf(rc.getProblemInstanceSeedPair().getSeed()));
            ParamConfiguration.StringFormat f = ParamConfiguration.StringFormat.NODB_SYNTAX;
            for (String key : rc.getParamConfiguration().getActiveParameters()) {
                if (!f.getKeyValueSeperator().equals(" ")) throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
                if (!f.getGlue().equals(" ")) {
                    throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
                }
                list.add(f.getPreKey() + key);
                list.add(f.getValueDelimeter() + rc.getParamConfiguration().get(key) + f.getValueDelimeter());
            }
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                if (s.matches(".*\\s+.*")) {
                    sb.append("\"" + s + "\"");
                } else {
                    sb.append(s);
                }
                sb.append(" ");
            }
            try {
                byte[] sendData = sb.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            sb.append("\n");
            PrintWriter bwrite = new PrintWriter(clientSocket.getOutputStream());
            AutoStartStopWatch watch = new AutoStartStopWatch();
            bwrite.append(sb);
            bwrite.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            try {
                String serverLine = in.readLine();
                if (serverLine == null) return new ExistingAlgorithmRun(execConfig, rc, RunResult.CRASHED, 0.0, 0.0, 0.0, 0L, "No response from server: " + remoteHost + ":" + remotePort);
                AlgorithmRun algorithmRun = ResponseParser.processLine(serverLine, rc, execConfig, (double)watch.time() / 1000.0);
                return algorithmRun;
            }
            finally {
                clientSocket.close();
            }
        }
        catch (IOException e) {
            this.log.error("Error creating socket, trying connection again in 10 seconds", (Throwable)e);
            try {
                Thread.sleep(10000L);
                return this.evaluateRun(rc, execConfig, remoteHost, remotePort);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new TargetAlgorithmAbortException(e1);
            }
        }
    }
}

