/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.random;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractSyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.random.RandomResponseTargetAlgorithmEvaluatorOptions;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RandomResponseTargetAlgorithmEvaluator
extends AbstractSyncTargetAlgorithmEvaluator {
    private final double scale;
    private final double trendCoefficient;
    private final double minValue;
    private boolean persistent;
    private boolean shuffleRuns;
    private final Random rand;
    private final String additionalRunData;
    private static final Logger log = LoggerFactory.getLogger(RandomResponseTargetAlgorithmEvaluator.class);

    public RandomResponseTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, RandomResponseTargetAlgorithmEvaluatorOptions options) {
        super(execConfig);
        if (options.maxResponse - options.minResponse < 0.0) {
            throw new ParameterException("Maximum response must be greater than the minimum response");
        }
        this.scale = options.maxResponse - options.minResponse;
        this.minValue = options.minResponse;
        this.trendCoefficient = options.trendCoefficient;
        log.debug("Target Algorithm Evaluator initialized with seed: {} ", (Object)options.seed);
        this.rand = new MersenneTwister(options.seed);
        this.shuffleRuns = options.shuffleResponses;
        this.persistent = options.persistent;
        this.additionalRunData = options.additionalRunData;
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        ArrayList<AlgorithmRun> ar = new ArrayList<AlgorithmRun>(runConfigs.size());
        for (RunConfig rc : runConfigs) {
            double time = Math.max(0.01, this.rand.nextDouble() * this.scale + this.minValue + this.trendCoefficient * (double)this.getRunCount());
            if (time >= rc.getCutoffTime()) {
                ar.add(new ExistingAlgorithmRun(this.execConfig, rc, RunResult.TIMEOUT, rc.getCutoffTime(), -1.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), this.additionalRunData));
            } else {
                ar.add(new ExistingAlgorithmRun(this.execConfig, rc, RunResult.SAT, time, -1.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), this.additionalRunData));
            }
            this.runCount.incrementAndGet();
        }
        if (this.shuffleRuns) {
            Collections.shuffle(ar, this.rand);
        }
        return ar;
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return this.persistent;
    }

    @Override
    protected void subtypeShutdown() {
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }
}

