/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private final ScheduledExecutorService execService = Executors.newScheduledThreadPool(1, new SequentiallyNamedThreadFactory("Terminate Run FileWatcher", true));
    private final long POLL_FREQUENCY = 2L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, final File fileToWatch) {
        super(tae);
        this.log.info("Terminating all runs if {} is deleted", (Object)fileToWatch);
        if (!fileToWatch.exists()) {
            this.log.warn("File To Watch: {} does not exist, was it already deleted?", (Object)fileToWatch);
        }
        this.execService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!fileToWatch.exists() && !TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator.this.terminate.getAndSet(true)) {
                    TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator.this.log.info("File {} has been deleted, all runs will be terminated as quickly as possible", (Object)fileToWatch);
                }
            }
        }, 2L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.tae.evaluateRun(runConfigs, new TerminateAllRunOnFileDeleteTargetAlgorithmEvaluatorObserver(obs));
    }

    @Override
    public final void evaluateRunsAsync(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, new TerminateAllRunOnFileDeleteTargetAlgorithmEvaluatorObserver(obs));
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        this.execService.shutdownNow();
        try {
            this.execService.awaitTermination(24L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private class TerminateAllRunOnFileDeleteTargetAlgorithmEvaluatorObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;

        TerminateAllRunOnFileDeleteTargetAlgorithmEvaluatorObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
            if (TerminateAllRunsOnFileDeleteTargetAlgorithmEvaluatorDecorator.this.terminate.get()) {
                for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                    killableAlgorithmRun.kill();
                }
            }
            if (this.obs != null) {
                this.obs.currentStatus(runs);
            }
        }
    }
}

