/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.transform;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.transform.TransformTargetAlgorithmEvaluatorDecoratorOptions;
import com.beust.jcommander.ParameterException;
import de.congrace.exp4j.Calculable;
import de.congrace.exp4j.ExpressionBuilder;
import de.congrace.exp4j.UnknownFunctionException;
import de.congrace.exp4j.UnparsableExpressionException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TransformTargetAlgorithmEvaluatorDecorator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private final TransformTargetAlgorithmEvaluatorDecoratorOptions options;
    static final String[] variablesnames = new String[]{"S", "R", "Q", "C"};
    private final Calculable SAT_runtime_calculable;
    private final Calculable SAT_quality_calculable;
    private final Calculable UNSAT_runtime_calculable;
    private final Calculable UNSAT_quality_calculable;
    private final Calculable TIMEOUT_quality_calculable;
    private final Calculable TIMEOUT_runtime_calculable;
    private final Calculable other_runtime_calculable;
    private final Calculable other_quality_calculable;
    private final List<Calculable> calculables;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean warningLogged = new AtomicBoolean(false);

    public TransformTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, TransformTargetAlgorithmEvaluatorDecoratorOptions options) {
        super(tae);
        this.log.debug("Results from the Target Algorithm Evaluator are being transformed");
        try {
            this.SAT_runtime_calculable = new ExpressionBuilder(options.SAT_runtime_transform).withVariableNames(variablesnames).build();
            this.SAT_quality_calculable = new ExpressionBuilder(options.SAT_quality_transform).withVariableNames(variablesnames).build();
            this.UNSAT_runtime_calculable = new ExpressionBuilder(options.UNSAT_runtime_transform).withVariableNames(variablesnames).build();
            this.UNSAT_quality_calculable = new ExpressionBuilder(options.UNSAT_quality_transform).withVariableNames(variablesnames).build();
            this.TIMEOUT_runtime_calculable = new ExpressionBuilder(options.TIMEOUT_runtime_transform).withVariableNames(variablesnames).build();
            this.TIMEOUT_quality_calculable = new ExpressionBuilder(options.TIMEOUT_quality_transform).withVariableNames(variablesnames).build();
            this.other_runtime_calculable = new ExpressionBuilder(options.other_runtime_transform).withVariableNames(variablesnames).build();
            this.other_quality_calculable = new ExpressionBuilder(options.other_quality_transform).withVariableNames(variablesnames).build();
        }
        catch (UnparsableExpressionException e) {
            throw new ParameterException("Provided options contains an uncalculable string (" + e.getMessage() + ").");
        }
        catch (UnknownFunctionException e) {
            throw new ParameterException("Provided options contains a calculable string with an unknown function (" + e.getMessage() + ").");
        }
        this.calculables = Arrays.asList(this.SAT_runtime_calculable, this.SAT_quality_calculable, this.UNSAT_runtime_calculable, this.UNSAT_quality_calculable, this.TIMEOUT_quality_calculable, this.TIMEOUT_runtime_calculable, this.other_runtime_calculable, this.other_quality_calculable);
        this.options = options;
    }

    @Override
    protected AlgorithmRun processRun(AlgorithmRun run) {
        Calculable usedCalculable;
        double transformed_quality;
        double transformedRuntime;
        int S;
        switch (run.getRunResult()) {
            case SAT: {
                S = 1;
                break;
            }
            case UNSAT: {
                S = -1;
                break;
            }
            default: {
                S = 0;
            }
        }
        double R = run.getRuntime();
        double Q = run.getQuality();
        double C = run.getRunConfig().getCutoffTime();
        for (Calculable calculable : this.calculables) {
            calculable.setVariable("S", (double)S);
            calculable.setVariable("R", R);
            calculable.setVariable("Q", Q);
            calculable.setVariable("C", C);
        }
        switch (run.getRunResult()) {
            case SAT: {
                transformedRuntime = this.SAT_runtime_calculable.calculate();
                transformed_quality = this.SAT_quality_calculable.calculate();
                usedCalculable = this.SAT_runtime_calculable;
                break;
            }
            case UNSAT: {
                transformedRuntime = this.UNSAT_runtime_calculable.calculate();
                transformed_quality = this.UNSAT_quality_calculable.calculate();
                usedCalculable = this.UNSAT_runtime_calculable;
                break;
            }
            case TIMEOUT: {
                transformedRuntime = this.TIMEOUT_runtime_calculable.calculate();
                transformed_quality = this.TIMEOUT_quality_calculable.calculate();
                usedCalculable = this.TIMEOUT_runtime_calculable;
                break;
            }
            default: {
                transformedRuntime = this.other_runtime_calculable.calculate();
                transformed_quality = this.other_quality_calculable.calculate();
                usedCalculable = this.other_runtime_calculable;
            }
        }
        if (this.options.transformValidValuesOnly && transformedRuntime >= run.getRunConfig().getCutoffTime()) {
            return new ExistingAlgorithmRun(run.getExecutionConfig(), run.getRunConfig(), RunResult.TIMEOUT, run.getRunConfig().getCutoffTime(), run.getRunLength(), transformed_quality, run.getResultSeed());
        }
        if (this.options.transformValidValuesOnly && transformedRuntime < 0.0) {
            if (!this.warningLogged.getAndSet(true)) {
                this.log.warn("Transformation of Runtime seems to have resulted in a negative value this is illegal and you should ensure that the result is always above zero, original run: {}, transformed runtime: {}, transformation: \"{}\" ", new Object[]{run, transformedRuntime, usedCalculable.getExpression()});
            }
            transformedRuntime = 0.0;
        }
        return new ExistingAlgorithmRun(run.getExecutionConfig(), run.getRunConfig(), run.getRunResult(), transformedRuntime, run.getRunLength(), transformed_quality, run.getResultSeed());
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

