/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final long ZERO_TIME = System.currentTimeMillis();
    private String resultFile;
    private String nameOfRuns;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final double resolutionInMS;
    private final ConcurrentHashMap<RunConfig, Double> startTime = new ConcurrentHashMap();
    private final ConcurrentHashMap<RunConfig, Double> endTime = new ConcurrentHashMap();
    private final ConcurrentHashMap<RunConfig, Double> startWalltime = new ConcurrentHashMap();
    private final ConcurrentHashMap<RunConfig, Double> startCPUtime = new ConcurrentHashMap();
    private final ConcurrentHashMap<List<RunConfig>, Double> startBatchTime = new ConcurrentHashMap();
    private final ConcurrentHashMap<List<RunConfig>, Double> endBatchTime = new ConcurrentHashMap();

    public OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, String resultFile, double resolutionInSeconds, String nameOfRuns) {
        super(tae);
        this.resultFile = resultFile;
        this.nameOfRuns = nameOfRuns;
        this.resolutionInMS = resolutionInSeconds * 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorRunObserver obs) {
        this.startBatchTime.put(runConfigs, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
        TargetAlgorithmEvaluatorRunObserver wrappedObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                if (obs != null) {
                    obs.currentStatus(runs);
                }
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
            }
        };
        try {
            List<AlgorithmRun> list = this.processRuns(this.tae.evaluateRun(this.processRunConfigs(runConfigs), wrappedObs));
            return list;
        }
        finally {
            this.endBatchTime.put(runConfigs, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
        }
    }

    @Override
    public final void evaluateRunsAsync(final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, final TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                runs = OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.endBatchTime.put(runConfigs, Math.max(0.0, (double)(OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.bucketTime(System.currentTimeMillis()) - OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.ZERO_TIME) / 1000.0));
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.endBatchTime.putIfAbsent(runConfigs, Math.max(0.0, (double)(OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.bucketTime(System.currentTimeMillis()) - OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.ZERO_TIME) / 1000.0));
                this.handler.onFailure(t);
            }
        };
        TargetAlgorithmEvaluatorRunObserver wrappedObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                if (obs != null) {
                    obs.currentStatus(runs);
                }
            }
        };
        this.startBatchTime.put(runConfigs, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
        this.tae.evaluateRunsAsync(this.processRunConfigs(runConfigs), myHandler, wrappedObs);
    }

    @Override
    public void postDecorateeNotifyShutdown() {
        Collection[] myDoubles;
        this.log.trace("Processing detailed run statistics to {} ", (Object)this.resultFile);
        if (this.startTime.size() > this.endTime.size()) {
            this.log.warn("Some runs are still outstanding, it is possible that we are shutting down prematurely, started: {} , finished: {}", (Object)this.startTime.size(), (Object)this.endTime.size());
        }
        if (this.startTime.size() < this.endTime.size()) {
            for (Map.Entry<RunConfig, Double> ent : this.startTime.entrySet()) {
                this.log.error("At " + ent.getValue() + " : " + ent.getKey() + " started.");
            }
            for (Map.Entry<RunConfig, Double> ent : this.endTime.entrySet()) {
                this.log.error("At " + ent.getValue() + " : " + ent.getKey() + " ended. ");
            }
            throw new IllegalStateException("[BUG]: Determined that more algorithms ended " + this.endTime.size() + " than started " + this.startTime.size());
        }
        ConcurrentSkipListMap<Double, StartEnd> startEndMap = new ConcurrentSkipListMap<Double, StartEnd>();
        for (Collection cod : myDoubles = new Collection[]{this.startTime.values(), this.endTime.values(), this.startWalltime.values(), this.startCPUtime.values(), this.startBatchTime.values(), this.endBatchTime.values()}) {
            for (Double d : cod) {
                StartEnd e = (StartEnd)startEndMap.get(d);
                if (e != null) continue;
                startEndMap.put(d, new StartEnd());
            }
        }
        for (Map.Entry<RunConfig, Double> entry : this.startTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).startDispatch;
        }
        for (Map.Entry<RunConfig, Double> entry : this.endTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).endDispatch;
        }
        for (Map.Entry<RunConfig, Double> entry : this.startCPUtime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).startCPUtime;
        }
        for (Map.Entry<RunConfig, Double> entry : this.startWalltime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).startWalltime;
        }
        for (Map.Entry<Object, Double> entry : this.startBatchTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).startBatchTime;
        }
        for (Map.Entry<Object, Double> entry : this.endBatchTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).endBatchTime;
        }
        File f = new File(this.resultFile);
        try {
            FileWriter fileWriter = new FileWriter(f);
            fileWriter.write("Time (Zero is " + this.ZERO_TIME + "), Started, Ending, Number of " + this.nameOfRuns + "  Runs, Approximate Start Based on CPU Time, Approximate Start Based on Walltime, Number of Running By CPU Time, Number of Running By Walltime, Started Batch, End Batch, Outstanding Batches\n");
            int outstanding = 0;
            int outstandingCPU = 0;
            int outstandingWall = 0;
            int outstandingBatches = 0;
            for (Map.Entry ent : startEndMap.entrySet()) {
                outstanding = (int)((long)outstanding + (((StartEnd)ent.getValue()).startDispatch - ((StartEnd)ent.getValue()).endDispatch));
                outstandingCPU = (int)((long)outstandingCPU + (((StartEnd)ent.getValue()).startCPUtime - ((StartEnd)ent.getValue()).endDispatch));
                outstandingWall = (int)((long)outstandingWall + (((StartEnd)ent.getValue()).startWalltime - ((StartEnd)ent.getValue()).endDispatch));
                outstandingBatches = (int)((long)outstandingBatches + (((StartEnd)ent.getValue()).startBatchTime - ((StartEnd)ent.getValue()).endBatchTime));
                fileWriter.write(ent.getKey() + "," + ((StartEnd)ent.getValue()).startDispatch + "," + ((StartEnd)ent.getValue()).endDispatch + "," + outstanding + "," + ((StartEnd)ent.getValue()).startCPUtime + "," + ((StartEnd)ent.getValue()).startWalltime + "," + outstandingCPU + "," + outstandingWall + "," + ((StartEnd)ent.getValue()).startBatchTime + "," + ((StartEnd)ent.getValue()).endBatchTime + "," + outstandingBatches + "\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.log.trace("Processing complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K extends AlgorithmRun> K processRun(K run) {
        if (run.isRunCompleted()) {
            RunConfig rc;
            RunConfig runConfig = rc = run.getRunConfig();
            synchronized (runConfig) {
                if (this.endTime.get(rc) != null) {
                    return run;
                }
                double endTimeX = (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0;
                this.endTime.put(rc, Math.max(0.0, endTimeX));
                if (this.startWalltime.get(rc) == null) {
                    double startTimeX = (double)(this.bucketTime(System.currentTimeMillis() - (long)(run.getWallclockExecutionTime() * 1000.0)) - this.ZERO_TIME) / 1000.0;
                    this.startWalltime.put(rc, Math.max(0.0, startTimeX));
                }
                if (this.startCPUtime.get(rc) == null) {
                    double startCPUTimeX = (double)(this.bucketTime(System.currentTimeMillis() - (long)(run.getRuntime() * 1000.0)) - this.ZERO_TIME) / 1000.0;
                    this.startCPUtime.put(rc, Math.max(0.0, startCPUTimeX));
                }
            }
        }
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunConfig processRun(RunConfig rc) {
        RunConfig runConfig = rc;
        synchronized (runConfig) {
            if (this.startTime.get(rc) == null) {
                this.startTime.put(rc, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
            }
        }
        return rc;
    }

    protected final <K extends AlgorithmRun> List<K> processRuns(List<K> runs) {
        for (int i = 0; i < runs.size(); ++i) {
            runs.set(i, this.processRun((AlgorithmRun)runs.get(i)));
        }
        return runs;
    }

    protected final List<RunConfig> processRunConfigs(List<RunConfig> runConfigs) {
        runConfigs = new ArrayList<RunConfig>(runConfigs);
        for (int i = 0; i < runConfigs.size(); ++i) {
            runConfigs.set(i, this.processRun(runConfigs.get(i)));
        }
        return runConfigs;
    }

    private final long bucketTime(long time) {
        return (long)((double)((long)((double)time / this.resolutionInMS)) * this.resolutionInMS);
    }

    private static class StartEnd {
        public long startDispatch = 0L;
        public long endDispatch = 0L;
        public long startCPUtime = 0L;
        public long startWalltime = 0L;
        public long startBatchTime = 0L;
        public long endBatchTime = 0L;

        private StartEnd() {
        }
    }
}

