/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.termination.ConditionType;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CPULimitCondition
extends AbstractTerminationCondition {
    private final double cpuTimeLimit;
    private AtomicDouble currentTime;
    private final String NAME = "CPUTIME";
    private final boolean countACTime;
    private final CPUTime cpuTime;

    public CPULimitCondition(double totalCPUTimeLimit, boolean countACTime, CPUTime cpuTime) {
        this.cpuTimeLimit = totalCPUTimeLimit;
        this.currentTime = new AtomicDouble(0.0);
        this.countACTime = countACTime;
        this.cpuTime = cpuTime;
    }

    @Override
    public double getTunerTime() {
        return this.currentTime.get() + (this.countACTime ? this.cpuTime.getCPUTime() : 0.0);
    }

    @Override
    public boolean haveToStop() {
        return this.cpuTimeLimit <= this.getTunerTime();
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        double tunerTime = this.getTunerTime();
        return Collections.singleton(new ValueMaxStatus(ConditionType.TUNERTIME, tunerTime, this.cpuTimeLimit, "CPUTIME", "Configuration Time Budget", "s"));
    }

    @Override
    public synchronized void notifyRun(AlgorithmRun run) {
        this.currentTime.addAndGet(Math.max(0.1, run.getRuntime()));
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "total CPU time limit (" + this.cpuTimeLimit + " s) has been reached.";
        }
        return "";
    }
}

