/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.integration;

import net.sf.doodleproject.numerics4j.IterativeMethod;
import net.sf.doodleproject.numerics4j.exception.ConvergenceException;
import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.function.Function;
import net.sf.doodleproject.numerics4j.integration.TrapezoidalIntegrator;

public class SimpsonsIntegrator
extends IterativeMethod {
    private Function function;

    public SimpsonsIntegrator(Function f) {
        this(f, 100, 1.0E-10);
    }

    public SimpsonsIntegrator(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public Function getFunction() {
        return this.function;
    }

    public double integrate(double a, double b) throws NumericException {
        double sumTrapezoidal;
        TrapezoidalIntegrator.IterativeState state = new TrapezoidalIntegrator.IterativeState(this.function, a, b);
        double sumTrapezoidalNext = sumTrapezoidal = state.getResult();
        double error = Double.MAX_VALUE;
        double sumSimpons = sumTrapezoidal;
        do {
            state.iterate();
            sumTrapezoidalNext = state.getResult();
            double sumSimponsNext = 4.0 * sumTrapezoidalNext / 3.0 - sumTrapezoidal / 3.0;
            error = Math.abs(sumSimponsNext / sumSimpons - 1.0);
            sumTrapezoidal = sumTrapezoidalNext;
            sumSimpons = sumSimponsNext;
        } while (state.getIterations() < this.getMaximumIterations() && error > this.getMaximumRelativeError());
        if (state.getIterations() >= this.getMaximumIterations()) {
            throw new ConvergenceException("Simpson's integration failed to converge.");
        }
        return sumSimpons;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

