import java.util.*;

//Class representing a dynamic surface.
public class DSurface extends Surface{
    
    public DSurface(){
	super();
    }
    
    public DSurface(Vector faces){
	super(faces);
    }

    //Add a polygonal face to a surface.
    public void addFace(Polygon p){
	getFaces().addElement(p);
    }

    //Add a set of polygonal faces to a surface.
    public void addFaces(Vector v){
	for (Enumeration e = v.elements();e.hasMoreElements();)
	    addFace((Polygon)e.nextElement());
    }
    
    //Delete a polygonal face from a surface.
    public boolean deleteFace(Polygon p){
	return getFaces().removeElement(p);
    }
}
