/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.acquisitionfunctions;

import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunction;
import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunctionHelper;
import ca.ubc.cs.beta.aeatk.misc.math.ArrayMathOps;

public class ExpectedExponentialImprovement
implements AcquisitionFunction {
    private double[] log_exp_exponentiated_imp(double[] fmin_samples, double[] mus, double[] sigmas) {
        int numSamples = fmin_samples.length;
        int numMus = mus.length;
        double[] log_expEI = new double[mus.length];
        if (numSamples > 1) {
            throw new IllegalArgumentException("log_exp_exponentiated_imp not yet implemented for numSamples>1; can do that based on logsumexp trick.");
        }
        for (int i = 0; i < numMus; ++i) {
            log_expEI[i] = 0.0;
            for (int s = 0; s < numSamples; ++s) {
                double cdfln_2;
                double d;
                double cdfln_1 = AcquisitionFunctionHelper.normcdfln((fmin_samples[s] - mus[i]) / sigmas[i]);
                double c = fmin_samples[s] + cdfln_1;
                log_expEI[i] = c <= (d = sigmas[i] * sigmas[i] / 2.0 + mus[i] + (cdfln_2 = AcquisitionFunctionHelper.normcdfln((fmin_samples[s] - mus[i]) / sigmas[i] - sigmas[i]))) ? d : d + ArrayMathOps.log(ArrayMathOps.exp(c - d) - 1.0);
            }
        }
        return log_expEI;
    }

    @Override
    public double[] computeAcquisitionFunctionValue(double f_min_samples, double[] predmean, double[] predvar) {
        if (predmean.length != predvar.length) {
            throw new IllegalArgumentException("Expected predmean and predvar to have the same length");
        }
        double log10 = Math.log(10.0);
        double[] fmin = new double[]{log10 * f_min_samples};
        double[] expImp = this.log_exp_exponentiated_imp(fmin, ArrayMathOps.times(log10, predmean), ArrayMathOps.times(log10, ArrayMathOps.sqrt(predvar)));
        for (int i = 0; i < expImp.length; ++i) {
            expImp[i] = -expImp[i];
        }
        return expImp;
    }
}

