/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.algorithmrunresult;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AbstractAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingAlgorithmRunResult
extends AbstractAlgorithmRunResult {
    private static final long serialVersionUID = 2L;
    private static transient Logger log = LoggerFactory.getLogger(ExistingAlgorithmRunResult.class);

    public ExistingAlgorithmRunResult(AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runLength, double quality, long resultSeed, String additionalRunData, double wallclockTime) {
        super(runConfig, runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", additionalRunData, wallclockTime);
    }

    public ExistingAlgorithmRunResult(AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runLength, double quality, long resultSeed, double wallclockTime) {
        super(runConfig, runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", "", wallclockTime);
    }

    public ExistingAlgorithmRunResult(AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runlength, double quality, long seed, String additionalRunData) {
        this(runConfig, runResult, runtime, runlength, quality, seed, additionalRunData, 0.0);
    }

    public ExistingAlgorithmRunResult(AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runlength, double quality, long seed) {
        this(runConfig, runResult, runtime, runlength, quality, seed, "", 0.0);
    }

    @Deprecated
    public ExistingAlgorithmRunResult(AlgorithmExecutionConfiguration execConfig, AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runLength, double quality, long resultSeed, String additionalRunData, double wallclockTime) {
        super(runConfig, runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", additionalRunData, wallclockTime);
    }

    @Deprecated
    public ExistingAlgorithmRunResult(AlgorithmExecutionConfiguration execConfig, AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runLength, double quality, long resultSeed, double wallclockTime) {
        super(runConfig, runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", "", wallclockTime);
    }

    @Deprecated
    public ExistingAlgorithmRunResult(AlgorithmExecutionConfiguration execConfig, AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runlength, double quality, long seed, String additionalRunData) {
        this(execConfig, runConfig, runResult, runtime, runlength, quality, seed, additionalRunData, 0.0);
    }

    @Deprecated
    public ExistingAlgorithmRunResult(AlgorithmExecutionConfiguration execConfig, AlgorithmRunConfiguration runConfig, RunStatus runResult, double runtime, double runlength, double quality, long seed) {
        this(execConfig, runConfig, runResult, runtime, runlength, quality, seed, "", 0.0);
    }

    @Deprecated
    public static ExistingAlgorithmRunResult getRunFromString(AlgorithmRunConfiguration runConfig, String result) {
        return ExistingAlgorithmRunResult.getRunFromString(runConfig, result, 0.0);
    }

    @Deprecated
    public static ExistingAlgorithmRunResult getRunFromString(AlgorithmRunConfiguration runConfig, String result, double wallClockTime) {
        String[] resultLine = result.split(",");
        try {
            RunStatus acResult;
            try {
                acResult = RunStatus.getAutomaticConfiguratorResultForCode(Integer.valueOf(resultLine[0]));
            }
            catch (NumberFormatException e) {
                acResult = RunStatus.getAutomaticConfiguratorResultForKey(resultLine[0]);
            }
            double runtime = Double.valueOf(resultLine[1].trim());
            double runLength = Double.valueOf(resultLine[2].trim());
            double quality = Double.valueOf(resultLine[3].trim());
            long resultSeed = Long.valueOf(resultLine[4].trim());
            String additionalRunData = "";
            if (resultLine.length == 6) {
                additionalRunData = resultLine[5].trim();
            }
            return new ExistingAlgorithmRunResult(runConfig, acResult, runtime, runLength, quality, resultSeed, additionalRunData, wallClockTime);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] args = new Object[]{runConfig, result};
            log.debug("Malformed Run Result for Execution (ArrayIndexOutOfBoundsException): {}, Instance: {}, Result: {}", args);
            log.debug("Exception:", (Throwable)e);
            return ExistingAlgorithmRunResult.getAbortResult(runConfig, e.getMessage());
        }
        catch (NumberFormatException e) {
            log.debug("Malformed Run Result for Execution (NumberFormatException):  Instance: {}, Result: {}", (Object)runConfig, (Object)result);
            log.debug("Exception:", (Throwable)e);
            return ExistingAlgorithmRunResult.getAbortResult(runConfig, e.getMessage());
        }
    }

    public static ExistingAlgorithmRunResult getAbortResult(AlgorithmRunConfiguration rc, String message) {
        return new ExistingAlgorithmRunResult(rc, RunStatus.ABORT, 0.0, 0.0, 0.0, 0L, "ERROR:" + message, 0.0);
    }

    @Override
    public void kill() {
    }
}

