/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class FairMultiPermitSemaphore {
    private final Semaphore semaphore;
    private final AtomicInteger permits;
    private final ReentrantLock mutexLock = new ReentrantLock();

    public FairMultiPermitSemaphore(int numberOfPermits) {
        this.semaphore = new Semaphore(numberOfPermits);
        this.permits = new AtomicInteger(numberOfPermits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUpToNPermits(int N) throws InterruptedException {
        int grabbedPermits;
        if (N < 0) {
            throw new IllegalArgumentException("Must get a non-negative amount of permits");
        }
        if (N == 0) {
            return 0;
        }
        this.semaphore.acquire();
        try {
            int remainingPermits;
            int availablePermits;
            this.mutexLock.lock();
            while (!this.permits.compareAndSet(availablePermits = this.permits.get(), remainingPermits = availablePermits - (grabbedPermits = Math.min(N, availablePermits)))) {
            }
            if (this.semaphore.availablePermits() < grabbedPermits - 1) {
                throw new IllegalStateException("Concurrency Bug, at this point I should be able to grab the remaining permits " + this.semaphore.availablePermits() + " but I have allegedly grabbed " + (grabbedPermits - 1));
            }
        }
        finally {
            this.mutexLock.unlock();
        }
        this.semaphore.acquire(grabbedPermits - 1);
        return grabbedPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePermits(int N) {
        if (N < 0) {
            throw new IllegalArgumentException("You cannot release a negative number of permits");
        }
        if (N == 0) {
            return;
        }
        this.mutexLock.lock();
        try {
            this.permits.addAndGet(N);
            this.semaphore.release(N);
        }
        finally {
            this.mutexLock.unlock();
        }
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public void drainPermits() {
        this.semaphore.drainPermits();
    }
}

