/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.eventsystem;

import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.basic.EventHandlerRuntimeExceptionEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.basic.EventManagerShutdownEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.internal.FlushEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.exceptions.EventFlushDeadLockException;
import ca.ubc.cs.beta.aeatk.eventsystem.exceptions.EventManagerPrematureShutdownException;
import ca.ubc.cs.beta.aeatk.eventsystem.exceptions.EventManagerShutdownException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private final ConcurrentHashMap<Class<? extends AutomaticConfiguratorEvent>, List<EventHandler<?>>> handlerMap = new ConcurrentHashMap();
    private transient Logger log = LoggerFactory.getLogger(EventManager.class);
    private final LinkedBlockingQueue<Runnable> asyncRuns = new LinkedBlockingQueue();
    private final EventManagementThread eventDispatchThread;
    private volatile boolean shutdown = false;
    private final ConcurrentHashMap<Class<?>, AtomicInteger> eventNamesCount = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, AtomicInteger> outstandingEventCount = new ConcurrentHashMap();
    private final Set<Semaphore> waitingThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean dispatchThreadDone = false;
    private AtomicReference<EventFlushDeadLockException> deadLockException = new AtomicReference();

    public EventManager() {
        EventManagementThread t;
        this.registerHandler(FlushEvent.class, new EventHandler<FlushEvent>(){

            @Override
            public void handleEvent(FlushEvent event) {
                event.releaseSemaphore();
            }
        });
        this.eventDispatchThread = t = new EventManagementThread(this.asyncRuns);
        t.start();
    }

    public synchronized void registerHandler(Class<? extends AutomaticConfiguratorEvent> eventClass, EventHandler<?> handler) {
        this.checkForShutdown();
        this.handlerMap.putIfAbsent(eventClass, new ArrayList());
        List<EventHandler<?>> handlers = this.handlerMap.get(eventClass);
        handlers.add(handler);
    }

    public synchronized void fireEvent(AutomaticConfiguratorEvent event) {
        this.checkForShutdown();
        EventFlushDeadLockException exp = this.deadLockException.get();
        if (exp != null) {
            throw new IllegalStateException("Deadlock has previously occurred, event manager is unavailable", this.deadLockException.get());
        }
        this.log.trace("Event requested for dispatch {}", (Object)event.getClass().getSimpleName());
        this.handlerMap.putIfAbsent(event.getClass(), new ArrayList());
        List<EventHandler<?>> handlers = this.handlerMap.get(event.getClass());
        this.eventNamesCount.putIfAbsent(event.getClass(), new AtomicInteger(0));
        this.eventNamesCount.get(event.getClass()).incrementAndGet();
        this.outstandingEventCount.putIfAbsent(event.getClass(), new AtomicInteger(0));
        for (EventHandler<?> handler : handlers) {
            this.outstandingEventCount.get(event.getClass()).incrementAndGet();
            final AutomaticConfiguratorEvent event2 = event;
            final EventHandler<?> handler2 = handler;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventManager.this.log.trace("Dispatching event {} to handler: {}", (Object)(event2.getClass().getSimpleName() + " (0x" + Integer.toHexString(System.identityHashCode(event2)) + ")"), (Object)handler2.getClass().getSimpleName());
                        ((AtomicInteger)EventManager.this.outstandingEventCount.get(event2.getClass())).decrementAndGet();
                        handler2.handleEvent(event2);
                    }
                    catch (RuntimeException t) {
                        Object[] args = new Object[]{handler2, event2, t};
                        EventManager.this.log.error("Error occured during dispatching of event", (Throwable)t);
                        EventManager.this.log.error("Event Handler {} while processing event: {}, threw Exception {}", args);
                        if (!(event2 instanceof EventHandlerRuntimeExceptionEvent)) {
                            EventManager.this.fireEvent(new EventHandlerRuntimeExceptionEvent(t, event2));
                            return;
                        }
                        EventManager.this.log.error("Event Handler threw exception while we were processing the {} event, not notifying anything else", event2.getClass());
                    }
                }
            };
            try {
                this.asyncRuns.put(run);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        block7: {
            if (this.shutdown) {
                return;
            }
            this.checkForDeadLock();
            Semaphore wait = new Semaphore(0);
            this.waitingThreads.add(wait);
            try {
                this.fireEvent(new FlushEvent(wait));
                if (this.dispatchThreadDone) {
                    this.log.trace("Flush probably not completed as dispatch thread has terminated");
                    break block7;
                }
                try {
                    wait.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.waitingThreads.remove(wait);
                    return;
                }
            }
            finally {
                this.waitingThreads.remove(wait);
            }
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    private void checkForDeadLock() {
        if (Thread.currentThread().equals(this.eventDispatchThread)) {
            EventFlushDeadLockException e = new EventFlushDeadLockException();
            this.deadLockException.set(e);
            this.log.error("Deadlock detected ", (Throwable)e);
            System.out.flush();
            System.err.flush();
            e.printStackTrace();
            System.out.flush();
            System.err.flush();
            throw e;
        }
    }

    private synchronized void checkForShutdown() {
        if (this.shutdown) {
            throw new EventManagerShutdownException();
        }
        if (this.dispatchThreadDone) {
            throw new EventManagerPrematureShutdownException();
        }
    }

    public synchronized void shutdown() {
        try {
            this.fireEvent(new EventManagerShutdownEvent());
            this.flush();
        }
        catch (EventManagerPrematureShutdownException e) {
            // empty catch block
        }
        this.shutdown = true;
        this.eventDispatchThread.interrupt();
        this.eventDispatchThread.waitForCompletion();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class<?>, AtomicInteger> ent : this.eventNamesCount.entrySet()) {
            sb.append(ent.getKey().getSimpleName()).append("=>(").append(ent.getValue().get()).append("), ");
        }
        sb.setCharAt(sb.length() - 2, ' ');
        this.log.debug("Event Dispatch Name / Counts: {}", (Object)sb);
    }

    static /* synthetic */ boolean access$202(EventManager x0, boolean x1) {
        x0.dispatchThreadDone = x1;
        return x0.dispatchThreadDone;
    }

    static /* synthetic */ Set access$300(EventManager x0) {
        return x0.waitingThreads;
    }

    class EventManagementThread
    extends Thread {
        private transient Logger log = LoggerFactory.getLogger(EventManager.class);
        private BlockingQueue<Runnable> asyncRuns;
        private Semaphore threadDone = new Semaphore(0);
        private int highLoadQueueWarningDisplay = 128;

        public EventManagementThread(BlockingQueue<Runnable> asyncRuns) {
            this.asyncRuns = asyncRuns;
            this.setName("Event Manager Dispatch Thread");
            this.setDaemon(true);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 4 sources

            {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                try {
                    this.asyncRuns.take().run();
                    if (this.asyncRuns.size() <= this.highLoadQueueWarningDisplay) ** GOTO lbl-1000
                    this.highLoadQueueWarningDisplay *= 2;
                    this.log.warn("Processing Events has {} elements currently waiting, next warning at {} ", (Object)this.asyncRuns.size(), (Object)this.highLoadQueueWarningDisplay);
                    sb = new StringBuilder();
                    for (Map.Entry ent : EventManager.access$100(EventManager.this).entrySet()) {
                        sb.append(((Class)ent.getKey()).getSimpleName()).append("=>(").append(((AtomicInteger)ent.getValue()).get()).append("), ");
                    }
                    sb.setCharAt(sb.length() - 2, ' ');
                    this.log.warn("Outstanding Events are as follows: {}", (Object)sb);
                }
                catch (RuntimeException e) {
                    this.log.error("Unexpected Exception occured", (Throwable)e);
                    continue;
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                EventManager.access$202(EventManager.this, true);
                this.threadDone.release();
                i = 0;
                for (Semaphore s : EventManager.access$300(EventManager.this)) {
                    s.release();
                    ++i;
                }
                this.log.debug("Event Manager thread done, released {} pending flushes", (Object)i);
                return;
            }
            catch (Error e) {
                this.log.error("Error occurred in Event Manager ", (Throwable)e);
                throw e;
            }
            ** GOTO lbl-1000
            finally {
                EventManager.access$202(EventManager.this, true);
                this.threadDone.release();
                i = 0;
                for (Semaphore s : EventManager.access$300(EventManager.this)) {
                    s.release();
                    ++i;
                }
                this.log.debug("Event Manager thread done, released {} pending flushes", (Object)i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            try {
                try {
                    this.threadDone.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.threadDone.release();
                    return;
                }
            }
            finally {
                this.threadDone.release();
            }
        }
    }
}

