/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.satisfiabilitychecker;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.example.satisfiabilitychecker.SatisfiabilityCheckerOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.misc.version.VersionTracker;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatisfiabilityChecker {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        final SatisfiabilityCheckerOptions mainOptions = new SatisfiabilityCheckerOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.scenOptions.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        try {
            JCommander jcom;
            try {
                jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(SatisfiabilityChecker.class);
            }
            VersionTracker.logVersions();
            for (String name : jcom.getParameterFilesToRead()) {
                log.debug("Parsing (default) options from file: {} ", (Object)name);
            }
            AlgorithmExecutionConfiguration execConfig = mainOptions.getAlgorithmExecutionConfig();
            log.debug("==== Configuration====\n {} ", (Object)mainOptions);
            TargetAlgorithmEvaluator tae = null;
            File f = new File(mainOptions.outputFile);
            if (f.exists() && !mainOptions.overwriteOutputFile) {
                throw new ParameterException("Output file already exists. Use --overwrite-output-file to overwrite already existing files");
            }
            try {
                tae = mainOptions.scenOptions.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(taeOptions);
                final List<ProblemInstance> instances = mainOptions.useTestSetInstances ? mainOptions.getTrainingAndTestProblemInstances().getTestInstances().getInstances() : mainOptions.getTrainingAndTestProblemInstances().getTrainingInstances().getInstances();
                if (execConfig.isDeterministicAlgorithm()) {
                    if (mainOptions.seed != -1L) {
                        log.warn("It is convention to use -1 as the seed for deterministic algorithms");
                    }
                } else if (mainOptions.seed == -1L) {
                    log.warn("It is convention that -1 be used as seed only for deterministic algorithms");
                }
                ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>();
                for (ProblemInstance pi : instances) {
                    pisps.add(new ProblemInstanceSeedPair(pi, mainOptions.seed));
                }
                ParameterConfigurationSpace configSpace = execConfig.getParameterConfigurationSpace();
                MersenneTwister configSpacePRNG = new MersenneTwister(mainOptions.configSeed);
                ParameterConfiguration config = configSpace.getParameterConfigurationFromString(mainOptions.config, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG);
                for (Map.Entry<String, String> entry : mainOptions.configSettingsToOverride.entrySet()) {
                    config.put(entry.getKey(), entry.getValue());
                }
                ArrayList<AlgorithmRunConfiguration> rc = new ArrayList<AlgorithmRunConfiguration>(instances.size());
                for (ProblemInstanceSeedPair pisp : pisps) {
                    rc.add(new AlgorithmRunConfiguration(pisp, config, execConfig));
                }
                TargetAlgorithmEvaluatorRunObserver obs = new TargetAlgorithmEvaluatorRunObserver(){
                    private long lastUpdate = 0L;

                    @Override
                    public synchronized void currentStatus(List<? extends AlgorithmRunResult> runs) {
                        if (System.currentTimeMillis() - this.lastUpdate < 5000L) {
                            return;
                        }
                        this.lastUpdate = System.currentTimeMillis();
                        NumberFormat nf = NumberFormat.getPercentInstance();
                        double currentTime = 0.0;
                        double maxTime = 0.0;
                        int completed = 0;
                        for (AlgorithmRunResult algorithmRunResult : runs) {
                            if (algorithmRunResult.isRunCompleted()) {
                                maxTime += algorithmRunResult.getRuntime();
                                ++completed;
                            } else {
                                maxTime += algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime();
                            }
                            currentTime += algorithmRunResult.getRuntime();
                        }
                        log.info("Current Run Information: Completion by CPU Time: {}, Completed Instances: {}/{}", new Object[]{nf.format(currentTime / maxTime), completed, runs.size()});
                    }
                };
                final AtomicReference exception = new AtomicReference();
                TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(List<AlgorithmRunResult> runs) {
                        File f = new File(mainOptions.outputFile);
                        if (f.exists() && !mainOptions.overwriteOutputFile) {
                            throw new ParameterException("Output file already exists. Use --overwrite-output-file to overwrite already existing files");
                        }
                        HashMap<ProblemInstance, AlgorithmRunResult> instanceToRunMap = new HashMap<ProblemInstance, AlgorithmRunResult>();
                        for (AlgorithmRunResult run : runs) {
                            instanceToRunMap.put(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), run);
                        }
                        log.info("Writing output to {}", (Object)f.getAbsoluteFile());
                        try (FileWriter fwrite = new FileWriter(f);){
                            for (ProblemInstance pi : instances) {
                                AlgorithmRunResult run = (AlgorithmRunResult)instanceToRunMap.get(pi);
                                fwrite.append(pi.getInstanceName() + " " + (run.getRunStatus().isDecided() ? run.getRunStatus() : "UNKNOWN") + "\n");
                            }
                        }
                        catch (IOException e) {
                            exception.set(e);
                        }
                    }

                    @Override
                    public void onFailure(RuntimeException e) {
                        exception.set(e);
                    }
                };
                WaitableTAECallback wTAE = new WaitableTAECallback(taeCallback);
                tae.evaluateRunsAsync(rc, wTAE, obs);
                if (!tae.areRunsPersisted()) {
                    wTAE.waitForCompletion();
                }
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
            }
            finally {
                if (tae != null) {
                    tae.notifyShutdown();
                }
            }
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

