/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.tae;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.example.tae.TargetAlgorithmEvaluatorRunnerOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.misc.version.VersionTracker;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAlgorithmEvaluatorRunner {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TargetAlgorithmEvaluatorRunnerOptions mainOptions = new TargetAlgorithmEvaluatorRunnerOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.scenOptions.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        try {
            JCommander jcom;
            try {
                jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(TargetAlgorithmEvaluatorRunner.class);
            }
            VersionTracker.logVersions();
            for (String name : jcom.getParameterFilesToRead()) {
                log.debug("Parsing (default) options from file: {} ", (Object)name);
            }
            AlgorithmExecutionConfiguration execConfig = mainOptions.getAlgorithmExecutionConfig();
            log.debug("==== Configuration====\n {} ", (Object)mainOptions);
            TargetAlgorithmEvaluator tae = null;
            try {
                ProblemInstance pi;
                tae = mainOptions.scenOptions.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(taeOptions);
                if (mainOptions.instanceName == null) {
                    List<ProblemInstance> instances = mainOptions.getTrainingAndTestProblemInstances().getTrainingInstances().getInstances();
                    if (instances == null || instances.size() == 0) {
                        throw new ParameterException("No instances available, please specify one manually via --instance argument");
                    }
                    switch (mainOptions.instanceSelection) {
                        case RANDOM: {
                            MersenneTwister r = new MersenneTwister();
                            pi = instances.get(((Random)r).nextInt(instances.size()));
                            break;
                        }
                        case FIRST: {
                            pi = instances.get(0);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown value for option : " + (Object)((Object)mainOptions.instanceSelection));
                        }
                    }
                } else {
                    pi = new ProblemInstance(mainOptions.instanceName);
                }
                if (execConfig.isDeterministicAlgorithm()) {
                    if (mainOptions.seed != -1L) {
                        log.warn("It is convention to use -1 as the seed for deterministic algorithms");
                    }
                } else if (mainOptions.seed == -1L) {
                    log.warn("It is convention that -1 be used as seed only for deterministic algorithms");
                }
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, mainOptions.seed);
                ParameterConfigurationSpace configSpace = execConfig.getParameterConfigurationSpace();
                MersenneTwister configSpacePRNG = new MersenneTwister(mainOptions.configSeed);
                ParameterConfiguration config = configSpace.getParameterConfigurationFromString(mainOptions.config, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG);
                for (Map.Entry<String, String> entry : mainOptions.configSettingsToOverride.entrySet()) {
                    config.put(entry.getKey(), entry.getValue());
                }
                AlgorithmRunConfiguration runConfig = new AlgorithmRunConfiguration(pisp, execConfig.getAlgorithmMaximumCutoffTime(), config, execConfig);
                TargetAlgorithmEvaluatorRunner.processRunConfig(runConfig, tae, mainOptions.killTime);
            }
            finally {
                if (tae != null) {
                    tae.notifyShutdown();
                }
            }
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processRunConfig(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluator tae, final double killTime) {
        TargetAlgorithmEvaluatorRunObserver runStatus = new TargetAlgorithmEvaluatorRunObserver(){
            private long lastUpdate = 0L;

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (System.currentTimeMillis() - this.lastUpdate < 1000L) {
                    return;
                }
                for (int i = 0; i < runs.size(); ++i) {
                    AlgorithmRunResult run = runs.get(i);
                    Object[] logArguments = new Object[]{i, run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), run.getRunStatus(), run.getRuntime()};
                    log.info("Run {} on {} has status =>  {}, {}", logArguments);
                    if (!(run.getRuntime() > killTime)) continue;
                    log.info("Dynamically killing run");
                    run.kill();
                }
                this.lastUpdate = System.currentTimeMillis();
            }
        };
        List<AlgorithmRunResult> runResults = tae.evaluateRun(Collections.singletonList(runConfig), runStatus);
        log.info("Run Completed");
        for (int i = 0; i < runResults.size(); ++i) {
            AlgorithmRunResult run = runResults.get(i);
            AlgorithmRunConfiguration resultRunConfig = run.getAlgorithmRunConfiguration();
            RunStatus runResult = run.getRunStatus();
            double runtime = run.getRuntime();
            double runLength = run.getRunLength();
            double quality = run.getQuality();
            long resultSeed = run.getResultSeed();
            long requestSeed = resultRunConfig.getProblemInstanceSeedPair().getSeed();
            String additionalData = run.getAdditionalRunData();
            if (resultSeed != requestSeed) {
                log.error("Algorithm Run Result does not have a matching seed, requested: {} , returned: {}", (Object)resultSeed, (Object)requestSeed);
            }
            String configString = resultRunConfig.getParameterConfiguration().getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX);
            Object[] logArguments = new Object[]{i, resultRunConfig.getProblemInstanceSeedPair().getProblemInstance(), configString, runResult, runtime, runLength, quality, resultSeed, additionalData};
            log.info("Run {} on {} with config: {} had the result => {}, {}, {}, {}, {}, {}", logArguments);
        }
    }
}

