/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.tae;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.example.tae.TargetAlgorithmEvaluatorRunnerNoArgumentHandler;
import ca.ubc.cs.beta.aeatk.help.HelpOptions;
import ca.ubc.cs.beta.aeatk.logging.ConsoleOnlyLoggingOptions;
import ca.ubc.cs.beta.aeatk.logging.LoggingOptions;
import ca.ubc.cs.beta.aeatk.misc.file.HomeFileUtils;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.LongGreaterThanNegativeTwoValidator;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceOptions;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterFile;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@UsageTextField(title="Target Algorithm Evaluator Running Options", description=" Utility that allows for making a single run against a target algorithm evaluator ", noarg=TargetAlgorithmEvaluatorRunnerNoArgumentHandler.class)
public class TargetAlgorithmEvaluatorRunnerOptions
extends AbstractOptions {
    @UsageTextField(defaultValues="~/.aeatk/taerunner.opt")
    @Parameter(names={"--taeRunnerDefaultsFile"}, description="file that contains default settings for TAE Runner")
    @ParameterFile(ignoreFileNotExists=true)
    public File smacDefaults = HomeFileUtils.getHomeFile(".aeatk" + File.separator + "taerunner.opt");
    @ParametersDelegate
    public ScenarioOptions scenOptions = new ScenarioOptions();
    @ParametersDelegate
    public LoggingOptions logOpts = new ConsoleOnlyLoggingOptions();
    @Parameter(names={"--instance"}, description="Instance name to test", required=false)
    public String instanceName = null;
    @Parameter(names={"--instance-selection"}, description="Determines how we select instances from the instance file")
    public InstanceSelection instanceSelection = InstanceSelection.RANDOM;
    @Parameter(names={"--seed"}, description="Seed to run instance with", validateWith=LongGreaterThanNegativeTwoValidator.class)
    public long seed = 1L;
    @Parameter(names={"--config"}, description="Configuration to run (Use DEFAULT for the default, RANDOM for a random, or otherwise -name 'value' syntax)")
    public String config = "DEFAULT";
    @Parameter(names={"--config-seed"}, description="Seed to use if we generate a RANDOM configuration")
    public int configSeed = 0;
    @DynamicParameter(names={"-P"}, description="Name value pairs in the form: (-Pname=value) of the specific configuration to override. This is useful if you'd like to change a setting of the default , or try a random with a set value)")
    public Map<String, String> configSettingsToOverride = new HashMap<String, String>();
    @Parameter(names={"--kill-time"}, description="Kill the run dynamically after this much runtime")
    public double killTime = Double.POSITIVE_INFINITY;
    @ParametersDelegate
    HelpOptions help = new HelpOptions();

    public AlgorithmExecutionConfiguration getAlgorithmExecutionConfig() {
        return this.scenOptions.algoExecOptions.getAlgorithmExecutionConfig(null);
    }

    public ProblemInstanceOptions.TrainTestInstances getTrainingAndTestProblemInstances() throws IOException {
        return this.scenOptions.getTrainingAndTestProblemInstances("./", 0L, 0L, true, false, false, false);
    }

    static enum InstanceSelection {
        FIRST,
        RANDOM;

    }
}

