/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.json.serializers;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.json.serializers.JsonDeserializerHelper;
import ca.ubc.cs.beta.aeatk.misc.version.AEATKVersionInfo;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmRunConfigurationJson {
    public static final String RC_SAMPLE_IDX = "rc-sample-idx";
    public static final String RC_PC = "rc-pc";
    public static final String RC_PISP = "rc-pisp";
    public static final String RC_CUTOFF = "rc-cutoff";
    public static final String RC_ALGO_EXEC_CONFIG = "rc-algo-exec-config";
    public static final String RC_ID = "@rc-id";

    public static class RunConfigSerializer
    extends StdSerializer<AlgorithmRunConfiguration> {
        private final ConcurrentHashMap<AlgorithmRunConfiguration, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        protected RunConfigSerializer() {
            super(AlgorithmRunConfiguration.class);
        }

        public void serialize(AlgorithmRunConfiguration value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_ALGO_EXEC_CONFIG, (Object)value.getAlgorithmExecutionConfiguration());
                jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_CUTOFF, (Object)value.getCutoffTime());
                jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_PISP, (Object)value.getProblemInstanceSeedPair());
                jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_PC, (Object)value.getParameterConfiguration());
                jgen.writeObjectField(AlgorithmRunConfigurationJson.RC_SAMPLE_IDX, (Object)0);
            }
            jgen.writeEndObject();
        }
    }

    public static class RunConfigDeserializer
    extends StdDeserializer<AlgorithmRunConfiguration> {
        private static final AtomicBoolean warnSampleIdx = new AtomicBoolean(false);
        private static final Map<ObjectCodec, Map<Integer, AlgorithmRunConfiguration>> cacheMap = Collections.synchronizedMap(new IdentityHashMap());

        protected RunConfigDeserializer() {
            super(AlgorithmRunConfiguration.class);
        }

        public AlgorithmRunConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            ProblemInstanceSeedPair pisp = null;
            AlgorithmExecutionConfiguration execConfig = null;
            ParameterConfiguration config = null;
            int sampleIdx = 0;
            double cutoffTime = Double.NEGATIVE_INFINITY;
            int rc_id = -1;
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "rc-pc": {
                        config = (ParameterConfiguration)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, ParameterConfiguration.class);
                        break;
                    }
                    case "rc-pisp": {
                        pisp = (ProblemInstanceSeedPair)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, ProblemInstanceSeedPair.class);
                        break;
                    }
                    case "rc-cutoff": {
                        cutoffTime = jp.getValueAsDouble();
                        break;
                    }
                    case "rc-algo-exec-config": {
                        execConfig = (AlgorithmExecutionConfiguration)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, AlgorithmExecutionConfiguration.class);
                        break;
                    }
                    case "rc-sample-idx": {
                        sampleIdx = jp.getIntValue();
                        break;
                    }
                    case "@rc-id": {
                        rc_id = jp.getValueAsInt();
                        break;
                    }
                }
            }
            if (sampleIdx != 0 && !warnSampleIdx.getAndSet(true)) {
                Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
                log.warn("This version of " + new AEATKVersionInfo().getProductName() + " does not support sample ids");
            }
            if (rc_id > 0 && cache.get(rc_id) != null) {
                return (AlgorithmRunConfiguration)cache.get(rc_id);
            }
            AlgorithmRunConfiguration rc = new AlgorithmRunConfiguration(pisp, cutoffTime, config, execConfig);
            if (rc_id > 0) {
                cache.put(rc_id, (Integer)((Object)rc));
            }
            return rc;
        }
    }
}

