/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class MapList<K, V>
implements Map<K, List<V>> {
    private final Map<K, List<V>> map;

    public static final <K, V> MapList<K, V> getHashMapList() {
        return new MapList(new HashMap());
    }

    public static final <K, V> MapList<K, V> getLinkedHashMapList() {
        return new MapList(new LinkedHashMap());
    }

    public static final <K, V> MapList<K, V> getTreeMapList() {
        return new MapList(new TreeMap());
    }

    public MapList(Map<K, List<V>> emptyMap) {
        if (emptyMap == null || emptyMap.size() > 0) {
            throw new IllegalArgumentException("Supplied map must be empty");
        }
        this.map = emptyMap;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("This method isn't supported");
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        throw new UnsupportedOperationException("This method isn't supported");
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> m) {
        for (Map.Entry<K, List<V>> ent : m.entrySet()) {
            this.addAllToList(ent.getKey(), (Collection)ent.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public List<V> getList(K key) {
        if (this.map.get(key) == null) {
            this.map.put(key, new ArrayList());
        }
        return this.map.get(key);
    }

    public void addToList(K key, V value) {
        if (this.map.get(key) == null) {
            this.map.put(key, new ArrayList());
        }
        this.map.get(key).add(value);
    }

    public void addAllToList(K key, Collection<V> value) {
        if (this.map.get(key) == null) {
            this.map.put(key, new ArrayList());
        }
        List<V> vList = this.map.get(key);
        vList.addAll(value);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MapList) {
            return ((MapList)o).map.equals(this.map);
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }
}

