/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.misc.model;

import ca.ubc.cs.beta.aeatk.options.RandomForestOptions;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACRandomForestHelper {
    private static final Logger log = LoggerFactory.getLogger(SMACRandomForestHelper.class);

    public static RegtreeBuildParams getRandomForestBuildParams(RandomForestOptions rfOptions, int numberOfFeatures, int[] categoricalSize, int[][] condParents, int[][][] condParentVals, Random rand) {
        int i;
        RegtreeBuildParams buildParams = new RegtreeBuildParams();
        buildParams.condParents = null;
        buildParams.splitMin = rfOptions.splitMin;
        buildParams.ratioFeatures = rfOptions.ratioFeatures;
        buildParams.logModel = rfOptions.logModel == null ? 1 : (rfOptions.logModel != false ? 1 : 0);
        buildParams.storeResponses = rfOptions.storeDataInLeaves;
        buildParams.random = rand;
        buildParams.minVariance = rfOptions.minVariance;
        if (rfOptions.brokenVarianceCalculation) {
            log.warn("Model set to use broken variance calculation, this may affect performance");
            buildParams.brokenVarianceCalculation = true;
        } else {
            buildParams.brokenVarianceCalculation = false;
        }
        buildParams.catDomainSizes = new int[categoricalSize.length + numberOfFeatures];
        System.arraycopy(categoricalSize, 0, buildParams.catDomainSizes, 0, categoricalSize.length);
        buildParams.condParents = new int[categoricalSize.length + numberOfFeatures][];
        for (i = 0; i < categoricalSize.length; ++i) {
            buildParams.condParents[i] = condParents[i];
        }
        buildParams.condParentVals = new int[categoricalSize.length + numberOfFeatures][][];
        for (i = 0; i < condParentVals.length; ++i) {
            buildParams.condParentVals[i] = condParentVals[i];
        }
        for (i = categoricalSize.length; i < buildParams.condParents.length; ++i) {
            buildParams.condParents[i] = new int[0];
            buildParams.condParentVals[i] = new int[0][0];
        }
        if (rfOptions.ignoreConditionality) {
            buildParams.condParents = null;
            buildParams.condParentVals = null;
        }
        return buildParams;
    }
}

