/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.model.builder;

import ca.ubc.cs.beta.aeatk.exceptions.TrajectoryDivergenceException;
import ca.ubc.cs.beta.aeatk.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aeatk.model.data.SanitizedModelData;
import ca.ubc.cs.beta.aeatk.options.RandomForestOptions;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class HashCodeVerifyingModelBuilder
extends BasicModelBuilder {
    public static Queue<Integer> modelHashes = new LinkedList<Integer>();
    public static Queue<Integer> preprocessedHashes = new LinkedList<Integer>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Marker runHash = MarkerFactory.getMarker((String)"RUN_HASH");

    public HashCodeVerifyingModelBuilder(SanitizedModelData mds, RandomForestOptions rfConfig, RunHistory runHistory, Random rand) {
        super(mds, rfConfig, rand);
        int forestCode = this.forest.matlabHashCode();
        this.log.trace("Random Forest Built with Hash Code: {}", (Object)forestCode);
        if (!modelHashes.isEmpty()) {
            int expected = modelHashes.poll();
            if (forestCode != expected) {
                throw new TrajectoryDivergenceException("Expected Random Forest To Be Built With Hash Code: " + expected + " vs. " + forestCode);
            }
            this.log.trace("Random Forest Hash Code Matched");
        }
        if (this.preprocessedForest != null) {
            int preprocessedCode = this.preprocessedForest.matlabHashCode();
            this.log.trace(this.runHash, "Preprocessed Forest Built with Hash Code: {}", (Object)preprocessedCode);
            if (!preprocessedHashes.isEmpty()) {
                int expected = preprocessedHashes.poll();
                if (preprocessedCode != expected) {
                    throw new TrajectoryDivergenceException("Expected Preprocessed Random Forest To Be Built With Hash Code: " + expected + " vs. " + preprocessedCode);
                }
                this.log.trace("Preprocessed Hash Code Matched");
            }
        }
    }
}

