/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.objectives;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectiveHelper {
    private final RunObjective runObj;
    private final OverallObjective intraObjective;
    private final OverallObjective interObjective;
    private final double cutoffTime;

    public ObjectiveHelper(RunObjective runObj, OverallObjective intraObjective, OverallObjective interObjective, double cutoffTime) {
        this.runObj = runObj;
        this.intraObjective = intraObjective;
        this.interObjective = interObjective;
        this.cutoffTime = cutoffTime;
    }

    public RunObjective getRunObjective() {
        return this.runObj;
    }

    public double computeObjective(List<? extends AlgorithmRunResult> runs, double capSlack) {
        ArrayList<ProblemInstance> instances = new ArrayList<ProblemInstance>(runs.size());
        ConcurrentHashMap map = new ConcurrentHashMap();
        ConcurrentHashMap performance = new ConcurrentHashMap();
        double remainingCapSlack = capSlack;
        for (AlgorithmRunResult algorithmRunResult : runs) {
            ProblemInstance pi = algorithmRunResult.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance();
            instances.add(pi);
            map.putIfAbsent(pi, new ArrayList());
            performance.putIfAbsent(pi, new ArrayList());
            ((List)map.get(pi)).add(algorithmRunResult.getAlgorithmRunConfiguration().getProblemInstanceSeedPair());
            double obj = this.runObj.getObjective(algorithmRunResult);
            obj -= remainingCapSlack;
            if (obj < 0.0) {
                remainingCapSlack = -obj;
                obj = 0.0;
            } else {
                remainingCapSlack = 0.0;
            }
            ((List)performance.get(pi)).add(obj);
        }
        ArrayList<Double> intraInstanceObjectiveValues = new ArrayList<Double>(instances.size());
        for (Map.Entry prefEnt : performance.entrySet()) {
            intraInstanceObjectiveValues.add(this.intraObjective.aggregate((Collection)prefEnt.getValue(), this.cutoffTime));
        }
        return this.interObjective.aggregate(intraInstanceObjectiveValues, this.cutoffTime);
    }

    public double computeObjective(List<? extends AlgorithmRunResult> runs) {
        return this.computeObjective(runs, 0.0);
    }
}

