/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.options.docgen;

import ca.ubc.cs.beta.aeatk.misc.options.DomainDisplay;
import ca.ubc.cs.beta.aeatk.misc.options.NoArgumentHandler;
import ca.ubc.cs.beta.aeatk.misc.options.NoopNoArgumentHandler;
import ca.ubc.cs.beta.aeatk.misc.options.OptionLevel;
import ca.ubc.cs.beta.aeatk.misc.options.UsageSection;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UsageSectionGenerator {
    public static final String FILE_DOMAIN = "FILES";
    private static boolean hasSlept = false;

    public static List<UsageSection> getUsageSections(Object o) {
        try {
            LinkedHashSet<Object> objectsToScan = new LinkedHashSet<Object>();
            LinkedHashMap<Object, Set<Object>> parentToChildMap = new LinkedHashMap<Object, Set<Object>>();
            LinkedHashMap<String, Object> classesToScan = new LinkedHashMap<String, Object>();
            HashSet<Object> related = new HashSet<Object>();
            UsageSectionGenerator.getAllObjects(o, classesToScan, parentToChildMap, related);
            objectsToScan.addAll(classesToScan.values());
            Set<String> claimRequired = UsageSectionGenerator.getAllClaimedRequired(objectsToScan);
            ArrayList<UsageSection> sections = new ArrayList<UsageSection>();
            for (Object e : objectsToScan) {
                UsageTextField utf = UsageSectionGenerator.getLatexField(e);
                NoArgumentHandler handler = new NoopNoArgumentHandler();
                if (utf == null) {
                    System.err.println("Class " + e.getClass() + " does not have a UsageTextField annotation, this is very ugly for users to deal. Sleeping for 5 seconds");
                    if (!hasSlept) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                        hasSlept = true;
                    }
                } else {
                    try {
                        handler = utf.noarg().newInstance();
                    }
                    catch (InstantiationException e3) {
                        System.err.println("Couldn't create no-argument handler, are you sure that it has default (zero-argument) constructor :" + e3.getMessage());
                        throw e3;
                    }
                }
                String title = UsageSectionGenerator.getTitleForObject(e);
                String titleBanner = UsageSectionGenerator.getSectionBannerForObject(e);
                String sectionDescription = UsageSectionGenerator.getDescriptionForObject(e);
                boolean isHidden = UsageSectionGenerator.isHiddenSection(e);
                UsageSection sec = new UsageSection(title, titleBanner, sectionDescription, isHidden, e, handler, related.contains(e));
                sections.add(sec);
                for (Field f : e.getClass().getDeclaredFields()) {
                    OptionLevel level;
                    String name;
                    boolean notAccessible;
                    boolean bl = notAccessible = !f.isAccessible();
                    if (notAccessible) {
                        f.setAccessible(true);
                    }
                    if (f.isAnnotationPresent(Parameter.class)) {
                        String[] possibleAliases;
                        Parameter param = UsageSectionGenerator.getParameterAnnotation(f);
                        name = UsageSectionGenerator.getNameForField(f);
                        String defaultValue = UsageSectionGenerator.getDefaultValueForField(f, e);
                        String description = UsageSectionGenerator.getDescriptionForField(f, e);
                        boolean required = UsageSectionGenerator.getRequiredForField(f, e);
                        level = UsageSectionGenerator.getLevelForField(f, e);
                        String aliases = UsageSectionGenerator.getAliases(f, e);
                        for (String possibleAlias : possibleAliases = aliases.split(",\\s+")) {
                            if (!claimRequired.contains(possibleAlias.trim())) continue;
                            required = true;
                        }
                        String domain = UsageSectionGenerator.getDomain(f, e);
                        boolean hidden = param.hidden();
                        sec.addAttribute(name, description, defaultValue, required, domain, aliases, hidden, level);
                    }
                    if (f.isAnnotationPresent(DynamicParameter.class)) {
                        String[] possibleAliases;
                        DynamicParameter dynamicParam = UsageSectionGenerator.getDynamicParameterAnnotation(f);
                        name = UsageSectionGenerator.getNameForDynamicField(f);
                        String description = UsageSectionGenerator.getDescriptionForDynamicField(f, e);
                        boolean required = UsageSectionGenerator.getRequiredForDynamicField(f, e);
                        String aliases = UsageSectionGenerator.getDynamicAliases(f, e);
                        level = UsageSectionGenerator.getLevelForField(f, e);
                        for (String possibleAlias : possibleAliases = aliases.split("\\s+")) {
                            if (!claimRequired.contains(possibleAlias.trim())) continue;
                            required = true;
                        }
                        String domain = UsageSectionGenerator.getDomain(f, e);
                        boolean hidden = dynamicParam.hidden();
                        sec.addAttribute(name, description, "", required, domain, aliases, hidden, level);
                    }
                    if (notAccessible) continue;
                    f.setAccessible(false);
                }
            }
            ArrayList<UsageSection> returningSec = new ArrayList<UsageSection>();
            ArrayList<UsageSection> arrayList = new ArrayList<UsageSection>();
            for (UsageSection sec : sections) {
                Object parent = sec.getObject();
                for (UsageSection sec2 : sections) {
                    Object child = sec2.getObject();
                    if (parentToChildMap.get(parent) == null || !((Set)parentToChildMap.get(parent)).contains(child) || !sec2.isSectionHidden()) continue;
                    for (String secName : sec2) {
                        sec.addAttribute(secName, sec2.getAttributeDescription(secName), sec2.getAttributeDefaultValues(secName), sec2.isAttributeRequired(secName), sec2.getAttributeDomain(secName), sec2.getAttributeAliases(secName), sec2.isAttributeHidden(secName), sec2.getAttributeLevel(secName));
                    }
                }
                if (sec.isSectionHidden()) continue;
                if (related.contains(parent)) {
                    arrayList.add(sec);
                    continue;
                }
                returningSec.add(sec);
            }
            returningSec.addAll(arrayList);
            return returningSec;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected Exception Occurred ", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unexpected Exception Occurred ", e);
        }
    }

    public static List<UsageSection> getUsageSections(Object o, Map<String, AbstractOptions> options) {
        ArrayList<Object> allOptions = new ArrayList<Object>();
        allOptions.add(o);
        for (Map.Entry<String, AbstractOptions> ent : options.entrySet()) {
            if (ent.getValue() == null) continue;
            allOptions.add(ent.getValue());
        }
        return UsageSectionGenerator.getUsageSections(allOptions.toArray());
    }

    private static void getAllObjects(Object o, Map<String, Object> objectsToScan, Map<Object, Set<Object>> parentToChildMap, Set<Object> related) {
        block12: {
            if (parentToChildMap.get(o) == null) {
                parentToChildMap.put(o, new HashSet());
            }
            try {
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        UsageSectionGenerator.getAllObjects(Array.get(o, i), objectsToScan, parentToChildMap, related);
                    }
                    break block12;
                }
                Object previousValue = objectsToScan.put(o.getClass().getCanonicalName(), o);
                if (previousValue != null) {
                    return;
                }
                for (Field f : o.getClass().getDeclaredFields()) {
                    boolean markInaccessible = !f.isAccessible();
                    f.setAccessible(true);
                    if (f.isAnnotationPresent(ParametersDelegate.class)) {
                        parentToChildMap.get(o).add(f.get(o));
                        if (related.contains(o)) {
                            related.add(f.get(o));
                        }
                        UsageSectionGenerator.getAllObjects(f.get(o), objectsToScan, parentToChildMap, related);
                    }
                    if (f.isAnnotationPresent(UsageTextField.class)) {
                        UsageTextField utf = f.getAnnotation(UsageTextField.class);
                        if (utf.converterFileOptions().equals(Object.class)) continue;
                        try {
                            Object o2 = utf.converterFileOptions().newInstance();
                            related.add(o2);
                            UsageSectionGenerator.getAllObjects(o2, objectsToScan, parentToChildMap, related);
                        }
                        catch (InstantiationException e) {
                            System.err.println("Couldn't create new instance of " + utf.converterFileOptions().getCanonicalName() + " this class needs to have a default (zero-arg) constructor if it is to be a related option");
                        }
                    }
                    f.setAccessible(markInaccessible);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unexpected Exception Occurred ", e);
            }
        }
    }

    private static Set<String> getAllClaimedRequired(Set<Object> objectsToScan) {
        HashSet<String> claimRequired = new HashSet<String>();
        for (Object o : objectsToScan) {
            if (!o.getClass().isAnnotationPresent(UsageTextField.class)) continue;
            UsageTextField t = o.getClass().getAnnotation(UsageTextField.class);
            claimRequired.addAll(Arrays.asList(t.claimRequired()));
        }
        return claimRequired;
    }

    private static boolean getRequiredForField(Field f, Object o) {
        return UsageSectionGenerator.getParameterAnnotation(f).required();
    }

    private static String getDescriptionForField(Field f, Object o) {
        return UsageSectionGenerator.getParameterAnnotation(f).description();
    }

    private static boolean getRequiredForDynamicField(Field f, Object o) {
        return UsageSectionGenerator.getDynamicParameterAnnotation(f).required();
    }

    private static String getDescriptionForDynamicField(Field f, Object o) {
        return UsageSectionGenerator.getDynamicParameterAnnotation(f).description();
    }

    private static String getDefaultValueForField(Field f, Object o) throws IllegalArgumentException, IllegalAccessException {
        UsageTextField latexAnnotation = UsageSectionGenerator.getLatexField(f);
        if (latexAnnotation == null || latexAnnotation.defaultValues().equals("<NOT SET>")) {
            Object value = f.get(o);
            if (value != null) {
                return value.toString();
            }
            return "null";
        }
        return latexAnnotation.defaultValues();
    }

    private static String getNameForDynamicField(Field f) {
        return UsageSectionGenerator.getDynamicParameterAnnotation(f).names()[0];
    }

    private static String getNameForField(Field f) {
        return UsageSectionGenerator.getParameterAnnotation(f).names()[0];
    }

    private static String getAliases(Field f, Object o) {
        return Arrays.toString(UsageSectionGenerator.getParameterAnnotation(f).names()).replaceAll("\\[", "").replaceAll("\\]", "");
    }

    private static String getDynamicAliases(Field f, Object o) {
        return Arrays.toString(UsageSectionGenerator.getDynamicParameterAnnotation(f).names()).replaceAll("\\[", "").replaceAll("\\]", "");
    }

    private static String getDomain(Field f, Object o) throws InstantiationException, IllegalAccessException {
        Object value;
        UsageTextField latex = UsageSectionGenerator.getLatexField(f);
        if (latex != null && !latex.domain().equals("<NOT SET>")) {
            return latex.domain();
        }
        if (UsageSectionGenerator.getParameterAnnotation(f) != null) {
            if (DomainDisplay.class.isAssignableFrom(UsageSectionGenerator.getParameterAnnotation(f).converter())) {
                return ((DomainDisplay)UsageSectionGenerator.getParameterAnnotation(f).converter().newInstance()).getDomain();
            }
            if (DomainDisplay.class.isAssignableFrom(UsageSectionGenerator.getParameterAnnotation(f).validateWith())) {
                return ((DomainDisplay)UsageSectionGenerator.getParameterAnnotation(f).validateWith().newInstance()).getDomain();
            }
        }
        if ((value = f.get(o)) != null) {
            return UsageSectionGenerator.getDomainForClass(value.getClass());
        }
        return UsageSectionGenerator.getDomainForClass(f.getType());
    }

    private static String getDomainForClass(Class<?> x) {
        if (x.equals(Boolean.class)) {
            return "{true, false}";
        }
        if (Enum.class.isAssignableFrom(x)) {
            return Arrays.toString(x.getEnumConstants()).replaceAll("\\[", "{").replaceAll("\\]", "}");
        }
        if (x.equals(File.class)) {
            return FILE_DOMAIN;
        }
        return "";
    }

    private static Parameter getParameterAnnotation(Field f) {
        Parameter param = f.getAnnotation(Parameter.class);
        return param;
    }

    private static DynamicParameter getDynamicParameterAnnotation(Field f) {
        DynamicParameter param = f.getAnnotation(DynamicParameter.class);
        return param;
    }

    private static OptionLevel getLevelForField(Field f, Object obj) {
        UsageTextField latexAnnotation = UsageSectionGenerator.getLatexField(f);
        if (latexAnnotation != null) {
            return latexAnnotation.level();
        }
        UsageTextField objUTF = obj.getClass().getAnnotation(UsageTextField.class);
        if (objUTF != null) {
            return objUTF.level();
        }
        return OptionLevel.BASIC;
    }

    private static String getTitleForObject(Object obj) {
        UsageTextField f = UsageSectionGenerator.getLatexField(obj);
        if (f == null) {
            return "";
        }
        return f.title();
    }

    private static String getSectionBannerForObject(Object obj) {
        UsageTextField f = UsageSectionGenerator.getLatexField(obj);
        if (f == null) {
            return "*****[  ]*******";
        }
        return f.titlebanner();
    }

    private static String getDescriptionForObject(Object obj) {
        UsageTextField f = UsageSectionGenerator.getLatexField(obj);
        if (f == null) {
            return "";
        }
        return f.description();
    }

    private static boolean isHiddenSection(Object obj) {
        UsageTextField f = UsageSectionGenerator.getLatexField(obj);
        if (f == null) {
            return false;
        }
        return f.hiddenSection();
    }

    private static UsageTextField getLatexField(Object obj) {
        if (obj instanceof Field) {
            UsageTextField f = ((Field)obj).getAnnotation(UsageTextField.class);
            return f;
        }
        if (obj.getClass().isAnnotationPresent(UsageTextField.class)) {
            UsageTextField f = obj.getClass().getAnnotation(UsageTextField.class);
            return f;
        }
        return null;
    }
}

