/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import ca.ubc.cs.beta.aeatk.json.serializers.ParameterConfigurationSpaceJson;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.NormalizedRange;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@JsonDeserialize(using=ParameterConfigurationSpaceJson.ParamConfigurationDeserializer.class)
@JsonSerialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSerializer.class)
public class ParameterConfiguration
implements Map<String, String>,
Serializable {
    private static final long serialVersionUID = 879997991870028528L;
    private final Map<String, Integer> paramKeyToValueArrayIndexMap;
    private final boolean[] parameterDomainContinuous;
    private final int[] categoricalSize;
    private final ParameterConfigurationSpace configSpace;
    private final double[] valueArray;
    private volatile boolean isDirty = true;
    private final boolean[] activeParams;
    private final double[] valueArrayForComparsion;
    private volatile Map<String, String> builtMap = null;
    boolean hashSet = false;
    int lastHash = 0;
    private volatile Set<String> activeParameters;
    private static final AtomicInteger idPool = new AtomicInteger(0);
    private int myID;
    private static final double EPSILON = Math.pow(10.0, -14.0);

    ParameterConfiguration(ParameterConfigurationSpace configSpace, double[] valueArray, int[] categoricalSize, boolean[] parameterDomainContinuous, Map<String, Integer> paramKeyToValueArrayIndexMap) {
        this.configSpace = configSpace;
        this.valueArray = valueArray;
        this.categoricalSize = categoricalSize;
        this.parameterDomainContinuous = parameterDomainContinuous;
        this.paramKeyToValueArrayIndexMap = paramKeyToValueArrayIndexMap;
        this.myID = idPool.incrementAndGet();
        this.activeParams = new boolean[valueArray.length];
        this.isDirty = true;
        this.valueArrayForComparsion = new double[valueArray.length];
    }

    public ParameterConfiguration(ParameterConfiguration oConfig) {
        if (oConfig.isDirty) {
            oConfig.cleanUp();
        }
        this.isDirty = oConfig.isDirty;
        this.myID = oConfig.myID;
        this.configSpace = oConfig.configSpace;
        this.valueArray = (double[])oConfig.valueArray.clone();
        this.categoricalSize = oConfig.categoricalSize;
        this.parameterDomainContinuous = oConfig.parameterDomainContinuous;
        this.paramKeyToValueArrayIndexMap = oConfig.paramKeyToValueArrayIndexMap;
        this.activeParams = (boolean[])oConfig.activeParams.clone();
        this.activeParameters = oConfig.activeParameters;
        this.valueArrayForComparsion = (double[])oConfig.valueArrayForComparsion.clone();
        this.lastHash = oConfig.lastHash;
    }

    @Override
    public int size() {
        return this.valueArray.length;
    }

    @Override
    public boolean isEmpty() {
        return this.valueArray.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.paramKeyToValueArrayIndexMap.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getRealMap().containsValue(value);
    }

    @Override
    public String get(Object key) {
        Integer index = this.paramKeyToValueArrayIndexMap.get(key);
        if (index == null) {
            return null;
        }
        double value = this.valueArray[index];
        if (Double.isNaN(value)) {
            return null;
        }
        if (this.parameterDomainContinuous[index]) {
            NormalizedRange range = this.configSpace.getNormalizedRangeMap().get(key);
            if (range.isIntegerOnly()) {
                return String.valueOf(Math.round(range.unnormalizeValue(value)));
            }
            return String.valueOf(range.unnormalizeValue(value));
        }
        if (value == 0.0) {
            return null;
        }
        return this.configSpace.getValuesMap().get(key).get((int)value - 1);
    }

    @Override
    public String put(String key, String newValue) {
        this.isDirty = true;
        this.builtMap = null;
        Integer index = this.paramKeyToValueArrayIndexMap.get(key);
        if (index == null) {
            throw new IllegalArgumentException("This key does not exist in the Parameter Space: " + key);
        }
        String oldValue = this.get(key);
        if (newValue == null) {
            this.valueArray[index.intValue()] = Double.NaN;
        } else if (this.parameterDomainContinuous[index]) {
            this.valueArray[index.intValue()] = this.configSpace.getNormalizedRangeMap().get(key).normalizeValue(Double.valueOf(newValue));
        } else {
            List<String> inOrderValues = this.configSpace.getValuesMap().get(key);
            int i = 1;
            boolean valueFound = false;
            for (String possibleValue : inOrderValues) {
                if (possibleValue.equals(newValue)) {
                    this.valueArray[index.intValue()] = i;
                    valueFound = true;
                    break;
                }
                ++i;
            }
            if (!valueFound) {
                throw new IllegalArgumentException("Value is not legal for this parameter: " + key + " Value:" + newValue);
            }
        }
        if (this.parameterDomainContinuous[index] && newValue != null) {
            double d2;
            double d1 = Double.valueOf(this.get(key));
            if (Math.abs(d1 / (d2 = Double.valueOf(newValue).doubleValue()) - 1.0) > Math.pow(10.0, -12.0)) {
                System.out.println("Warning got the following value back from map " + this.get(key) + " put " + newValue + " in");
            }
        } else if (this.get(key) == null ? newValue != null : !this.get(key).equals(newValue)) {
            throw new IllegalStateException("Not Sure Why this happened: " + this.get(key) + " vs. " + newValue);
        }
        return oldValue;
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> ent : m.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String s : this.paramKeyToValueArrayIndexMap.keySet()) {
            keys.add(s);
        }
        return keys;
    }

    @Override
    public Collection<String> values() {
        return this.getRealMap().values();
    }

    private Map<String, String> getRealMap() {
        if (this.builtMap == null) {
            LinkedHashMap<String, String> myMap = new LinkedHashMap<String, String>();
            for (String name : this.configSpace.getParameterNamesInAuthorativeOrder()) {
                myMap.put(name, this.get(name));
            }
            this.builtMap = Collections.unmodifiableMap(myMap);
        }
        return this.builtMap;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getRealMap().entrySet();
    }

    public double[] toValueArray() {
        return (double[])this.valueArray.clone();
    }

    public double[] toComparisonValueArray() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return (double[])this.valueArrayForComparsion.clone();
    }

    public String toString() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return this.getFriendlyIDHex();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterConfiguration) {
            ParameterConfiguration opc = (ParameterConfiguration)o;
            if (this.isDirty) {
                this.cleanUp();
            }
            if (opc.isDirty) {
                opc.cleanUp();
            }
            if (!this.configSpace.equals(opc.configSpace)) {
                return false;
            }
            for (int i = 0; i < this.valueArrayForComparsion.length; ++i) {
                if (!(Math.abs(this.valueArrayForComparsion[i] - opc.valueArrayForComparsion[i]) > EPSILON)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isDirty || !this.hashSet) {
            if (this.isDirty) {
                this.cleanUp();
            }
            float[] values = new float[this.valueArrayForComparsion.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (float)this.valueArrayForComparsion[i];
            }
            this.lastHash = Arrays.hashCode(values);
            this.hashSet = true;
        }
        return this.lastHash;
    }

    @Deprecated
    public String getFormattedParameterString(String preKey, String keyValSeperator, String valueDelimiter, String glue) {
        return this._getFormattedParameterString(preKey, keyValSeperator, valueDelimiter, glue, true);
    }

    protected String _getFormattedParameterString(String preKey, String keyValSeperator, String valueDelimiter, String glue, boolean hideInactiveParameters) {
        Set<String> activeParams = this.getActiveParameters();
        StringBuilder sb = new StringBuilder();
        boolean isFirstParameterInString = true;
        for (String key : this.keySet()) {
            if (this.get(key) == null || !activeParams.contains(key) && hideInactiveParameters) continue;
            if (!isFirstParameterInString) {
                sb.append(glue);
            }
            isFirstParameterInString = false;
            sb.append(preKey).append(key).append(keyValSeperator).append(valueDelimiter).append(this.get(key)).append(valueDelimiter);
        }
        return sb.toString();
    }

    @Deprecated
    public String getFormattedParameterString() {
        return this._getFormattedParameterString("-", " ", "'", " ", true);
    }

    public String getFormattedParameterString(ParameterStringFormat stringFormat) {
        double[] valueArray = this.valueArray;
        switch (stringFormat) {
            case FIXED_WIDTH_ARRAY_STRING_MASK_INACTIVE_SYNTAX: {
                if (this.isDirty) {
                    this.cleanUp();
                }
                valueArray = this.valueArrayForComparsion;
            }
            case FIXED_WIDTH_ARRAY_STRING_SYNTAX: {
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                for (int i = 0; i < valueArray.length; ++i) {
                    pWriter.format("%20s", valueArray[i]);
                    if (i + 1 == valueArray.length) continue;
                    pWriter.append(",");
                }
                return sWriter.toString();
            }
            case ARRAY_STRING_MASK_INACTIVE_SYNTAX: {
                if (this.isDirty) {
                    this.cleanUp();
                }
                valueArray = this.valueArrayForComparsion;
            }
            case ARRAY_STRING_SYNTAX: {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < valueArray.length; ++i) {
                    sb.append(valueArray[i]);
                    if (i + 1 == valueArray.length) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            case NODB_OR_STATEFILE_SYNTAX: {
                return this.getFormattedParameterString(ParameterStringFormat.NODB_SYNTAX);
            }
        }
        return this._getFormattedParameterString(stringFormat.getPreKey(), stringFormat.getKeyValueSeperator(), stringFormat.getValueDelimeter(), stringFormat.getGlue(), stringFormat.hideInactiveParameters());
    }

    public List<ParameterConfiguration> getNeighbourhood(Random rand, int numNumericalNeighbours) {
        ArrayList<ParameterConfiguration> neighbours = new ArrayList<ParameterConfiguration>(this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours));
        Set<String> activeParams = this.getActiveParameters();
        for (int i = 0; i < this.configSpace.getParameterNamesInAuthorativeOrder().size(); ++i) {
            double[] newValueArray = (double[])this.valueArray.clone();
            for (int j = 1; j <= this.numberOfNeighboursForParameter(i, activeParams.contains(this.configSpace.getParameterNamesInAuthorativeOrder().get(i)), numNumericalNeighbours); ++j) {
                newValueArray[i] = this.getNeighbourForParameter(i, j, rand);
                if (this.configSpace.isForbiddenParameterConfiguration(newValueArray)) continue;
                neighbours.add(new ParameterConfiguration(this.configSpace, (double[])newValueArray.clone(), this.categoricalSize, this.parameterDomainContinuous, this.paramKeyToValueArrayIndexMap));
            }
        }
        if (neighbours.size() > this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours)) {
            throw new IllegalStateException("Expected " + this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours) + " neighbours (should be greater than or equal to) but got " + neighbours.size());
        }
        return neighbours;
    }

    public boolean isNeighbour(ParameterConfiguration oConfig) {
        if (!oConfig.getParameterConfigurationSpace().equals(this.getParameterConfigurationSpace())) {
            return false;
        }
        if (this.isDirty) {
            this.cleanUp();
        }
        if (oConfig.isDirty) {
            oConfig.cleanUp();
        }
        int differences = 0;
        for (int i = 0; i < this.activeParams.length; ++i) {
            if (!this.activeParams[i] || !oConfig.activeParams[i] || this.valueArrayForComparsion[i] == oConfig.valueArrayForComparsion[i]) continue;
            ++differences;
        }
        return differences == 1;
    }

    private int numberOfNeighboursExcludingForbidden(int numNumericalNeighbours) {
        int neighbours = 0;
        Set<String> activeParams = this.getActiveParameters();
        for (int i = 0; i < this.configSpace.getParameterNamesInAuthorativeOrder().size(); ++i) {
            neighbours += this.numberOfNeighboursForParameter(i, activeParams.contains(this.configSpace.getParameterNamesInAuthorativeOrder().get(i)), numNumericalNeighbours);
        }
        return neighbours;
    }

    private int numberOfNeighboursForParameter(int valueArrayIndex, boolean isParameterActive, int neighboursForNumericalParameters) {
        if (!isParameterActive) {
            return 0;
        }
        if (this.configSpace.searchSubspaceActive[valueArrayIndex]) {
            return 0;
        }
        if (this.parameterDomainContinuous[valueArrayIndex]) {
            return neighboursForNumericalParameters;
        }
        return this.categoricalSize[valueArrayIndex] - 1;
    }

    private double getNeighbourForParameter(int valueArrayIndex, int neighbourNumber, Random rand) {
        if (this.parameterDomainContinuous[valueArrayIndex]) {
            double randValue;
            double mean = this.valueArray[valueArrayIndex];
            while (!((randValue = 0.2 * rand.nextGaussian() + mean) >= 0.0) || !(randValue <= 1.0)) {
            }
            return randValue;
        }
        if ((double)neighbourNumber < this.valueArray[valueArrayIndex]) {
            return neighbourNumber;
        }
        return neighbourNumber + 1;
    }

    private void cleanUp() {
        Set<String> activeParams = this._getActiveParameters();
        for (Map.Entry<String, Integer> keyVal : this.paramKeyToValueArrayIndexMap.entrySet()) {
            this.activeParams[keyVal.getValue().intValue()] = activeParams.contains(keyVal.getKey());
            if (this.activeParams[keyVal.getValue()]) {
                if (this.parameterDomainContinuous[keyVal.getValue()]) {
                    this.valueArrayForComparsion[keyVal.getValue().intValue()] = this.valueArray[keyVal.getValue()];
                    continue;
                }
                this.valueArrayForComparsion[keyVal.getValue().intValue()] = this.valueArray[keyVal.getValue()];
                continue;
            }
            this.valueArrayForComparsion[keyVal.getValue().intValue()] = Double.NaN;
        }
        this.myID = idPool.incrementAndGet();
        this.activeParameters = Collections.unmodifiableSet(activeParams);
        this.isDirty = false;
    }

    public Set<String> getActiveParameters() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return this.activeParameters;
    }

    private Set<String> _getActiveParameters() {
        boolean activeSetChanged = false;
        TreeSet<String> activeParams = new TreeSet<String>();
        do {
            activeSetChanged = false;
            List<String> paramNames = this.configSpace.getParameterNames();
            for (String candidateParam : paramNames) {
                if (activeParams.contains(candidateParam)) continue;
                Map<String, List<String>> dependentOn = this.configSpace.getDependentValuesMap().get(candidateParam);
                if (dependentOn != null) {
                    boolean dependentValuesSatified = true;
                    for (String dependentParamName : dependentOn.keySet()) {
                        if (activeParams.contains(dependentParamName)) {
                            if (dependentOn.get(dependentParamName).contains(this.get(dependentParamName))) continue;
                            dependentValuesSatified = false;
                            break;
                        }
                        dependentValuesSatified = false;
                        break;
                    }
                    if (!dependentValuesSatified) continue;
                    activeSetChanged = true;
                    activeParams.add(candidateParam);
                    continue;
                }
                if (!activeParams.add(candidateParam)) continue;
                activeSetChanged = true;
            }
        } while (activeSetChanged);
        return activeParams;
    }

    public int getFriendlyID() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return this.myID;
    }

    public String getFriendlyIDHex() {
        String hex = Integer.toHexString(this.getFriendlyID());
        StringBuilder sb = new StringBuilder("0x");
        while (hex.length() + sb.length() < 6) {
            sb.append("0");
        }
        sb.append(hex.toUpperCase());
        return sb.toString();
    }

    public boolean isForbiddenParameterConfiguration() {
        return this.configSpace.isForbiddenParameterConfiguration(this.valueArray);
    }

    public ParameterConfigurationSpace getParameterConfigurationSpace() {
        return this.configSpace;
    }

    public boolean isInSearchSubspace() {
        for (int i = 0; i < this.valueArray.length; ++i) {
            if (!this.configSpace.searchSubspaceActive[i] || !(Math.abs(this.valueArray[i] - this.configSpace.searchSubspaceValues[i]) > EPSILON)) continue;
            return false;
        }
        return true;
    }

    public static enum ParameterStringFormat {
        NODB_SYNTAX("-", " ", "'", " ", true),
        NODB_SYNTAX_WITH_INDEX("-", " ", "'", " ", true),
        STATEFILE_SYNTAX(" ", "=", "'", ",", false),
        STATEFILE_SYNTAX_WITH_INDEX(" ", "=", "'", ",", false),
        STATEFILE_SYNTAX_NO_INACTIVE(" ", "=", "'", ",", true),
        SURROGATE_EXECUTOR("-P", "=", "", " ", true),
        ARRAY_STRING_SYNTAX("", "", "", "", false),
        ARRAY_STRING_MASK_INACTIVE_SYNTAX("", "", "", "", true),
        FIXED_WIDTH_ARRAY_STRING_SYNTAX("", "", "", "", false),
        FIXED_WIDTH_ARRAY_STRING_MASK_INACTIVE_SYNTAX("", "", "", "", true),
        NODB_OR_STATEFILE_SYNTAX("", "", "", "", true);

        private final String preKey;
        private final String keyValSeperator;
        private final String valDelimiter;
        private final String glue;
        private final boolean hideInactive;

        private ParameterStringFormat(String preKey, String keyValSeperator, String valDelimeter, String glue, boolean hideInactive) {
            this.preKey = preKey;
            this.keyValSeperator = keyValSeperator;
            this.valDelimiter = valDelimeter;
            this.glue = glue;
            this.hideInactive = hideInactive;
        }

        public boolean hideInactiveParameters() {
            return this.hideInactive;
        }

        public String getPreKey() {
            return this.preKey;
        }

        public String getGlue() {
            return this.glue;
        }

        public String getValueDelimeter() {
            return this.valDelimiter;
        }

        public String getKeyValueSeperator() {
            return this.keyValSeperator;
        }
    }
}

